/*===============================================================================================
 FSB Example
 Copyright (c), Firelight Technologies Pty, Ltd 2016.

 This example demonstrates the usage of the FSB format, generated by the FSBank tool.
 It is simply a packed file format, with sounds contained within.  This is a cross platform
 format that is useful to keep the data format optimal for the platform you are targeting.
 (ie PS2, Xbox, Gamecube have native compression formats)
===============================================================================================*/

#include <jni.h>
#include <android/log.h>
#include <stdlib.h>
#include "fmod.h"
#include "fmod_errors.h"

#define NUM_SOUNDS 3

FMOD_SYSTEM  *gSystem  = 0;
FMOD_CHANNEL *gChannel = 0;
FMOD_SOUND	 *gFSB;
int			  gIndex   = 0;

#define CHECK_RESULT(x) \
{ \
	FMOD_RESULT _result = x; \
	if (_result != FMOD_OK) \
	{ \
		__android_log_print(ANDROID_LOG_ERROR, "fmod", "FMOD error! (%d) %s\n%s:%d", _result, FMOD_ErrorString(_result), __FILE__, __LINE__); \
		exit(-1); \
	} \
}

void Java_org_fmod_fsb_Example_cBegin(JNIEnv *env, jobject thiz)
{
	FMOD_RESULT result = FMOD_OK;

	result = FMOD_System_Create(&gSystem);
	CHECK_RESULT(result);

	result = FMOD_System_Init(gSystem, 32, FMOD_INIT_NORMAL, 0);
	CHECK_RESULT(result);

	result = FMOD_System_CreateSound(gSystem, "/sdcard/fmod/example.fsb", FMOD_DEFAULT | FMOD_LOOP_OFF, 0, &gFSB);
	CHECK_RESULT(result);
}

void Java_org_fmod_fsb_Example_cUpdate(JNIEnv *env, jobject thiz)
{
	FMOD_RESULT	result = FMOD_OK;

	result = FMOD_System_Update(gSystem);
	CHECK_RESULT(result);
}

void Java_org_fmod_fsb_Example_cEnd(JNIEnv *env, jobject thiz)
{
	FMOD_RESULT result = FMOD_OK;
	unsigned int i = 0;

	result = FMOD_Sound_Release(gFSB);
	CHECK_RESULT(result);

	result = FMOD_System_Release(gSystem);
	CHECK_RESULT(result);
}

void Java_org_fmod_fsb_Example_cPlayNextSound(JNIEnv *env, jobject thiz)
{
	FMOD_RESULT result = FMOD_OK;
	FMOD_SOUND *subsound;
	int			numsubsounds;

	result = FMOD_Sound_GetNumSubSounds(gFSB, &numsubsounds);
	CHECK_RESULT(result);

    result = FMOD_Sound_GetSubSound(gFSB, gIndex, &subsound);
    CHECK_RESULT(result);

	result = FMOD_System_PlaySound(gSystem, FMOD_CHANNEL_REUSE, subsound, 0, &gChannel);
	CHECK_RESULT(result);

	gIndex++;
	if (gIndex >= numsubsounds)
	{
		gIndex = 0;
	}
}

jint Java_org_fmod_fsb_Example_cGetNumSubsounds(JNIEnv *env, jobject thiz)
{
	FMOD_RESULT result;
	int			numsubsounds;

	result = FMOD_Sound_GetNumSubSounds(gFSB, &numsubsounds);
	CHECK_RESULT(result);

	return numsubsounds;
}

jint Java_org_fmod_fsb_Example_cGetNextSubsound(JNIEnv *env, jobject thiz)
{
	return gIndex;
}

jboolean Java_org_fmod_fsb_Example_cGetPlaying(JNIEnv *env, jobject thiz)
{
	FMOD_RESULT result = FMOD_OK;
	FMOD_BOOL playing = 0;

	if (gChannel)
	{
		result = FMOD_Channel_IsPlaying(gChannel, &playing);
		if (result != FMOD_ERR_INVALID_HANDLE && result != FMOD_ERR_CHANNEL_STOLEN)
		{
			CHECK_RESULT(result);
		}
	}

	return playing;
}

jint Java_org_fmod_fsb_Example_cGetPosition(JNIEnv *env, jobject thiz)
{
	FMOD_RESULT result = FMOD_OK;
	int position = 0;

	if (gChannel)
	{
		result = FMOD_Channel_GetPosition(gChannel, &position, FMOD_TIMEUNIT_MS);
		if (result != FMOD_ERR_INVALID_HANDLE && result != FMOD_ERR_CHANNEL_STOLEN)
		{
			CHECK_RESULT(result);
		}
	}

	return position;
}

jint Java_org_fmod_fsb_Example_cGetLength(JNIEnv *env, jobject thiz)
{
	FMOD_RESULT result = FMOD_OK;
	FMOD_SOUND *sound = 0;
	int length = 0;

	if (gChannel)
	{
		result = FMOD_Channel_GetCurrentSound(gChannel, &sound);
		if (result != FMOD_ERR_INVALID_HANDLE && result != FMOD_ERR_CHANNEL_STOLEN)
		{
			CHECK_RESULT(result);
		}
	}

	if (sound)
	{
		result = FMOD_Sound_GetLength(sound, &length, FMOD_TIMEUNIT_MS);
		CHECK_RESULT(result);
	}

	return length;
}


