// Filename: mutexSpinlockImpl.I
// Created by:  drose (11Apr06)
//
////////////////////////////////////////////////////////////////////
//
// PANDA 3D SOFTWARE
// Copyright (c) Carnegie Mellon University.  All rights reserved.
//
// All use of this software is subject to the terms of the revised BSD
// license.  You should have received a copy of this license along
// with this source code in a file named "LICENSE."
//
////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////
//     Function: MutexSpinlockImpl::Constructor
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE MutexSpinlockImpl::
MutexSpinlockImpl() {
  _lock = 0;
}

////////////////////////////////////////////////////////////////////
//     Function: MutexSpinlockImpl::Destructor
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE MutexSpinlockImpl::
~MutexSpinlockImpl() {
}

////////////////////////////////////////////////////////////////////
//     Function: MutexSpinlockImpl::acquire
//       Access: Public
//  Description: 
////////////////////////////////////////////////////////////////////
INLINE void MutexSpinlockImpl::
acquire() {
  if (!try_acquire()) {
    do_lock();
  }
}

////////////////////////////////////////////////////////////////////
//     Function: MutexSpinlockImpl::try_acquire
//       Access: Public
//  Description: 
////////////////////////////////////////////////////////////////////
INLINE bool MutexSpinlockImpl::
try_acquire() {
  return (AtomicAdjust::compare_and_exchange(_lock, 0, 1) == 0);
}

////////////////////////////////////////////////////////////////////
//     Function: MutexSpinlockImpl::release
//       Access: Public
//  Description: 
////////////////////////////////////////////////////////////////////
INLINE void MutexSpinlockImpl::
release() {
  AtomicAdjust::set(_lock, 0);
}
