// Filename: bioPtr.I
// Created by:  drose (15Oct02)
//
////////////////////////////////////////////////////////////////////
//
// PANDA 3D SOFTWARE
// Copyright (c) Carnegie Mellon University.  All rights reserved.
//
// All use of this software is subject to the terms of the revised BSD
// license.  You should have received a copy of this license along
// with this source code in a file named "LICENSE."
//
////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////
//     Function: BioPtr::Constructor
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE BioPtr::
BioPtr(BIO *bio) : _bio(bio) {
}

////////////////////////////////////////////////////////////////////
//     Function: BioPtr::operator *
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE BIO &BioPtr::
operator *() const {
  return *_bio;
}

////////////////////////////////////////////////////////////////////
//     Function: BioPtr::operator ->
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE BIO *BioPtr::
operator ->() const {
  return _bio;
}

////////////////////////////////////////////////////////////////////
//     Function: BioPtr::operator typecast
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE BioPtr::
operator BIO * () const {
  return _bio;
}

////////////////////////////////////////////////////////////////////
//     Function: BioPtr::get_bio
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE void BioPtr::
set_bio(BIO *bio) {
  _bio = bio;
}

////////////////////////////////////////////////////////////////////
//     Function: BioPtr::get_bio
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE BIO *BioPtr::
get_bio() const {
  return _bio;
}

////////////////////////////////////////////////////////////////////
//     Function: BioPtr::get_server_name
//       Access: Public
//  Description: Returns the name of the server we are (or should be)
//               connected to.
////////////////////////////////////////////////////////////////////
INLINE const string &BioPtr::
get_server_name() const {
  return _server_name;
}

////////////////////////////////////////////////////////////////////
//     Function: BioPtr::get_port
//       Access: Public
//  Description: Returns the port on which we are (or should be)
//               connected.
////////////////////////////////////////////////////////////////////
INLINE int BioPtr::
get_port() const {
  return _port;
}
