// Filename: eggMaterial.I
// Created by:  drose (29Jan99)
//
////////////////////////////////////////////////////////////////////
//
// PANDA 3D SOFTWARE
// Copyright (c) Carnegie Mellon University.  All rights reserved.
//
// All use of this software is subject to the terms of the revised BSD
// license.  You should have received a copy of this license along
// with this source code in a file named "LICENSE."
//
////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////
//     Function: EggMaterial::set_diff
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE void EggMaterial::
set_diff(const LColor &diff) {
  _diff = diff;
  _flags |= F_diff;
}

////////////////////////////////////////////////////////////////////
//     Function: EggMaterial::clear_diff
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE void EggMaterial::
clear_diff() {
  _flags &= ~F_diff;
}

////////////////////////////////////////////////////////////////////
//     Function: EggMaterial::has_diff
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE bool EggMaterial::
has_diff() const {
  return (_flags & F_diff) != 0;
}

////////////////////////////////////////////////////////////////////
//     Function: EggMaterial::get_diff
//       Access: Public
//  Description: It is legal to call this even if has_diff() returns
//               false.  If so, it simply returns the default diff
//               color.
////////////////////////////////////////////////////////////////////
INLINE LColor EggMaterial::
get_diff() const {
  if (has_diff()) {
    return _diff;
  } else {
    return LColor(1.0, 1.0, 1.0, 1.0);
  }
}

////////////////////////////////////////////////////////////////////
//     Function: EggMaterial::set_amb
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE void EggMaterial::
set_amb(const LColor &amb) {
  _amb = amb;
  _flags |= F_amb;
}

////////////////////////////////////////////////////////////////////
//     Function: EggMaterial::clear_amb
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE void EggMaterial::
clear_amb() {
  _flags &= ~F_amb;
}

////////////////////////////////////////////////////////////////////
//     Function: EggMaterial::has_amb
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE bool EggMaterial::
has_amb() const {
  return (_flags & F_amb) != 0;
}

////////////////////////////////////////////////////////////////////
//     Function: EggMaterial::get_amb
//       Access: Public
//  Description: It is legal to call this even if has_amb() returns
//               false.  If so, it simply returns the default amb
//               color.
////////////////////////////////////////////////////////////////////
INLINE LColor EggMaterial::
get_amb() const {
  if (has_amb()) {
    return _amb;
  } else {
    return LColor(1.0, 1.0, 1.0, 1.0);
  }
}

////////////////////////////////////////////////////////////////////
//     Function: EggMaterial::set_emit
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE void EggMaterial::
set_emit(const LColor &emit) {
  _emit = emit;
  _flags |= F_emit;
}

////////////////////////////////////////////////////////////////////
//     Function: EggMaterial::clear_emit
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE void EggMaterial::
clear_emit() {
  _flags &= ~F_emit;
}

////////////////////////////////////////////////////////////////////
//     Function: EggMaterial::has_emit
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE bool EggMaterial::
has_emit() const {
  return (_flags & F_emit) != 0;
}

////////////////////////////////////////////////////////////////////
//     Function: EggMaterial::get_emit
//       Access: Public
//  Description: It is legal to call this even if has_emit() returns
//               false.  If so, it simply returns the default emit
//               color.
////////////////////////////////////////////////////////////////////
INLINE LColor EggMaterial::
get_emit() const {
  if (has_emit()) {
    return _emit;
  } else {
    return LColor(0.0, 0.0, 0.0, 1.0);
  }
}

////////////////////////////////////////////////////////////////////
//     Function: EggMaterial::set_spec
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE void EggMaterial::
set_spec(const LColor &spec) {
  _spec = spec;
  _flags |= F_spec;
}

////////////////////////////////////////////////////////////////////
//     Function: EggMaterial::clear_spec
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE void EggMaterial::
clear_spec() {
  _flags &= ~F_spec;
}

////////////////////////////////////////////////////////////////////
//     Function: EggMaterial::has_spec
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE bool EggMaterial::
has_spec() const {
  return (_flags & F_spec) != 0;
}

////////////////////////////////////////////////////////////////////
//     Function: EggMaterial::get_spec
//       Access: Public
//  Description: It is legal to call this even if has_spec() returns
//               false.  If so, it simply returns the default spec
//               color.
////////////////////////////////////////////////////////////////////
INLINE LColor EggMaterial::
get_spec() const {
  if (has_spec()) {
    return _spec;
  } else {
    return LColor(0.0, 0.0, 0.0, 1.0);
  }
}

////////////////////////////////////////////////////////////////////
//     Function: EggMaterial::set_shininess
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE void EggMaterial::
set_shininess(double shininess) {
  _shininess = shininess;
  _flags |= F_shininess;
}

////////////////////////////////////////////////////////////////////
//     Function: EggMaterial::clear_shininess
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE void EggMaterial::
clear_shininess() {
  _flags &= ~F_shininess;
}

////////////////////////////////////////////////////////////////////
//     Function: EggMaterial::has_shininess
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE bool EggMaterial::
has_shininess() const {
  return (_flags & F_shininess) != 0;
}

////////////////////////////////////////////////////////////////////
//     Function: EggMaterial::get_shininess
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE double EggMaterial::
get_shininess() const {
  if (has_shininess()) {
    return _shininess;
  } else {
    return 0.0;
  }
}

////////////////////////////////////////////////////////////////////
//     Function: EggMaterial::set_local
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE void EggMaterial::
set_local(bool local) {
  _local = local;
  _flags |= F_local;
}

////////////////////////////////////////////////////////////////////
//     Function: EggMaterial::clear_local
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE void EggMaterial::
clear_local() {
  _flags &= ~F_local;
}

////////////////////////////////////////////////////////////////////
//     Function: EggMaterial::has_local
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE bool EggMaterial::
has_local() const {
  return (_flags & F_local) != 0;
}

////////////////////////////////////////////////////////////////////
//     Function: EggMaterial::get_local
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE bool EggMaterial::
get_local() const {
  if (has_local()) {
    return _local;
  } else {
    return 0.0;
  }
}

////////////////////////////////////////////////////////////////////
//     Function: UniqueEggMaterials::Constructor
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE UniqueEggMaterials::
UniqueEggMaterials(int eq) : _eq(eq) {
}

////////////////////////////////////////////////////////////////////
//     Function: UniqueEggMaterials::Function operator
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE bool UniqueEggMaterials::
operator ()(const EggMaterial *t1, const EggMaterial *t2) const {
  return t1->sorts_less_than(*t2, _eq);
}

