// Filename: event.I
// Created by:  drose (15May01)
//
////////////////////////////////////////////////////////////////////
//
// PANDA 3D SOFTWARE
// Copyright (c) Carnegie Mellon University.  All rights reserved.
//
// All use of this software is subject to the terms of the revised BSD
// license.  You should have received a copy of this license along
// with this source code in a file named "LICENSE."
//
////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////
//     Function: Event::set_name
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE void Event::
set_name(const string &name) {
  _name = name;
}

////////////////////////////////////////////////////////////////////
//     Function: Event::clear_name
//       Access: Public
//  Description: Resets the Event's name to empty.
////////////////////////////////////////////////////////////////////
INLINE void Event::
clear_name() {
  _name = "";
}

////////////////////////////////////////////////////////////////////
//     Function: Event::has_name
//       Access: Public
//  Description: Returns true if the Event has a nonempty name set,
//               false if the name is empty.
////////////////////////////////////////////////////////////////////
INLINE bool Event::
has_name() const {
  return !_name.empty();
}

////////////////////////////////////////////////////////////////////
//     Function: Event::get_name
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE const string &Event::
get_name() const {
  return _name;
}


INLINE ostream &operator << (ostream &out, const Event &n) {
  n.output(out);
  return out;
}
