#ifndef ODEHINGE2JOINT_H
#define ODEHINGE2JOINT_H

#include "pandabase.h"
#include "typedObject.h"
#include "luse.h"

#include "ode_includes.h"

#include "odeJoint.h"

////////////////////////////////////////////////////////////////////
//       Class : OdeHinge2Joint
// Description : 
////////////////////////////////////////////////////////////////////
class EXPCL_PANDAODE OdeHinge2Joint : public OdeJoint {
  friend class OdeJoint;

private:
  OdeHinge2Joint(dJointID id);

PUBLISHED:
  OdeHinge2Joint(OdeWorld &world, OdeJointGroup &joint_group);
  OdeHinge2Joint(OdeWorld &world);
  virtual ~OdeHinge2Joint();

  INLINE void set_anchor(dReal x, dReal y, dReal z);
  INLINE void set_anchor(const LVecBase3f &anchor);
  INLINE void set_axis1(dReal x, dReal y, dReal z);
  INLINE void set_axis1(const LVecBase3f &axis);
  INLINE void set_axis2(dReal x, dReal y, dReal z);
  INLINE void set_axis2(const LVecBase3f &axis);
  INLINE void add_torques(dReal torque1, dReal torque2);

  INLINE LVecBase3f get_anchor() const;
  INLINE LVecBase3f get_anchor2() const;
  INLINE LVecBase3f get_axis1() const;
  INLINE LVecBase3f get_axis2() const;
  INLINE dReal get_angle1() const;
  INLINE dReal get_angle1_rate() const;
  INLINE dReal get_angle2_rate() const;

  INLINE void set_param_lo_stop(int axis, dReal val);
  INLINE void set_param_hi_stop(int axis, dReal val);
  INLINE void set_param_vel(int axis, dReal val);
  INLINE void set_param_f_max(int axis, dReal val);
  INLINE void set_param_fudge_factor(int axis, dReal val);
  INLINE void set_param_bounce(int axis, dReal val);
  INLINE void set_param_CFM(int axis, dReal val);
  INLINE void set_param_stop_ERP(int axis, dReal val);
  INLINE void set_param_stop_CFM(int axis, dReal val);
  INLINE void set_param_suspension_ERP(int axis, dReal val);
  INLINE void set_param_suspension_CFM(int axis, dReal val);
  
  INLINE dReal get_param_lo_stop(int axis) const;
  INLINE dReal get_param_hi_stop(int axis) const;
  INLINE dReal get_param_vel(int axis) const;
  INLINE dReal get_param_f_max(int axis) const;
  INLINE dReal get_param_fudge_factor(int axis) const;
  INLINE dReal get_param_bounce(int axis) const;
  INLINE dReal get_param_CFM(int axis) const;
  INLINE dReal get_param_stop_ERP(int axis) const;
  INLINE dReal get_param_stop_CFM(int axis) const;
  INLINE dReal get_param_suspension_ERP(int axis) const;
  INLINE dReal get_param_suspension_CFM(int axis) const;

public:
  static TypeHandle get_class_type() {
    return _type_handle;
  }
  static void init_type() {
    OdeJoint::init_type();
    register_type(_type_handle, "OdeHinge2Joint",
                  OdeJoint::get_class_type());
  }
  virtual TypeHandle get_type() const {
    return get_class_type();
  }
  virtual TypeHandle force_init_type() {init_type(); return get_class_type();}

private:
  static TypeHandle _type_handle;
};

#include "odeHinge2Joint.I"

#endif
