// Filename: linearForce.I
// Created by:  charles (13Jun00)
//
////////////////////////////////////////////////////////////////////
//
// PANDA 3D SOFTWARE
// Copyright (c) Carnegie Mellon University.  All rights reserved.
//
// All use of this software is subject to the terms of the revised BSD
// license.  You should have received a copy of this license along
// with this source code in a file named "LICENSE."
//
////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////
//    Function : set_amplitude
//      Access : Public
////////////////////////////////////////////////////////////////////
INLINE void LinearForce::
set_amplitude(PN_stdfloat a) {
  _amplitude = a;
}

////////////////////////////////////////////////////////////////////
//    Function : get_amplitude
//      Access : Public
////////////////////////////////////////////////////////////////////
INLINE PN_stdfloat LinearForce::
get_amplitude() const {
  return _amplitude;
}

////////////////////////////////////////////////////////////////////
//    Function : get_mass_dependent
//      Access : Public
////////////////////////////////////////////////////////////////////
INLINE bool LinearForce::
get_mass_dependent() const {
  return _mass_dependent;
}

////////////////////////////////////////////////////////////////////
//    Function : set_mass_Dependent
//      Access : Public
////////////////////////////////////////////////////////////////////
INLINE void LinearForce::
set_mass_dependent(bool m) {
  _mass_dependent = m;
}

////////////////////////////////////////////////////////////////////
//    Function : set_vector_masks
//      Access : Public
////////////////////////////////////////////////////////////////////
INLINE void LinearForce::
set_vector_masks(bool x, bool y, bool z) {
  _x_mask = x;
  _y_mask = y;
  _z_mask = z;
}

////////////////////////////////////////////////////////////////////
//    Function : set_vector_masks
//      Access : Public
////////////////////////////////////////////////////////////////////
INLINE LVector3 LinearForce::
get_vector_masks() {
  return LVector3(_x_mask, _y_mask, _z_mask);
}
