// Filename: writableParam.I
// Created by:  jason (13Jun00)
//
////////////////////////////////////////////////////////////////////
//
// PANDA 3D SOFTWARE
// Copyright (c) Carnegie Mellon University.  All rights reserved.
//
// All use of this software is subject to the terms of the revised BSD
// license.  You should have received a copy of this license along
// with this source code in a file named "LICENSE."
//
////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////
//     Function: WritableParam::Constructor
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE WritableParam::
WritableParam(const Datagram &datagram) :
  _packet(datagram)
{
}

////////////////////////////////////////////////////////////////////
//     Function: WritableParam::Copy Constructor
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE WritableParam::
WritableParam(const WritableParam &copy) :
  FactoryParam(copy),
  _packet(copy._packet)
{
}

////////////////////////////////////////////////////////////////////
//     Function: WritableParam::Destructor
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE WritableParam::
~WritableParam() {
}

////////////////////////////////////////////////////////////////////
//     Function: WritableParam::Copy Assignment Operator
//       Access: Private
//  Description:
////////////////////////////////////////////////////////////////////
INLINE void WritableParam::
operator = (const WritableParam &) {
  // The assignment operator cannot be used for this class.
  nassertv(false);
}

////////////////////////////////////////////////////////////////////
//     Function: WritableParam::get_datagram
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE const Datagram& WritableParam::
get_datagram() {
  return _packet;
}

