// Filename: dcField.I
// Created by:  drose (10Jan06)
//
////////////////////////////////////////////////////////////////////
//
// PANDA 3D SOFTWARE
// Copyright (c) Carnegie Mellon University.  All rights reserved.
//
// All use of this software is subject to the terms of the revised BSD
// license.  You should have received a copy of this license along
// with this source code in a file named "LICENSE."
//
////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////
//     Function: DCField::get_number
//       Access: Published
//  Description: Returns a unique index number associated with this
//               field.  This is defined implicitly when the .dc
//               file(s) are read.
////////////////////////////////////////////////////////////////////
INLINE int DCField::
get_number() const {
  return _number;
}

////////////////////////////////////////////////////////////////////
//     Function: DCField::get_class
//       Access: Published
//  Description: Returns the DCClass pointer for the class that
//               contains this field.
////////////////////////////////////////////////////////////////////
INLINE DCClass *DCField::
get_class() const {
  return _dclass;
}

////////////////////////////////////////////////////////////////////
//     Function: DCField::has_default_value
//       Access: Published
//  Description: Returns true if a default value has been explicitly
//               established for this field, false otherwise.
////////////////////////////////////////////////////////////////////
INLINE bool DCField::
has_default_value() const {
  return _has_default_value;
}

////////////////////////////////////////////////////////////////////
//     Function: DCField::get_default_value
//       Access: Published
//  Description: Returns the default value for this field.  If a
//               default value has been explicitly set
//               (e.g. has_default_value() returns true), returns that
//               value; otherwise, returns an implicit default for the
//               field.
////////////////////////////////////////////////////////////////////
INLINE const string &DCField::
get_default_value() const {
  if (_default_value_stale) {
    ((DCField *)this)->refresh_default_value();
  }
  return _default_value;
}

////////////////////////////////////////////////////////////////////
//     Function: DCField::is_bogus_field
//       Access: Published
//  Description: Returns true if the field has been flagged as a bogus
//               field.  This is set for fields that are generated by
//               the parser as placeholder for missing fields, as
//               when reading a partial file; it should not occur in a
//               normal valid dc file.
////////////////////////////////////////////////////////////////////
INLINE bool DCField::
is_bogus_field() const {
  return _bogus_field;
}

////////////////////////////////////////////////////////////////////
//     Function: DCField::is_required
//       Access: Published
//  Description: Returns true if the "required" flag is set for this
//               field, false otherwise.
////////////////////////////////////////////////////////////////////
INLINE bool DCField::
is_required() const {
  return has_keyword("required");
}

////////////////////////////////////////////////////////////////////
//     Function: DCField::is_broadcast
//       Access: Published
//  Description: Returns true if the "broadcast" flag is set for this
//               field, false otherwise.
////////////////////////////////////////////////////////////////////
INLINE bool DCField::
is_broadcast() const {
  return has_keyword("broadcast");
}

////////////////////////////////////////////////////////////////////
//     Function: DCField::is_ram
//       Access: Published
//  Description: Returns true if the "ram" flag is set for this
//               field, false otherwise.
////////////////////////////////////////////////////////////////////
INLINE bool DCField::
is_ram() const {
  return has_keyword("ram");
}

////////////////////////////////////////////////////////////////////
//     Function: DCField::is_db
//       Access: Published
//  Description: Returns true if the "db" flag is set for this
//               field, false otherwise.
////////////////////////////////////////////////////////////////////
INLINE bool DCField::
is_db() const {
  return has_keyword("db");
}

////////////////////////////////////////////////////////////////////
//     Function: DCField::is_clsend
//       Access: Published
//  Description: Returns true if the "clsend" flag is set for this
//               field, false otherwise.
////////////////////////////////////////////////////////////////////
INLINE bool DCField::
is_clsend() const {
  return has_keyword("clsend");
}

////////////////////////////////////////////////////////////////////
//     Function: DCField::is_clrecv
//       Access: Published
//  Description: Returns true if the "clrecv" flag is set for this
//               field, false otherwise.
////////////////////////////////////////////////////////////////////
INLINE bool DCField::
is_clrecv() const {
  return has_keyword("clrecv");
}

////////////////////////////////////////////////////////////////////
//     Function: DCField::is_ownsend
//       Access: Published
//  Description: Returns true if the "ownsend" flag is set for this
//               field, false otherwise.
////////////////////////////////////////////////////////////////////
INLINE bool DCField::
is_ownsend() const {
  return has_keyword("ownsend");
}

////////////////////////////////////////////////////////////////////
//     Function: DCField::is_ownrecv
//       Access: Published
//  Description: Returns true if the "ownrecv" flag is set for this
//               field, false otherwise.
////////////////////////////////////////////////////////////////////
INLINE bool DCField::
is_ownrecv() const {
  return has_keyword("ownrecv");
}

////////////////////////////////////////////////////////////////////
//     Function: DCField::is_airecv
//       Access: Published
//  Description: Returns true if the "airecv" flag is set for this
//               field, false otherwise.
////////////////////////////////////////////////////////////////////
INLINE bool DCField::
is_airecv() const {
  return has_keyword("airecv");
}

////////////////////////////////////////////////////////////////////
//     Function : DCField::output
//       Access : Published
//  Description : Write a string representation of this instance to
//                <out>.
////////////////////////////////////////////////////////////////////
INLINE void DCField::
output(ostream &out) const {
  output(out, true);
}

////////////////////////////////////////////////////////////////////
//     Function : DCField::
//       Access : Published
//  Description : Write a string representation of this instance to
//                <out>.
////////////////////////////////////////////////////////////////////
INLINE void DCField::
write(ostream &out, int indent_level) const {
  write(out, false, indent_level);
}

////////////////////////////////////////////////////////////////////
//     Function: DCField::set_number
//       Access: Public
//  Description: Assigns the unique number to this field.  This is
//               normally called only by the DCClass interface as the
//               field is added.
////////////////////////////////////////////////////////////////////
INLINE void DCField::
set_number(int number) {
  _number = number;
}

////////////////////////////////////////////////////////////////////
//     Function: DCField::set_class
//       Access: Public
//  Description: Assigns the class pointer to this field.  This is
//               normally called only by the DCClass interface as the
//               field is added.
////////////////////////////////////////////////////////////////////
INLINE void DCField::
set_class(DCClass *dclass) {
  _dclass = dclass;
}

////////////////////////////////////////////////////////////////////
//     Function: DCField::set_default_value
//       Access: Public
//  Description: Establishes a default value for this field.
////////////////////////////////////////////////////////////////////
INLINE void DCField::
set_default_value(const string &default_value) {
  _default_value = default_value;
  _has_default_value = true;
  _default_value_stale = false;
}
