// Filename: bulletShape.I
// Created by:  enn0x (23Jan10)
//
////////////////////////////////////////////////////////////////////
//
// PANDA 3D SOFTWARE
// Copyright (c) Carnegie Mellon University.  All rights reserved.
//
// All use of this software is subject to the terms of the revised BSD
// license.  You should have received a copy of this license along
// with this source code in a file named "LICENSE."
//
////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////
//     Function: BulletShape::Destructor
//       Access: Published
//  Description:
////////////////////////////////////////////////////////////////////
INLINE BulletShape::
~BulletShape() {

}

////////////////////////////////////////////////////////////////////
//     Function: BulletShape::is_polyhedral
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE bool BulletShape::
is_polyhedral() const {

  return ptr()->isPolyhedral();
}

////////////////////////////////////////////////////////////////////
//     Function: BulletShape::is_convex
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE bool BulletShape::
is_convex() const {

  return ptr()->isConvex();
}

////////////////////////////////////////////////////////////////////
//     Function: BulletShape::is_convex_2d
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE bool BulletShape::
is_convex_2d() const {

  return ptr()->isConvex2d();
}

////////////////////////////////////////////////////////////////////
//     Function: BulletShape::is_concave
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE bool BulletShape::
is_concave() const {

  return ptr()->isConcave();
}

////////////////////////////////////////////////////////////////////
//     Function: BulletShape::is_infinite
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE bool BulletShape::
is_infinite() const {

  return ptr()->isInfinite();
}

////////////////////////////////////////////////////////////////////
//     Function: BulletShape::is_non_moving
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE bool BulletShape::
is_non_moving() const {

  return ptr()->isNonMoving();
}

////////////////////////////////////////////////////////////////////
//     Function: BulletShape::is_soft_body
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE bool BulletShape::
is_soft_body() const {

  return ptr()->isSoftBody();
}

