// Filename: bulletSphereShape.h
// Created by:  enn0x (23Jan10)
//
////////////////////////////////////////////////////////////////////
//
// PANDA 3D SOFTWARE
// Copyright (c) Carnegie Mellon University.  All rights reserved.
//
// All use of this software is subject to the terms of the revised BSD
// license.  You should have received a copy of this license along
// with this source code in a file named "LICENSE."
//
////////////////////////////////////////////////////////////////////

#ifndef __BULLET_SPHERE_SHAPE_H__
#define __BULLET_SPHERE_SHAPE_H__

#include "pandabase.h"

#include "bullet_includes.h"
#include "bullet_utils.h"
#include "bulletShape.h"

#include "collisionSphere.h"

////////////////////////////////////////////////////////////////////
//       Class : BulletSphereShape
// Description : 
////////////////////////////////////////////////////////////////////
class EXPCL_PANDABULLET BulletSphereShape : public BulletShape {

PUBLISHED:
  BulletSphereShape(PN_stdfloat radius);
  INLINE BulletSphereShape(const BulletSphereShape &copy);
  INLINE void operator = (const BulletSphereShape &copy);
  INLINE ~BulletSphereShape();

  INLINE PN_stdfloat get_radius() const;

  static BulletSphereShape *make_from_solid(const CollisionSphere *solid);

public:
  virtual btCollisionShape *ptr() const;

private:
  btSphereShape *_shape;

////////////////////////////////////////////////////////////////////
public:
  static TypeHandle get_class_type() {
    return _type_handle;
  }
  static void init_type() {
    BulletShape::init_type();
    register_type(_type_handle, "BulletSphereShape", 
                  BulletShape::get_class_type());
  }
  virtual TypeHandle get_type() const {
    return get_class_type();
  }
  virtual TypeHandle force_init_type() {
    init_type();
    return get_class_type();
  }

private:
  static TypeHandle _type_handle;
};

#include "bulletSphereShape.I"

#endif // __BULLET_SPHERE_SHAPE_H__
