// Filename: eggTable.I
// Created by:  drose (19Feb99)
//
////////////////////////////////////////////////////////////////////
//
// PANDA 3D SOFTWARE
// Copyright (c) Carnegie Mellon University.  All rights reserved.
//
// All use of this software is subject to the terms of the revised BSD
// license.  You should have received a copy of this license along
// with this source code in a file named "LICENSE."
//
////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////
//     Function: EggTable::Constructor
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE EggTable::
EggTable(const string &name) : EggGroupNode(name) {
  _type = TT_table;
}


////////////////////////////////////////////////////////////////////
//     Function: EggTable::Copy constructor
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE EggTable::
EggTable(const EggTable &copy) : EggGroupNode(copy), _type(copy._type) {
}


////////////////////////////////////////////////////////////////////
//     Function: EggTable::Copy assignment operator
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE EggTable &EggTable::
operator = (const EggTable &copy) {
  EggGroupNode::operator = (copy);
  _type = copy._type;

  return *this;
}


////////////////////////////////////////////////////////////////////
//     Function: EggTable::set_table_type
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE void EggTable::
set_table_type(TableType type) {
  _type = type;
}


////////////////////////////////////////////////////////////////////
//     Function: EggTable::get_table_type
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE EggTable::TableType EggTable::
get_table_type() const {
  return _type;
}
