// Filename: arcEmitter.I
// Created by:  charles (26Jun00)
//
////////////////////////////////////////////////////////////////////
//
// PANDA 3D SOFTWARE
// Copyright (c) Carnegie Mellon University.  All rights reserved.
//
// All use of this software is subject to the terms of the revised BSD
// license.  You should have received a copy of this license along
// with this source code in a file named "LICENSE."
//
////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////
//    Function : set_start_angle
//      Access : public
// Description : start angle set
////////////////////////////////////////////////////////////////////

INLINE void ArcEmitter::
set_start_angle(PN_stdfloat angle) {
  _start_theta = deg_2_rad(angle);
}

////////////////////////////////////////////////////////////////////
//    Function : set_end_angle
//      Access : public
// Description : end angle set
////////////////////////////////////////////////////////////////////

INLINE void ArcEmitter::
set_end_angle(PN_stdfloat angle) {
  _end_theta = deg_2_rad(angle);
}

////////////////////////////////////////////////////////////////////
//    Function : set_arc
//      Access : public
// Description : arc sweep set
////////////////////////////////////////////////////////////////////

INLINE void ArcEmitter::
set_arc(PN_stdfloat startAngle, PN_stdfloat endAngle) {
  _start_theta = deg_2_rad(startAngle);
  _end_theta = deg_2_rad(endAngle);
}

////////////////////////////////////////////////////////////////////
//    Function : get_start_angle
//      Access : public
// Description : get start angle
////////////////////////////////////////////////////////////////////

INLINE PN_stdfloat ArcEmitter::
get_start_angle() {
  return rad_2_deg(_start_theta);
}

////////////////////////////////////////////////////////////////////
//    Function : get_end_angle
//      Access : public
// Description : get end angle
////////////////////////////////////////////////////////////////////

INLINE PN_stdfloat ArcEmitter::
get_end_angle() {
  return rad_2_deg(_end_theta);
}

