// Filename: baseParticleFactory.I
// Created by:  charles (05Jul00)
//
////////////////////////////////////////////////////////////////////
//
// PANDA 3D SOFTWARE
// Copyright (c) Carnegie Mellon University.  All rights reserved.
//
// All use of this software is subject to the terms of the revised BSD
// license.  You should have received a copy of this license along
// with this source code in a file named "LICENSE."
//
////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////
//    Function : set_lifespan_base
// Description : public
////////////////////////////////////////////////////////////////////
INLINE void BaseParticleFactory::
set_lifespan_base(PN_stdfloat lb) {
  _lifespan_base = lb;
}

////////////////////////////////////////////////////////////////////
//    Function : set_lifespan_spread
// Description : public
////////////////////////////////////////////////////////////////////
INLINE void BaseParticleFactory::
set_lifespan_spread(PN_stdfloat ld) {
  _lifespan_spread = ld;
}

////////////////////////////////////////////////////////////////////
//    Function : set_mass_base
// Description : public
////////////////////////////////////////////////////////////////////
INLINE void BaseParticleFactory::
set_mass_base(PN_stdfloat mb) {
  nassertv(mb >= _mass_spread);
  _mass_base = mb;
}

////////////////////////////////////////////////////////////////////
//    Function : set_mass_spread
// Description : public
////////////////////////////////////////////////////////////////////
INLINE void BaseParticleFactory::
set_mass_spread(PN_stdfloat md) {
  nassertv(md < _mass_base);
  _mass_spread = md;
}

////////////////////////////////////////////////////////////////////
//    Function : set_terminal_velocity_base
// Description : public
////////////////////////////////////////////////////////////////////
INLINE void BaseParticleFactory::
set_terminal_velocity_base(PN_stdfloat tvb) {
  _terminal_velocity_base = tvb;
}

////////////////////////////////////////////////////////////////////
//    Function : set_terminal_velocity_spread
// Description : public
////////////////////////////////////////////////////////////////////
INLINE void BaseParticleFactory::
set_terminal_velocity_spread(PN_stdfloat tvd) {
  _terminal_velocity_spread = tvd;
}

////////////////////////////////////////////////////////////////////
//    Function : get_lifespan_base
// Description : public
////////////////////////////////////////////////////////////////////
INLINE PN_stdfloat BaseParticleFactory::
get_lifespan_base() const {
  return _lifespan_base;
}

////////////////////////////////////////////////////////////////////
//    Function : get_lifespan_spread
// Description : public
////////////////////////////////////////////////////////////////////
INLINE PN_stdfloat BaseParticleFactory::
get_lifespan_spread() const {
  return _lifespan_spread;
}

////////////////////////////////////////////////////////////////////
//    Function : get_mass_base
// Description : public
////////////////////////////////////////////////////////////////////
INLINE PN_stdfloat BaseParticleFactory::
get_mass_base() const {
  return _mass_base;
}

////////////////////////////////////////////////////////////////////
//    Function : get_mass_spread
// Description : public
////////////////////////////////////////////////////////////////////
INLINE PN_stdfloat BaseParticleFactory::
get_mass_spread() const {
  return _mass_spread;
}

////////////////////////////////////////////////////////////////////
//    Function : get_terminal_velocity_base
// Description : public
////////////////////////////////////////////////////////////////////
INLINE PN_stdfloat BaseParticleFactory::
get_terminal_velocity_base() const {
  return _terminal_velocity_base;
}

////////////////////////////////////////////////////////////////////
//    Function : get_terminal_velocity_spread
// Description : public
////////////////////////////////////////////////////////////////////
INLINE PN_stdfloat BaseParticleFactory::
get_terminal_velocity_spread() const {
  return _terminal_velocity_spread;
}

