// Filename: discEmitter.I
// Created by:  charles (22Jun00)
//
////////////////////////////////////////////////////////////////////
//
// PANDA 3D SOFTWARE
// Copyright (c) Carnegie Mellon University.  All rights reserved.
//
// All use of this software is subject to the terms of the revised BSD
// license.  You should have received a copy of this license along
// with this source code in a file named "LICENSE."
//
////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////
//    Function : set_radius
//      Access : Public
// Description : radius assignment
////////////////////////////////////////////////////////////////////

INLINE void DiscEmitter::
set_radius(PN_stdfloat r) {
  _radius = r;
}

////////////////////////////////////////////////////////////////////
//    Function : set_outer_angle
//      Access : Public
// Description : aoe assignement
////////////////////////////////////////////////////////////////////

INLINE void DiscEmitter::
set_outer_angle(PN_stdfloat o_angle) {
  _outer_aoe = o_angle;
}

////////////////////////////////////////////////////////////////////
//    Function : set_inner_angle
//      Access : Public
// Description : aoe assignment
////////////////////////////////////////////////////////////////////

INLINE void DiscEmitter::
set_inner_angle(PN_stdfloat i_angle) {
  _inner_aoe = i_angle;
}

////////////////////////////////////////////////////////////////////
//    Function : set_outer_magnitude
//      Access : public
// Description : mag assignment
////////////////////////////////////////////////////////////////////

INLINE void DiscEmitter::
set_outer_magnitude(PN_stdfloat o_mag) {
  _outer_magnitude = o_mag;
}

////////////////////////////////////////////////////////////////////
//    Function : set_inner_magnitude
//      Access : public
// Description : mag assignment
////////////////////////////////////////////////////////////////////

INLINE void DiscEmitter::
set_inner_magnitude(PN_stdfloat i_mag) {
  _inner_magnitude = i_mag;
}

////////////////////////////////////////////////////////////////////
//    Function : set_cubic_lerping
//      Access : public
// Description : clerp flag
////////////////////////////////////////////////////////////////////

INLINE void DiscEmitter::
set_cubic_lerping(bool clerp) {
  _cubic_lerping = clerp;
}

////////////////////////////////////////////////////////////////////
//    Function : get_radius
//      Access : Public
// Description : radius accessor
////////////////////////////////////////////////////////////////////

INLINE PN_stdfloat DiscEmitter::
get_radius() const {
  return _radius;
}

////////////////////////////////////////////////////////////////////
//    Function : get_outer_angle
//      Access : Public
// Description : aoe accessor
////////////////////////////////////////////////////////////////////

INLINE PN_stdfloat DiscEmitter::
get_outer_angle() const {
  return _outer_aoe;
}

////////////////////////////////////////////////////////////////////
//    Function : get_inner_angle
//      Access : Public
// Description : aoe accessor
////////////////////////////////////////////////////////////////////

INLINE PN_stdfloat DiscEmitter::
get_inner_angle() const {
  return _inner_aoe;
}

////////////////////////////////////////////////////////////////////
//    Function : get_outer_magnitude
//      Access : public
// Description : mag accessor
////////////////////////////////////////////////////////////////////

INLINE PN_stdfloat DiscEmitter::
get_outer_magnitude() const {
  return _outer_magnitude;
}

////////////////////////////////////////////////////////////////////
//    Function : get_inner_magnitude
//      Access : public
// Description : mag accessor
////////////////////////////////////////////////////////////////////

INLINE PN_stdfloat DiscEmitter::
get_inner_magnitude() const {
  return _inner_magnitude;
}

////////////////////////////////////////////////////////////////////
//    Function : get_cubic_lerping
//      Access : public
// Description : clerp flag accessor
////////////////////////////////////////////////////////////////////

INLINE bool DiscEmitter::
get_cubic_lerping() const {
  return _cubic_lerping;
}
