// Filename: physxGroupsMask.cxx
// Created by:  enn0x (21Oct09)
//
////////////////////////////////////////////////////////////////////
//
// PANDA 3D SOFTWARE
// Copyright (c) Carnegie Mellon University.  All rights reserved.
//
// All use of this software is subject to the terms of the revised BSD
// license.  You should have received a copy of this license along
// with this source code in a file named "LICENSE."
//
////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////
//     Function: PhysxGroupsMask::Constructor
//       Access: Published
//  Description:
////////////////////////////////////////////////////////////////////
INLINE PhysxGroupsMask::
PhysxGroupsMask() {

  _mask.bits0 = 0x00000000;
  _mask.bits1 = 0x00000000;
  _mask.bits2 = 0x00000000;
  _mask.bits3 = 0x00000000;
}

////////////////////////////////////////////////////////////////////
//     Function: PhysxGroupsMask::Constructor
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE PhysxGroupsMask::
PhysxGroupsMask(NxGroupsMask mask)
  : _mask(mask) {

}

////////////////////////////////////////////////////////////////////
//     Function: PhysxGroupsMask::Destructor
//       Access: Published
//  Description:
////////////////////////////////////////////////////////////////////
INLINE PhysxGroupsMask::
~PhysxGroupsMask() {

}

////////////////////////////////////////////////////////////////////
//     Function: PhysxGroupsMask::get_mask
//       Access: Public
//  Description: 
////////////////////////////////////////////////////////////////////
INLINE NxGroupsMask PhysxGroupsMask::
get_mask() const {

  return _mask;
}

////////////////////////////////////////////////////////////////////
//     Function: PhysxGroupsMask::set_mask
//       Access: Public
//  Description: 
////////////////////////////////////////////////////////////////////
INLINE void PhysxGroupsMask::
set_mask(NxGroupsMask mask) {

  _mask = mask;
}

////////////////////////////////////////////////////////////////////
//     Function: PhysxGroupsMask::get_bits0
//       Access: Public
//  Description: 
////////////////////////////////////////////////////////////////////
INLINE unsigned int PhysxGroupsMask::
get_bits0() const {

  return _mask.bits0;
}

////////////////////////////////////////////////////////////////////
//     Function: PhysxGroupsMask::set_bits0
//       Access: Public
//  Description: 
////////////////////////////////////////////////////////////////////
INLINE void PhysxGroupsMask::
set_bits0(unsigned int bits) {

  _mask.bits0 = (NxU32) bits;
}

////////////////////////////////////////////////////////////////////
//     Function: PhysxGroupsMask::get_bits1
//       Access: Public
//  Description: 
////////////////////////////////////////////////////////////////////
INLINE unsigned int PhysxGroupsMask::
get_bits1() const {

  return _mask.bits1;
}

////////////////////////////////////////////////////////////////////
//     Function: PhysxGroupsMask::set_bits1
//       Access: Public
//  Description: 
////////////////////////////////////////////////////////////////////
INLINE void PhysxGroupsMask::
set_bits1(unsigned int bits) {

  _mask.bits1 = (NxU32) bits;
}

////////////////////////////////////////////////////////////////////
//     Function: PhysxGroupsMask::get_bits2
//       Access: Public
//  Description: 
////////////////////////////////////////////////////////////////////
INLINE unsigned int PhysxGroupsMask::
get_bits2() const {

  return _mask.bits2;
}

////////////////////////////////////////////////////////////////////
//     Function: PhysxGroupsMask::set_bits2
//       Access: Public
//  Description: 
////////////////////////////////////////////////////////////////////
INLINE void PhysxGroupsMask::
set_bits2(unsigned int bits) {

  _mask.bits2 = (NxU32) bits;
}

////////////////////////////////////////////////////////////////////
//     Function: PhysxGroupsMask::get_bits3
//       Access: Public
//  Description: 
////////////////////////////////////////////////////////////////////
INLINE unsigned int PhysxGroupsMask::
get_bits3() const {

  return _mask.bits3;
}

////////////////////////////////////////////////////////////////////
//     Function: PhysxGroupsMask::set_bits3
//       Access: Public
//  Description: 
////////////////////////////////////////////////////////////////////
INLINE void PhysxGroupsMask::
set_bits3(unsigned int bits) {

  _mask.bits3 = (NxU32) bits;
}

