// Filename: mouseData.h
// Created by:  drose (08Feb99)
//
////////////////////////////////////////////////////////////////////
//
// PANDA 3D SOFTWARE
// Copyright (c) Carnegie Mellon University.  All rights reserved.
//
// All use of this software is subject to the terms of the revised BSD
// license.  You should have received a copy of this license along
// with this source code in a file named "LICENSE."
//
////////////////////////////////////////////////////////////////////

#ifndef MOUSEDATA_H
#define MOUSEDATA_H

#include "pandabase.h"

#include "modifierButtons.h"

////////////////////////////////////////////////////////////////////
//       Class : MouseData
// Description : Holds the data that might be generated by a 2-d
//               pointer input device, such as the mouse in the
//               GraphicsWindow.
////////////////////////////////////////////////////////////////////
class EXPCL_PANDA_PUTIL MouseData {
PUBLISHED:
  INLINE MouseData();
  INLINE MouseData(const MouseData &copy);
  INLINE void operator = (const MouseData &copy);

  INLINE int get_x() const;
  INLINE int get_y() const;
  INLINE bool get_in_window() const;

  void output(ostream &out) const;

public:
  bool _in_window;
  int _xpos;
  int _ypos;
};

INLINE ostream &operator << (ostream &out, const MouseData &md);

#include "mouseData.I"

#endif


