// Filename: dcClass.I
// Created by:  drose (15Sep04)
//
////////////////////////////////////////////////////////////////////
//
// PANDA 3D SOFTWARE
// Copyright (c) 2001 - 2004, Disney Enterprises, Inc.  All rights reserved
//
// All use of this software is subject to the terms of the Panda 3d
// Software license.  You should have received a copy of this license
// along with this source code; you will also find a current copy of
// the license at http://etc.cmu.edu/panda3d/docs/license/ .
//
// To contact the maintainers of this program write to
// panda3d-general@lists.sourceforge.net .
//
////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////
//     Function: DCClass::is_struct
//       Access: Public
//  Description: Returns true if the class has been identified with
//               the "struct" keyword in the dc file, false if it was
//               declared with "dclass".
////////////////////////////////////////////////////////////////////
INLINE bool DCClass::
is_struct() const {
  return _is_struct;
}

////////////////////////////////////////////////////////////////////
//     Function: DCClass::is_bogus_class
//       Access: Public
//  Description: Returns true if the class has been flagged as a bogus
//               class.  This is set for classes that are generated by
//               the parser as placeholder for missing classes, as
//               when reading a partial file; it should not occur in a
//               normal valid dc file.
////////////////////////////////////////////////////////////////////
INLINE bool DCClass::
is_bogus_class() const {
  return _bogus_class;
}

////////////////////////////////////////////////////////////////////
//     Function: DCClass::start_generate
//       Access: Public
//  Description: Starts the PStats timer going on the "generate" task,
//               that is, marks the beginning of the process of
//               generating a new object, for the purposes of timing
//               this process.
//
//               This should balance with a corresponding call to
//               stop_generate().
////////////////////////////////////////////////////////////////////
INLINE void DCClass::
start_generate() {
#ifdef WITHIN_PANDA
  _class_generate_pcollector.start();
#endif
}

////////////////////////////////////////////////////////////////////
//     Function: DCClass::stop_generate
//       Access: Public
//  Description: Stops the PStats timer on the "generate" task.
//               This should balance with a preceding call to
//               start_generate().
////////////////////////////////////////////////////////////////////
INLINE void DCClass::
stop_generate() {
#ifdef WITHIN_PANDA
  _class_generate_pcollector.stop();
#endif
}
