//
// LocalSetup.pp
//
// This file contains further instructions to set up the DTOOL package
// when using ppremake.  In particular, it creates the dtool_config.h
// file based on the user's selected configure variables.  This script
// need not execute when BUILD_TYPE is "autoconf"; in this case, the
// dtool_config.h file will automatically be correctly generated by
// configure.
//

#print
#print Configuring support for the following optional third-party packages:
#if $[HAVE_NSPR]
#print + NSPR
#else
#print - Did not find NSPR
#endif
#if $[HAVE_SSL]
#print + OpenSSL
#else
#print - Did not find OpenSSL
#endif
#if $[HAVE_JPEG]
#print + libjpeg
#else
#print - Did not find libjpeg
#endif
#if $[HAVE_PNG]
#print + libpng
#else
#print - Did not find libpng
#endif
#if $[HAVE_TIFF]
#print + libtiff
#else
#print - Did not find libtiff
#endif
#if $[HAVE_FFTW]
#print + fftw
#else
#print - Did not find fftw
#endif
#if $[HAVE_CG]
#print + Nvidia Cg High Level Shading Language
#else
#print - Did not find Nvidia Cg High Level Shading Language
#endif
#if $[HAVE_CGGL]
#print + Cg OpenGL API
#else
#print - Did not find Cg OpenGL API
#endif
#if $[HAVE_VRPN]
#print + VRPN
#else
#print - Did not find VRPN
#endif
#if $[HAVE_ZLIB]
#print + zlib
#else
#print - Did not find zlib
#endif
#if $[HAVE_RAD_MSS]
#print + Miles Sound System
#else
#print - Did not find Miles Sound System
#endif
#if $[HAVE_FMOD]
#print + FMOD sound library
#else
#print - Did not find FMOD sound library
#endif
#if $[HAVE_FREETYPE]
#print + Freetype
#else
#print - Did not find Freetype
#endif
#if $[HAVE_GL]
#print + OpenGL
#else
#print - Did not find OpenGL
#endif
#if $[HAVE_DX]
#print + DirectX
#else
#print - Did not find DirectX
#endif
#if $[HAVE_MAYA]
#print + OpenMaya
#else
#print - Did not find OpenMaya
#endif

#print
#if $[and $[HAVE_INTERROGATE],$[HAVE_PYTHON]]
#print Compilation will generate Python interfaces.
#else
#print Configuring Panda WITHOUT Python interfaces.
#endif

#print
#print See dtool_config.h for more details about the specified configuration.

#print

// We don't include the ppremake version in the first comment line of
// the output to dtool_config.h, below, to minimize unnecessary
// complete rebuilds due to an updated ppremake version.
#output dtool_config.h notouch
#format straight
/* dtool_config.h.  Generated automatically by $[PPREMAKE] from $[SOURCEFILE]. */

/* Define if we have Python installed.  */
$[cdefine HAVE_PYTHON]
/* Define if we have Python as a framework (Mac OS X).  */
$[cdefine PYTHON_FRAMEWORK]

/* Define if we have RAD game tools, Miles Sound System installed.  */
$[cdefine HAVE_RAD_MSS]

/* Define if we have FMOD installed. */
$[cdefine HAVE_FMOD]

/* Define if we have Freetype 2.0 or better available. */
$[cdefine HAVE_FREETYPE]

/* Define if we want to compile in a default font. */
$[cdefine COMPILE_IN_DEFAULT_FONT]

/* Define if we have Maya available. */
$[cdefine HAVE_MAYA]
$[cdefine MAYA_PRE_5_0]

/* Define if we have SoftImage available. */
$[cdefine HAVE_SOFTIMAGE]

/* Define if we have NSPR installed.  */
$[cdefine HAVE_NSPR]

/* Define if we have OpenSSL installed.  */
$[cdefine HAVE_SSL]
$[cdefine SSL_097]
$[cdefine REPORT_OPENSSL_ERRORS]

/* Define if we have libjpeg installed.  */
$[cdefine HAVE_JPEG]

/* Define if we have libpng installed.  */
$[cdefine HAVE_PNG]

/* Define if we have libtiff installed.  */
$[cdefine HAVE_TIFF]

/* Define if we have libfftw installed.  */
$[cdefine HAVE_FFTW]

/* Define if we have NURBS++ installed.  */
$[cdefine HAVE_NURBSPP]

/* Define if we have VRPN installed.  */
$[cdefine HAVE_VRPN]

/* Define if we have HELIX installed.  */
$[cdefine HAVE_HELIX]

/* Define if we have CG installed.  */
$[cdefine HAVE_CG]

/* Define if we have CGGL installed.  */
$[cdefine HAVE_CGGL]

/* Define if we have zlib installed.  */
$[cdefine HAVE_ZLIB]

/* Define if we have OpenGL installed and want to build for GL.  */
$[cdefine HAVE_GL]

/* Define if we have Mesa installed and want to build mesadisplay.  */
$[cdefine HAVE_MESA]
$[cdefine MESA_MGL]

/* Define if we want to build with SGI OpenGL extensions.  */
$[cdefine HAVE_SGIGL]

/* Define if we have GLX installed and want to build for GLX.  */
$[cdefine HAVE_GLX]

/* Define if we have Windows-GL installed and want to build for Wgl.  */
$[cdefine HAVE_WGL]

/* Define if we have DirectX installed and want to build for DX.  */
$[cdefine HAVE_DX]

/* Define if we have Chromium installed and want to use it.  */
$[cdefine HAVE_CHROMIUM]

/* Define if we want to compile the threading code.  */
$[cdefine HAVE_THREADS]

/* Define if we want to compile the net code.  */
$[cdefine HAVE_NET]

/* Define if we want to compile the audio code.  */
$[cdefine HAVE_AUDIO]

/* Define if we have bison and flex available. */
$[cdefine HAVE_BISON]

/* Define if we want to use PStats.  */
$[cdefine DO_PSTATS]

/* Define if we want to provide collision system recording and
   visualization tools. */
$[cdefine DO_COLLISION_RECORDING]

/* Define if we want to track callbacks from within the show code.  */
$[cdefine TRACK_IN_INTERPRETER]

/* Define if we want to enable track-memory-usage.  */
$[cdefine DO_MEMORY_USAGE]

/* Define if we want to compile in support for pipelining.  */
$[cdefine DO_PIPELINING]

/* Define if we want to keep Notify debug messages around, or undefine 
   to compile them out.  */
$[cdefine NOTIFY_DEBUG]

/* Define if we want to export template classes from the DLL.  Only
   makes sense to MSVC++. */
$[cdefine EXPORT_TEMPLATES]

/* Define if we are linking PANDAGL in with PANDA. */
$[cdefine LINK_IN_GL]

/* Define if we are linking PANDAPHYSICS in with PANDA. */
$[cdefine LINK_IN_PHYSICS]

/* The compiled-in character(s) to expect to separate different
   components of a path list (e.g. $PRC_PATH). */
# define DEFAULT_PATHSEP "$[DEFAULT_PATHSEP]"

/* The compiled-in default directory to look for the Configrc file, in
   the absence of the PRC_DIR environment variable set, and in
   the absence of anything specified via the configpath directive. */
# define DEFAULT_PRC_DIR "$[unixfilename $[DEFAULT_PRC_DIR]]"

/* The compiled-in name of the environment variable(s) that contain
   the name of a single directory in which to search for prc files. */
# define PRC_DIR_ENVVARS "$[PRC_DIR_ENVVARS]"

/* The compiled-in name of the environment variable(s) that contain
   the name of multiple directories, separated by DEFAULT_PATHSEP, in
   which to search for prc files. */
# define PRC_PATH_ENVVARS "$[PRC_PATH_ENVVARS]"

/* The filename(s) to search for in the above paths.  Normally this is
   *.prc. */
# define PRC_PATTERNS "$[PRC_PATTERNS]"

/* The filename(s) to search for, and execute, in the above paths.
   Normally this is empty. */
# define PRC_EXECUTABLE_PATTERNS "$[PRC_EXECUTABLE_PATTERNS]"

/* The environment variable that defines optional args to pass to
   executables found that match one of the above patterns. */
# define PRC_EXECUTABLE_ARGS_ENVVAR "$[PRC_EXECUTABLE_ARGS_ENVVAR]"

/* The filename that specifies the public keys to import into
   config. */
# define PRC_PUBLIC_KEYS_FILENAME "$[unixfilename $[PRC_PUBLIC_KEYS_FILENAME]]"
#if $[PRC_PUBLIC_KEYS_FILENAME]
# define PRC_PUBLIC_KEYS_INCLUDE "$[osfilename $[PRC_PUBLIC_KEYS_FILENAME]]"
#endif

/* Define if we want to enable the "trust_level" feature of prc config
   variables.  This requires OpenSSL and PRC_PUBLIC_KEYS_FILENAME,
   above. */
$[cdefine PRC_RESPECT_TRUST_LEVEL]

/* Define if you want to save the descriptions for ConfigVariables. */
$[cdefine PRC_SAVE_DESCRIPTIONS]


/* Define if your processor stores words with the most significant
   byte first (like Motorola and SPARC, unlike Intel and VAX).  */
$[cdefine WORDS_BIGENDIAN]

/* Define if the C++ compiler uses namespaces.  */
$[cdefine HAVE_NAMESPACE]

/* Define if fstream::open() accepts a third parameter for umask. */
$[cdefine HAVE_OPEN_MASK]

/* Define if some header file defines wchar_t. */
$[cdefine HAVE_WCHAR_T]

/* Define if the <string> header file defines wstring. */
$[cdefine HAVE_WSTRING]

/* Define if the C++ compiler supports the typename keyword.  */
$[cdefine HAVE_TYPENAME]

/* Define if we can trust the compiler not to insert extra bytes in
   structs between base structs and derived structs. */
$[cdefine SIMPLE_STRUCT_POINTERS]

/* Define if we have Dinkumware STL installed.  */
$[cdefine HAVE_DINKUM]

/* Define if we have STL hash_map etc. available  */
$[cdefine HAVE_STL_HASH]

/* Define if we have a gettimeofday() function. */
$[cdefine HAVE_GETTIMEOFDAY]

/* Define if gettimeofday() takes only one parameter. */
$[cdefine GETTIMEOFDAY_ONE_PARAM]

/* Define if you have the getopt function.  */
$[cdefine HAVE_GETOPT]

/* Define if you have the getopt_long_only function.  */
$[cdefine HAVE_GETOPT_LONG_ONLY]

/* Define if getopt appears in getopt.h.  */
$[cdefine HAVE_GETOPT_H]

/* Define if you have ioctl(TIOCGWINSZ) to determine terminal width. */
$[cdefine IOCTL_TERMINAL_WIDTH]

/* Do the system headers define a "streamsize" typedef? */
$[cdefine HAVE_STREAMSIZE]

/* Do the system headers define key ios typedefs like ios::openmode
   and ios::fmtflags? */
$[cdefine HAVE_IOS_TYPEDEFS]

/* Define if the C++ iostream library defines ios::binary.  */
$[cdefine HAVE_IOS_BINARY]

/* Can we safely call getenv() at static init time? */
$[cdefine STATIC_INIT_GETENV]

/* Can we read the file /proc/self/environ to determine our
   environment variables at static init time? */
$[cdefine HAVE_PROC_SELF_ENVIRON]

/* Do we have a global pair of argc/argv variables that we can read at
   static init time?  Should we prototype them?  What are they called? */
$[cdefine HAVE_GLOBAL_ARGV]
$[cdefine PROTOTYPE_GLOBAL_ARGV]
$[cdefine GLOBAL_ARGV]
$[cdefine GLOBAL_ARGC]

/* Can we read the file /proc/self/cmdline to determine our
   command-line arguments at static init time? */
$[cdefine HAVE_PROC_SELF_CMDLINE]

/* Define if you have the <io.h> header file.  */
$[cdefine HAVE_IO_H]

/* Define if you have the <iostream> header file.  */
$[cdefine HAVE_IOSTREAM]

/* Define if you have the <malloc.h> header file.  */
$[cdefine HAVE_MALLOC_H]

/* Define if you have the <sys/malloc.h> header file.  */
$[cdefine HAVE_SYS_MALLOC_H]

/* Define if you have the <alloca.h> header file.  */
$[cdefine HAVE_ALLOCA_H]

/* Define if you have the <locale.h> header file.  */
$[cdefine HAVE_LOCALE_H]

/* Define if you have the <minmax.h> header file.  */
$[cdefine HAVE_MINMAX_H]

/* Define if you have the <sstream> header file.  */
$[cdefine HAVE_SSTREAM]

/* Define if you have the <new> header file.  */
$[cdefine HAVE_NEW]

/* Define if you have the <sys/types.h> header file.  */
$[cdefine HAVE_SYS_TYPES_H]

/* Define if you have the <sys/time.h> header file.  */
$[cdefine HAVE_SYS_TIME_H]

/* Define if you have the <unistd.h> header file.  */
$[cdefine HAVE_UNISTD_H]

/* Define if you have the <utime.h> header file.  */
$[cdefine HAVE_UTIME_H]

/* Define if you have the <glob.h> header file.  */
$[cdefine HAVE_GLOB_H]

/* Define if you have the <dirent.h> header file.  */
$[cdefine HAVE_DIRENT_H]

/* Do we have <sys/soundcard.h> (and presumably a Linux-style audio
   interface)? */
$[cdefine HAVE_SYS_SOUNDCARD_H]

/* Do we have RTTI (and <typeinfo>)? */
$[cdefine HAVE_RTTI]

/* Must global operator new and delete functions throw exceptions? */
$[cdefine GLOBAL_OPERATOR_NEW_EXCEPTIONS]

/* What style STL allocator should we declare? */
#define OLD_STYLE_ALLOCATOR
#define GNU_STYLE_ALLOCATOR
#define VC6_STYLE_ALLOCATOR
#define MODERN_STYLE_ALLOCATOR
#define NO_STYLE_ALLOCATOR
#if $[eq $[OPTIMIZE], 4]
  // In optimize level 4, we never try to use custom allocators.
  #set NO_STYLE_ALLOCATOR 1
#elif $[eq $[STL_ALLOCATOR], OLD]
  // "OLD": Irix 6.2-era STL.
  #set OLD_STYLE_ALLOCATOR 1
#elif $[eq $[STL_ALLOCATOR], GNU]
  // "GNU": gcc 2.95-era.
  #set GNU_STYLE_ALLOCATOR 1
#elif $[eq $[STL_ALLOCATOR], VC6]
  // "VC6": Microsoft Visual C++ 6.
  #set VC6_STYLE_ALLOCATOR 1
#elif $[eq $[STL_ALLOCATOR], MODERN]
  // "MODERN": Have we finally come to a standard?
  #set MODERN_STYLE_ALLOCATOR 1
#else
  // Anything else is "unknown".  We won't try to define allocators at
  // all.
  #set NO_STYLE_ALLOCATOR 1
#endif
$[cdefine OLD_STYLE_ALLOCATOR]
$[cdefine GNU_STYLE_ALLOCATOR]
$[cdefine VC6_STYLE_ALLOCATOR]
$[cdefine MODERN_STYLE_ALLOCATOR]
$[cdefine NO_STYLE_ALLOCATOR]

#end dtool_config.h
