// Filename: test_builder_data.cxx
// Created by:  drose (11Sep97)
//
////////////////////////////////////////////////////////////////////
//
// PANDA 3D SOFTWARE
// Copyright (c) 2001 - 2004, Disney Enterprises, Inc.  All rights reserved
//
// All use of this software is subject to the terms of the Panda 3d
// Software license.  You should have received a copy of this license
// along with this source code; you will also find a current copy of
// the license at http://etc.cmu.edu/panda3d/docs/license/ .
//
// To contact the maintainers of this program write to
// panda3d-general@lists.sourceforge.net .
//
////////////////////////////////////////////////////////////////////

#include "builderPrim.h"

int hedface_vt_len = 337;
Vertexf hedface_vt[337] = {
  Vertexf(),
  Vertexf(0.045221, 6.59701, 0.374149),
  Vertexf(0.051493, 6.53504, 0.41213),
  Vertexf(-0.004945, 6.54228, 0.460135),
  Vertexf(-0.006027, 6.59713, 0.428656),
  Vertexf(-0.163023, 6.4847, 0.375736),
  Vertexf(-0.204045, 6.4752, 0.347943),
  Vertexf(-0.18025, 6.50566, 0.329401),
  Vertexf(-0.159739, 6.51041, 0.343297),
  Vertexf(-0.041928, 6.54233, 0.460079),
  Vertexf(-0.040616, 6.59717, 0.428604),
  Vertexf(0.116272, 6.4844, 0.376158),
  Vertexf(0.119393, 6.45869, 0.408606),
  Vertexf(0.057765, 6.47306, 0.45011),
  Vertexf(-0.003863, 6.48744, 0.491613),
  Vertexf(0.157357, 6.47482, 0.348488),
  Vertexf(0.181021, 6.44431, 0.367102),
  Vertexf(-0.098236, 6.5352, 0.411904),
  Vertexf(-0.091699, 6.59716, 0.373943),
  Vertexf(0.113151, 6.51012, 0.343709),
  Vertexf(0.05625, 6.68185, 0.38825),
  Vertexf(0.052935, 6.65809, 0.388478),
  Vertexf(0.038183, 6.65814, 0.391172),
  Vertexf(0.038209, 6.68243, 0.390851),
  Vertexf(-0.08114, 6.70556, 0.357325),
  Vertexf(-0.074757, 6.70668, 0.327237),
  Vertexf(-0.06435, 6.75423, 0.318492),
  Vertexf(-0.076311, 6.74108, 0.348446),
  Vertexf(0.056607, 6.65772, 0.361073),
  Vertexf(0.056632, 6.68102, 0.360765),
  Vertexf(0.050611, 6.65837, 0.333519),
  Vertexf(-0.105274, 6.67711, 0.384106),
  Vertexf(-0.102005, 6.6582, 0.384442),
  Vertexf(-0.10409, 6.65786, 0.358346),
  Vertexf(-0.104068, 6.6782, 0.358076),
  Vertexf(0.133694, 6.50533, 0.329875),
  Vertexf(-0.056482, 6.84607, 0.309156),
  Vertexf(-0.053944, 6.80178, 0.309746),
  Vertexf(-0.088991, 6.83803, 0.302363),
  Vertexf(-0.07393, 6.90532, 0.300343),
  Vertexf(0.028345, 6.90521, 0.300498),
  Vertexf(0.043257, 6.83789, 0.302563),
  Vertexf(0.008112, 6.80171, 0.30984),
  Vertexf(0.010745, 6.846, 0.309258),
  Vertexf(-0.094717, 6.80544, 0.300714),
  Vertexf(-0.194166, 6.81436, 0.278684),
  Vertexf(-0.162377, 6.84458, 0.287335),
  Vertexf(-0.103944, 6.82835, 0.296707),
  Vertexf(-0.204143, 6.94657, 0.295928),
  Vertexf(-0.201354, 6.95975, 0.298222),
  Vertexf(-0.169019, 6.95635, 0.305305),
  Vertexf(-0.178088, 6.94025, 0.302407),
  Vertexf(-0.087574, 6.65823, 0.388024),
  Vertexf(-0.087552, 6.67872, 0.387753),
  Vertexf(-0.039303, 6.65201, 0.397128),
  Vertexf(0.051495, 6.70678, 0.35635),
  Vertexf(0.033453, 6.70736, 0.358952),
  Vertexf(-0.036388, 6.44535, 0.478493),
  Vertexf(-0.023597, 6.43031, 0.477217),
  Vertexf(-0.098546, 6.43648, 0.44227),
  Vertexf(-0.100206, 6.44582, 0.442143),
  Vertexf(-0.164024, 6.44429, 0.404327),
  Vertexf(-0.163195, 6.43863, 0.404403),
  Vertexf(-0.227839, 6.44475, 0.366484),
  Vertexf(0.11709, 6.44598, 0.404725),
  Vertexf(0.13215, 6.4488, 0.39385),
  Vertexf(0.168279, 6.44653, 0.364598),
  Vertexf(0.038949, 6.65899, 0.336169),
  Vertexf(-0.007109, 6.65198, 0.397178),
  Vertexf(0.046712, 6.70598, 0.324792),
  Vertexf(0.036091, 6.73257, 0.383482),
  Vertexf(0.027241, 6.74335, 0.351049),
  Vertexf(-0.024001, 6.23599, 0.606704),
  Vertexf(-0.024029, 6.21889, 0.613174),
  Vertexf(-0.046614, 6.21572, 0.610968),
  Vertexf(-0.051099, 6.234, 0.60249),
  Vertexf(0.003109, 6.23394, 0.602571),
  Vertexf(-0.001441, 6.21567, 0.611036),
  Vertexf(-0.042134, 6.20409, 0.627544),
  Vertexf(-0.039909, 6.2022, 0.648599),
  Vertexf(-0.024097, 6.19903, 0.644253),
  Vertexf(-0.024073, 6.19793, 0.627118),
  Vertexf(-0.024129, 6.18605, 0.656217),
  Vertexf(-0.010583, 6.1849, 0.660713),
  Vertexf(-0.008288, 6.20216, 0.648647),
  Vertexf(-0.02414, 6.18435, 0.662939),
  Vertexf(-0.024101, 6.20376, 0.650817),
  Vertexf(-0.085163, 6.65912, 0.335982),
  Vertexf(-0.024152, 6.1629, 0.656118),
  Vertexf(-0.035442, 6.16465, 0.655261),
  Vertexf(-0.037687, 6.18493, 0.660672),
  Vertexf(-0.024131, 6.15434, 0.63571),
  Vertexf(-0.033164, 6.15576, 0.63633),
  Vertexf(-0.012855, 6.16463, 0.655295),
  Vertexf(-0.015095, 6.15574, 0.636358),
  Vertexf(-0.02403, 6.20933, 0.606675),
  Vertexf(-0.005995, 6.20405, 0.627598),
  Vertexf(-0.024063, 6.20715, 0.627798),
  Vertexf(-0.024144, 6.1681, 0.653605),
  Vertexf(-0.003116, 6.4359, 0.174903),
  Vertexf(-0.043102, 6.43593, 0.174842),
  Vertexf(-0.043515, 6.48837, 0.174148),
  Vertexf(-0.002372, 6.48835, 0.174209),
  Vertexf(0.115485, 6.41793, 0.441265),
  Vertexf(0.049948, 6.38957, 0.515453),
  Vertexf(0.051474, 6.43632, 0.442496),
  Vertexf(0.11625, 6.44229, 0.404773),
  Vertexf(0.11793, 6.44966, 0.404678),
  Vertexf(0.054838, 6.455, 0.442254),
  Vertexf(0.053156, 6.44566, 0.442375),
  Vertexf(-0.215724, 6.44831, 0.36377),
  Vertexf(-0.178985, 6.44921, 0.393528),
  Vertexf(0.132116, 6.43478, 0.376846),
  Vertexf(0.081514, 6.43627, 0.276983),
  Vertexf(0.125673, 6.433, 0.277093),
  Vertexf(-0.023729, 6.39172, 0.536235),
  Vertexf(-0.16259, 6.41625, 0.440871),
  Vertexf(0.081667, 6.43492, 0.175042),
  Vertexf(0.042326, 6.43548, 0.174976),
  Vertexf(0.042875, 6.48598, 0.174308),
  Vertexf(0.082021, 6.48349, 0.1744),
  Vertexf(-0.010775, 6.44532, 0.478531),
  Vertexf(-0.179019, 6.43519, 0.376525),
  Vertexf(-0.128071, 6.43656, 0.276666),
  Vertexf(-0.088566, 6.43707, 0.276718),
  Vertexf(-0.120423, 6.43613, 0.41066),
  Vertexf(-0.179061, 6.48408, 0.349586),
  Vertexf(-0.128102, 6.48581, 0.276014),
  Vertexf(-0.166981, 6.48194, 0.276007),
  Vertexf(0.073698, 6.44983, 0.427624),
  Vertexf(0.073664, 6.43581, 0.410621),
  Vertexf(0.13215, 6.4488, 0.39385),
  Vertexf(-0.053819, 6.48884, 0.416828),
  Vertexf(-0.043668, 6.48972, 0.276088),
  Vertexf(-0.088788, 6.48758, 0.276049),
  Vertexf(-0.12075, 6.48629, 0.383705),
  Vertexf(0.007052, 6.45585, 0.460591),
  Vertexf(0.00726, 6.48879, 0.416675),
  Vertexf(-0.054026, 6.45591, 0.460743),
  Vertexf(0.132646, 6.483, 0.349918),
  Vertexf(0.081868, 6.48484, 0.276341),
  Vertexf(0.042723, 6.48733, 0.276249),
  Vertexf(0.074482, 6.48596, 0.383667),
  Vertexf(0.120223, 6.48035, 0.276458),
  Vertexf(0.168279, 6.44653, 0.364598),
  Vertexf(-0.053173, 6.45076, 0.460301),
  Vertexf(-0.053207, 6.43674, 0.443297),
  Vertexf(0.006154, 6.43669, 0.443142),
  Vertexf(0.006188, 6.45071, 0.460146),
  Vertexf(-0.088413, 6.43573, 0.174777),
  Vertexf(-0.043255, 6.43728, 0.276783),
  Vertexf(-0.002525, 6.4897, 0.27615),
  Vertexf(0.11279, 6.41322, 0.399904),
  Vertexf(0.181156, 6.44226, 0.277053),
  Vertexf(0.112895, 6.40928, 0.325903),
  Vertexf(-0.091652, 6.37645, 0.374546),
  Vertexf(-0.159678, 6.40957, 0.325491),
  Vertexf(-0.159784, 6.41351, 0.399492),
  Vertexf(-0.091728, 6.38228, 0.4325),
  Vertexf(0.042174, 6.43683, 0.276917),
  Vertexf(-0.008253, 6.46035, 0.47983),
  Vertexf(0.007052, 6.45585, 0.460591),
  Vertexf(-0.054026, 6.45591, 0.460743),
  Vertexf(-0.038879, 6.46038, 0.479784),
  Vertexf(-0.04324, 6.48748, 0.491554),
  Vertexf(0.006188, 6.45071, 0.460146),
  Vertexf(0.073698, 6.44983, 0.427624),
  Vertexf(-0.120389, 6.45015, 0.427664),
  Vertexf(-0.053173, 6.45076, 0.460301),
  Vertexf(-0.140225, 7.00983, 0.321446),
  Vertexf(-0.123119, 7.01151, 0.328341),
  Vertexf(-0.134749, 6.97962, 0.323871),
  Vertexf(-0.142948, 6.98128, 0.319329),
  Vertexf(0.18119, 6.42198, 0.240696),
  Vertexf(0.112929, 6.389, 0.289545),
  Vertexf(-0.023958, 6.27715, 0.605697),
  Vertexf(-0.023963, 6.25473, 0.593607),
  Vertexf(0.007645, 6.2539, 0.604398),
  Vertexf(0.012162, 6.27018, 0.615932),
  Vertexf(0.044667, 6.35602, 0.338395),
  Vertexf(-0.023594, 6.32304, 0.387244),
  Vertexf(-0.023627, 6.34332, 0.423602),
  Vertexf(0.044634, 6.3763, 0.374752),
  Vertexf(-0.101866, 6.45517, 0.442017),
  Vertexf(-0.120958, 6.45335, 0.427621),
  Vertexf(-0.179269, 6.45115, 0.393502),
  Vertexf(-0.164852, 6.44996, 0.404251),
  Vertexf(-0.127919, 6.43522, 0.174725),
  Vertexf(-0.172614, 6.43334, 0.174683),
  Vertexf(-0.166828, 6.4806, 0.174066),
  Vertexf(-0.12795, 6.48446, 0.174073),
  Vertexf(-0.172766, 6.43469, 0.276624),
  Vertexf(-0.023673, 6.35105, 0.465508),
  Vertexf(0.044558, 6.38213, 0.432706),
  Vertexf(-0.166306, 6.45899, 0.408174),
  Vertexf(0.114721, 6.39357, 0.477756),
  Vertexf(-0.068907, 6.93005, 0.3295),
  Vertexf(-0.081264, 6.91456, 0.321684),
  Vertexf(0.021212, 6.29084, 0.620743),
  Vertexf(-0.02399, 6.26675, 0.620987),
  Vertexf(-0.023978, 6.28932, 0.628239),
  Vertexf(-0.060115, 6.27026, 0.615822),
  Vertexf(-0.069134, 6.29094, 0.620607),
  Vertexf(-0.023865, 6.32255, 0.574454),
  Vertexf(0.048421, 6.34283, 0.588411),
  Vertexf(0.074274, 6.45303, 0.427583),
  Vertexf(-0.161986, 6.39386, 0.477338),
  Vertexf(-0.096133, 6.34298, 0.588192),
  Vertexf(-0.178985, 6.44921, 0.393528),
  Vertexf(-0.120389, 6.45015, 0.427664),
  Vertexf(-0.091619, 6.35617, 0.338189),
  Vertexf(0.077674, 7.01129, 0.328644),
  Vertexf(0.08925, 6.97938, 0.324209),
  Vertexf(0.035634, 6.91444, 0.32186),
  Vertexf(0.023287, 6.92995, 0.329639),
  Vertexf(-0.088636, 6.48623, 0.174108),
  Vertexf(0.010745, 6.846, 0.309258),
  Vertexf(0.015997, 6.92072, 0.308277),
  Vertexf(0.094448, 7.01026, 0.32246),
  Vertexf(0.15589, 6.95937, 0.298762),
  Vertexf(0.123526, 6.95604, 0.305746),
  Vertexf(0.097137, 6.98214, 0.319113),
  Vertexf(0.030275, 6.31191, 0.617283),
  Vertexf(-0.023949, 6.3137, 0.626308),
  Vertexf(-0.02394, 6.29401, 0.605607),
  Vertexf(-0.023916, 6.30851, 0.599061),
  Vertexf(-0.003269, 6.43725, 0.276843),
  Vertexf(0.091554, 6.96985, 0.299337),
  Vertexf(0.08196, 6.97015, 0.302846),
  Vertexf(-0.078141, 6.31202, 0.61712),
  Vertexf(0.070384, 7.00207, 0.307281),
  Vertexf(-0.227704, 6.44269, 0.276436),
  Vertexf(-0.156456, 6.53612, 0.310859),
  Vertexf(0.11003, 6.53584, 0.311261),
  Vertexf(0.132438, 6.45006, 0.393834),
  Vertexf(-0.097339, 6.38973, 0.515231),
  Vertexf(0.132438, 6.45006, 0.393834),
  Vertexf(0.074274, 6.45303, 0.427583),
  Vertexf(0.120375, 6.479, 0.174517),
  Vertexf(0.125825, 6.43165, 0.175152),
  Vertexf(0.028345, 6.90521, 0.300498),
  Vertexf(-0.159645, 6.38929, 0.289133),
  Vertexf(-0.104773, 6.47324, 0.449864),
  Vertexf(-0.215724, 6.44831, 0.36377),
  Vertexf(-0.131591, 6.96754, 0.300267),
  Vertexf(-0.161684, 6.94711, 0.283964),
  Vertexf(-0.129814, 6.99298, 0.301599),
  Vertexf(-0.115784, 7.00226, 0.307),
  Vertexf(-0.061573, 6.9208, 0.30816),
  Vertexf(-0.167969, 6.93295, 0.282982),
  Vertexf(-0.040067, 6.66458, 0.505563),
  Vertexf(-0.039454, 6.62437, 0.477676),
  Vertexf(-0.087687, 6.65527, 0.461334),
  Vertexf(-0.088272, 6.72793, 0.378401),
  Vertexf(-0.088393, 6.70869, 0.445015),
  Vertexf(-0.098863, 6.70395, 0.353678),
  Vertexf(-0.056482, 6.84607, 0.309156),
  Vertexf(-0.041096, 6.73064, 0.482186),
  Vertexf(0.038076, 6.65896, 0.462433),
  Vertexf(0.035976, 6.71327, 0.446101),
  Vertexf(0.08381, 6.99315, 0.302152),
  Vertexf(0.1486, 6.95015, 0.277399),
  Vertexf(-0.00726, 6.62434, 0.477725),
  Vertexf(-0.008959, 6.66524, 0.505601),
  Vertexf(0.02867, 6.70656, 0.327393),
  Vertexf(-0.179269, 6.45115, 0.393502),
  Vertexf(0.134358, 6.93999, 0.302389),
  Vertexf(0.159456, 6.94608, 0.296165),
  Vertexf(0.018391, 6.75414, 0.318617),
  Vertexf(-0.22767, 6.42241, 0.240078),
  Vertexf(-0.069554, 7.00945, 0.310645),
  Vertexf(-0.115784, 7.00226, 0.307),
  Vertexf(0.163425, 6.80702, 0.199637),
  Vertexf(-0.023861, 6.35313, 0.595253),
  Vertexf(-0.161684, 6.94711, 0.283964),
  Vertexf(-0.131591, 6.96754, 0.300267),
  Vertexf(-0.127415, 6.97038, 0.30253),
  Vertexf(-0.127415, 6.97038, 0.30253),
  Vertexf(-0.07393, 6.90532, 0.300343),
  Vertexf(0.148469, 6.8287, 0.279006),
  Vertexf(0.124864, 6.92982, 0.283536),
  Vertexf(-0.208912, 6.80741, 0.199075),
  Vertexf(-0.147148, 6.64856, 0.281136),
  Vertexf(-0.14701, 6.64735, 0.189092),
  Vertexf(-0.02399, 6.22995, 0.594216),
  Vertexf(-0.061573, 6.9208, 0.30816),
  Vertexf(-0.046619, 6.90315, 0.320843),
  Vertexf(-0.041466, 6.79966, 0.369073),
  Vertexf(-0.013462, 6.80239, 0.375073),
  Vertexf(0.023846, 7.00935, 0.310786),
  Vertexf(0.070384, 7.00207, 0.307281),
  Vertexf(-0.194019, 6.95051, 0.276882),
  Vertexf(-0.011997, 6.73258, 0.482204),
  Vertexf(-0.096505, 6.65755, 0.332384),
  Vertexf(-0.092479, 6.70507, 0.32359),
  Vertexf(0.055599, 6.80587, 0.299473),
  Vertexf(0.059185, 6.82536, 0.29725),
  Vertexf(-0.194037, 6.93438, 0.277095),
  Vertexf(-0.194019, 6.95051, 0.276882),
  Vertexf(-0.167969, 6.93295, 0.282982),
  Vertexf(-0.19415, 6.82906, 0.278489),
  Vertexf(-0.156387, 6.53551, 0.264837),
  Vertexf(-0.024129, 6.15856, 0.637607),
  Vertexf(0.1486, 6.95015, 0.277399),
  Vertexf(-0.194037, 6.93438, 0.277095),
  Vertexf(-0.120958, 6.45335, 0.427621),
  Vertexf(0.148583, 6.93434, 0.277608),
  Vertexf(-0.013559, 6.78726, 0.428727),
  Vertexf(-0.041572, 6.78462, 0.42872),
  Vertexf(-0.156318, 6.5349, 0.218815),
  Vertexf(0.148453, 6.81399, 0.279201),
  Vertexf(0.101077, 6.6483, 0.281511),
  Vertexf(0.101215, 6.64708, 0.189467),
  Vertexf(0.110099, 6.53523, 0.26524),
  Vertexf(0.110168, 6.53462, 0.219218),
  Vertexf(0.08196, 6.97015, 0.302846),
  Vertexf(0.091554, 6.96985, 0.299337),
  Vertexf(0.116237, 6.94682, 0.284384),
  Vertexf(0.116702, 6.84429, 0.287756),
  Vertexf(0.124864, 6.92982, 0.283536),
  Vertexf(0.148469, 6.8287, 0.279006),
  Vertexf(0.015997, 6.92072, 0.308277),
  Vertexf(0.000968, 6.9031, 0.320915),
  Vertexf(-0.022854, 7.0094, 0.310715),
  Vertexf(-0.023987, 6.25354, 0.609743),
  Vertexf(-0.023889, 6.31842, 0.587859),
  Vertexf(0.039346, 6.33018, 0.605966),
  Vertexf(-0.023908, 6.33618, 0.614913),
  Vertexf(-0.096133, 6.34298, 0.588192),
  Vertexf(-0.087138, 6.33031, 0.605775),
  Vertexf(-0.023865, 6.32255, 0.574454),
  Vertexf(0.048421, 6.34283, 0.588411),
  Vertexf(-0.023861, 6.35313, 0.595253),
  Vertexf(0.148583, 6.93434, 0.277608),
  Vertexf(-0.055597, 6.25397, 0.604303),
  Vertexf(0.116237, 6.94682, 0.284384),
  Vertexf(-0.19415, 6.82906, 0.278489),
};

//#define VVAL(i) hedface_vt[i]
#define VVAL(i) i

class polygon : public BuilderPrimI {
public:
  polygon(int i, int j, int k) {
    add_vertex(VVAL(i));
    add_vertex(VVAL(j));
    add_vertex(VVAL(k));
  }
  polygon(int i, int j, int k, int l) {
    add_vertex(VVAL(i));
    add_vertex(VVAL(j));
    add_vertex(VVAL(k));
    add_vertex(VVAL(l));
  }
  polygon(int i, int j, int k, int l, int m) {
    add_vertex(VVAL(i));
    add_vertex(VVAL(j));
    add_vertex(VVAL(k));
    add_vertex(VVAL(l));
    add_vertex(VVAL(m));
  }
  polygon(int i, int j, int k, int l, int m, int n) {
    add_vertex(VVAL(i));
    add_vertex(VVAL(j));
    add_vertex(VVAL(k));
    add_vertex(VVAL(l));
    add_vertex(VVAL(m));
    add_vertex(VVAL(n));
  }
  polygon(int i, int j, int k, int l, int m, int n, int o) {
    add_vertex(VVAL(i));
    add_vertex(VVAL(j));
    add_vertex(VVAL(k));
    add_vertex(VVAL(l));
    add_vertex(VVAL(m));
    add_vertex(VVAL(n));
    add_vertex(VVAL(o));
  }
};

polygon polys[] = {
  polygon(4, 3, 2, 1),
  polygon(8, 7, 6, 5),
  polygon(10, 9, 3, 4),
  polygon(2, 13, 12, 11),
  polygon(3, 14, 13, 2),
  polygon(11, 12, 16, 15),
  polygon(18, 17, 9, 10),
  polygon(8, 5, 17, 18),
  polygon(1, 2, 11, 19),
  polygon(23, 22, 21, 20),
  polygon(27, 26, 25, 24),
  polygon(30, 29, 28),
  polygon(20, 21, 28, 29),
  polygon(34, 33, 32, 31),
  polygon(19, 11, 15, 35),
  polygon(39, 38, 37, 36),
  polygon(43, 42, 41, 40),
  polygon(47, 46, 45, 44),
  polygon(51, 50, 49, 48),
  polygon(54, 53, 52),
  polygon(31, 32, 52, 53),
  polygon(56, 23, 20, 55),
  polygon(55, 20, 29),
  /*
  polygon(60, 59, 58, 57),
  polygon(63, 62, 61),
  polygon(16, 66, 65, 64),
  polygon(68, 67, 22),
  polygon(30, 69, 55, 29),
  polygon(71, 70, 23, 56),
  polygon(75, 74, 73, 72),
  polygon(72, 73, 77, 76),
  polygon(81, 80, 79, 78),
  polygon(84, 83, 82, 80),
  polygon(86, 85, 83, 84),
  polygon(52, 87, 54),
  polygon(90, 89, 88, 85),
  polygon(89, 92, 91, 88),
  polygon(88, 91, 94, 93),
  polygon(77, 96, 81, 95),
  polygon(78, 79, 86, 97),
  polygon(80, 82, 90, 79),
  polygon(82, 98, 89, 90),
  polygon(102, 101, 100, 99),
  polygon(106, 105, 104, 103),
  polygon(108, 107, 12, 13),
  polygon(1, 67, 68, 4),
  polygon(109, 105, 106, 64),
  polygon(61, 111, 110, 63),
  polygon(114, 113, 112),
  polygon(104, 105, 58, 115),
  polygon(62, 63, 116),
  polygon(120, 119, 118, 117),
  polygon(121, 58, 105, 109),
  polygon(125, 124, 123, 122),
  polygon(128, 127, 126),
  polygon(65, 112, 130, 129),
  polygon(135, 134, 133, 132),
  polygon(138, 132, 137, 136),
  polygon(142, 141, 140, 139),
  polygon(66, 143, 114),
  polygon(148, 147, 146, 145),
  polygon(150, 100, 149, 124),
  polygon(133, 101, 102, 151),
  polygon(154, 153, 16, 152),
  polygon(158, 157, 156, 155),
  polygon(113, 117, 118, 159),
  polygon(163, 138, 136, 160),
  polygon(73, 97, 96, 77),
  polygon(96, 84, 80, 81),
  polygon(61, 62, 59, 60),
  polygon(22, 23, 68),
  polygon(9, 164, 14, 3),
  polygon(109, 129, 148, 121),
  polygon(57, 145, 167, 60),
  polygon(172, 171, 170, 169),
  polygon(174, 173, 153, 154),
  polygon(178, 177, 176, 175),
  polygon(182, 181, 180, 179),
  polygon(186, 185, 184, 183),
  polygon(190, 189, 188, 187),
  polygon(122, 123, 191),
  polygon(139, 140, 143),
  polygon(193, 192, 181, 182),
  polygon(183, 184, 138, 163),
  polygon(126, 127, 134, 135),
  polygon(194, 63, 186),
  polygon(60, 167, 111, 61),
  polygon(151, 102, 119, 141),
  polygon(152, 16, 195),
  polygon(66, 114, 112, 65),
  polygon(141, 119, 120, 140),
  polygon(170, 171, 197, 196),
  polygon(200, 199, 178, 198),
  polygon(202, 201, 199, 200),
  polygon(204, 203, 192, 193),
  polygon(136, 137, 142, 205),
  polygon(207, 206, 157, 158),
  polygon(167, 125, 122, 111),
  polygon(191, 188, 189, 128),
  polygon(128, 189, 190, 127),
  polygon(210, 180, 181, 155),
  polygon(214, 213, 212, 211),
  polygon(206, 63, 157),
  polygon(124, 149, 187, 123),
  polygon(134, 215, 101, 133),
  polygon(127, 190, 215, 134),
  polygon(214, 217, 43),
  polygon(221, 220, 219, 218),
  polygon(223, 200, 198, 222),
  polygon(224, 175, 201, 202),
  polygon(222, 198, 224, 225),
  polygon(159, 118, 99, 226),
  polygon(226, 99, 100, 150),
  polygon(123, 187, 188, 191),
  polygon(221, 212, 228, 227),
  polygon(229, 202, 200, 223),
  polygon(158, 192, 203, 207),
  polygon(198, 178, 175, 224),
  polygon(217, 214, 211, 230),
  polygon(157, 63, 231, 156),
  polygon(225, 224, 202, 229),
  polygon(63, 110, 185, 186),
  polygon(121, 148, 145, 57),
  polygon(64, 65, 129, 109),
  polygon(13, 14, 160, 108),
  polygon(8, 232, 7),
  polygon(19, 233, 67, 1),
  polygon(234, 66, 16),
  polygon(62, 116, 235, 59),
  polygon(149, 100, 101, 215),
  polygon(205, 142, 139, 234),
  polygon(145, 146, 125, 167),
  polygon(160, 136, 205, 108),
  polygon(108, 205, 234, 107),
  polygon(117, 239, 238, 120),
  polygon(103, 16, 106),
  polygon(234, 139, 143, 66),
  polygon(114, 239, 117, 113),
  polygon(228, 212, 213, 40),
  polygon(241, 210, 155, 156),
  polygon(186, 183, 242, 194),
  polygon(18, 87, 232, 8),
  polygon(64, 106, 16),
  polygon(57, 58, 121),
  polygon(143, 238, 239, 114),
  polygon(40, 213, 43),
  polygon(111, 122, 191, 110),
  polygon(129, 130, 147, 148),
  polygon(112, 113, 159, 130),
  polygon(147, 226, 150, 146),
  polygon(146, 150, 124, 125),
  polygon(172, 50, 245, 244),
  polygon(169, 170, 247, 246),
  polygon(247, 170, 196, 248),
  polygon(249, 245, 50, 51),
  polygon(252, 251, 250),
  polygon(24, 53, 253, 27),
  polygon(253, 53, 252, 254),
  polygon(34, 31, 255),
  polygon(36, 196, 197),
  polygon(67, 30, 28, 21, 22),
  polygon(250, 257, 254, 252),
  polygon(128, 110, 191),
  polygon(23, 70, 259, 258),
  polygon(130, 159, 226, 147),
  polygon(218, 219, 261, 260),
  polygon(248, 196, 36),
  polygon(263, 262, 258),
  polygon(264, 69, 30, 67),
  polygon(110, 128, 126, 185),
  polygon(68, 262, 251, 54),
  polygon(63, 206, 116),
  polygon(267, 219, 220, 266),
  polygon(53, 54, 251, 252),
  polygon(258, 262, 68, 23),
  polygon(264, 268, 71, 56),
  polygon(104, 204, 195, 103),
  polygon(107, 16, 12),
  polygon(115, 273, 204, 104),
  polygon(276, 244, 245, 46, 47, 38, 39),
  polygon(39, 197, 171, 276),
  polygon(235, 207, 273, 115),
  polygon(280, 279, 266),
  polygon(283, 282, 45, 281),
  polygon(177, 76, 284, 176),
  polygon(16, 107, 234),
  polygon(153, 233, 35, 15),
  polygon(282, 87, 25),
  polygon(287, 286, 248, 36),
  polygon(215, 190, 187, 149),
  polygon(288, 42, 43),
  polygon(250, 263, 292, 257),
  polygon(255, 294, 293, 34),
  polygon(24, 25, 294, 255),
  polygon(296, 41, 42, 295),
  polygon(258, 259, 292, 263),
  polygon(56, 55, 69, 264),
  polygon(43, 213, 214),
  polygon(48, 49, 291, 297),
  polygon(300, 45, 46, 245, 249),
  polygon(140, 120, 238, 143),
  polygon(301, 232, 87),
  polygon(287, 37, 26),
  polygon(83, 93, 98, 82),
  polygon(79, 90, 85, 86),
  polygon(98, 302, 92, 89),
  polygon(87, 293, 294, 25),
  polygon(255, 31, 53, 24),
  polygon(281, 45, 300, 297, 291),
  polygon(95, 81, 78, 74),
  polygon(185, 126, 135, 184),
  polygon(241, 269, 210),
  polygon(248, 286, 270, 247),
  polygon(267, 279, 306),
  polygon(17, 242, 164, 9),
  polygon(5, 194, 242, 17),
  polygon(26, 37, 44, 45, 282, 25),
  polygon(301, 87, 282),
  polygon(287, 308, 307, 288),
  polygon(283, 269, 309),
  polygon(311, 310, 295, 42, 268, 264),
  polygon(268, 42, 288),
  polygon(173, 174, 179),
  polygon(231, 63, 6),
  polygon(272, 310, 311, 312),
  polygon(314, 313, 233, 153, 173),
  polygon(164, 163, 160, 14),
  polygon(40, 41, 296, 318, 317, 227, 228),
  polygon(314, 173, 312),
  polygon(197, 39, 36),
  polygon(132, 133, 151, 137),
  polygon(74, 78, 97, 73),
  polygon(33, 34, 293),
  polygon(317, 318, 310, 279, 280),
  polygon(85, 88, 93, 83),
  polygon(97, 86, 84, 96),
  polygon(308, 257, 292, 307),
  polygon(35, 233, 19),
  polygon(259, 307, 292),
  polygon(33, 293, 87, 52, 32),
  polygon(184, 135, 132, 138),
  polygon(93, 94, 302, 98),
  polygon(156, 231, 269, 241),
  polygon(269, 231, 232, 301, 309),
  polygon(230, 289, 322, 217),
  polygon(70, 288, 307, 259),
  polygon(137, 151, 141, 142),
  polygon(264, 67, 311),
  polygon(286, 322, 289, 323, 270),
  polygon(291, 246, 247),
  polygon(262, 263, 250, 251),
  polygon(230, 260, 261),
  polygon(257, 308, 254),
  polygon(154, 152, 193, 182),
  polygon(313, 314, 312, 311),
  polygon(155, 181, 192, 158),
  polygon(115, 58, 59, 235),
  polygon(174, 154, 182, 179),
  polygon(287, 288, 322, 286),
  polygon(231, 6, 7, 232),
  polygon(6, 63, 194, 5),
  polygon(103, 195, 16),
  polygon(254, 308, 287, 253),
  polygon(116, 206, 207, 235),
  polygon(67, 233, 313),
  polygon(4, 68, 54, 10),
  polygon(99, 118, 119, 102),
  polygon(322, 288, 43, 217),
  polygon(36, 37, 287),
  polygon(199, 324, 177, 178),
  polygon(326, 222, 225, 325),
  polygon(302, 94, 91, 92),
  polygon(183, 163, 164, 242),
  polygon(327, 223, 222, 326),
  polygon(203, 325, 329, 207),
  polygon(152, 195, 204, 193),
  polygon(204, 326, 325, 203),
  polygon(284, 95, 74, 75),
  polygon(15, 16, 153),
  polygon(329, 229, 223, 327),
  polygon(76, 77, 95, 284),
  polygon(313, 311, 67),
  polygon(282, 283, 309, 301),
  polygon(207, 329, 327, 273),
  polygon(273, 327, 326, 204),
  polygon(261, 306, 279, 310, 272),
  polygon(334, 75, 72, 324),
  polygon(324, 72, 76, 177),
  polygon(175, 176, 334, 201),
  polygon(325, 225, 229, 329),
  polygon(201, 334, 324, 199),
  polygon(176, 284, 75, 334),
  polygon(71, 268, 288, 70),
  polygon(27, 253, 287, 26),
  polygon(10, 54, 87, 18),
  polygon(230, 211, 218, 260),
  polygon(211, 212, 221, 218),
  polygon(317, 220, 221, 227),
  polygon(220, 317, 280, 266),
  polygon(279, 267, 266),
  polygon(261, 219, 267, 306),
  polygon(310, 318, 296, 295),
  polygon(291, 49, 169, 246),
  polygon(49, 50, 172, 169),
  polygon(276, 171, 172, 244),
  polygon(300, 48, 297),
  polygon(300, 51, 48),
  polygon(300, 249, 51),
  polygon(37, 38, 47, 44),
  */
};

int num_polys = sizeof(polys) / sizeof(polygon);
