// Filename: bioPtr.I
// Created by:  drose (15Oct02)
//
////////////////////////////////////////////////////////////////////
//
// PANDA 3D SOFTWARE
// Copyright (c) 2001 - 2004, Disney Enterprises, Inc.  All rights reserved
//
// All use of this software is subject to the terms of the Panda 3d
// Software license.  You should have received a copy of this license
// along with this source code; you will also find a current copy of
// the license at http://etc.cmu.edu/panda3d/docs/license/ .
//
// To contact the maintainers of this program write to
// panda3d-general@lists.sourceforge.net .
//
////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////
//     Function: BioPtr::Constructor
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE BioPtr::
BioPtr(BIO *bio) : _bio(bio) {
}

////////////////////////////////////////////////////////////////////
//     Function: BioPtr::operator *
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE BIO &BioPtr::
operator *() const {
  return *_bio;
}

////////////////////////////////////////////////////////////////////
//     Function: BioPtr::operator ->
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE BIO *BioPtr::
operator ->() const {
  return _bio;
}

////////////////////////////////////////////////////////////////////
//     Function: BioPtr::operator typecast
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE BioPtr::
operator BIO * () const {
  return _bio;
}

////////////////////////////////////////////////////////////////////
//     Function: BioPtr::get_bio
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE void BioPtr::
set_bio(BIO *bio) {
  _bio = bio;
}

////////////////////////////////////////////////////////////////////
//     Function: BioPtr::get_bio
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE BIO *BioPtr::
get_bio() const {
  return _bio;
}

////////////////////////////////////////////////////////////////////
//     Function: BioPtr::get_server_name
//       Access: Public
//  Description: Returns the name of the server we are (or should be)
//               connected to.
////////////////////////////////////////////////////////////////////
INLINE const string &BioPtr::
get_server_name() const {
  return _server_name;
}

////////////////////////////////////////////////////////////////////
//     Function: BioPtr::get_port
//       Access: Public
//  Description: Returns the port on which we are (or should be)
//               connected.
////////////////////////////////////////////////////////////////////
INLINE int BioPtr::
get_port() const {
  return _port;
}
