// Filename: bioStream.I
// Created by:  drose (25Sep02)
//
////////////////////////////////////////////////////////////////////
//
// PANDA 3D SOFTWARE
// Copyright (c) 2001 - 2004, Disney Enterprises, Inc.  All rights reserved
//
// All use of this software is subject to the terms of the Panda 3d
// Software license.  You should have received a copy of this license
// along with this source code; you will also find a current copy of
// the license at http://etc.cmu.edu/panda3d/docs/license/ .
//
// To contact the maintainers of this program write to
// panda3d-general@lists.sourceforge.net .
//
////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////
//     Function: IBioStream::Constructor
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE IBioStream::
IBioStream() : ISocketStream(&_buf) {
}

////////////////////////////////////////////////////////////////////
//     Function: IBioStream::Constructor
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE IBioStream::
IBioStream(BioPtr *source) : ISocketStream(&_buf) {
  open(source);
}

////////////////////////////////////////////////////////////////////
//     Function: IBioStream::open
//       Access: Public
//  Description: 
////////////////////////////////////////////////////////////////////
INLINE IBioStream &IBioStream::
open(BioPtr *source) {
  clear((ios_iostate)0);
  _buf.open(source);
  return *this;
}

////////////////////////////////////////////////////////////////////
//     Function: OBioStream::Constructor
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE OBioStream::
OBioStream() : OSocketStream(&_buf) {
}

////////////////////////////////////////////////////////////////////
//     Function: OBioStream::Constructor
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE OBioStream::
OBioStream(BioPtr *source) : OSocketStream(&_buf) {
  open(source);
}

////////////////////////////////////////////////////////////////////
//     Function: OBioStream::open
//       Access: Public
//  Description: 
////////////////////////////////////////////////////////////////////
INLINE OBioStream &OBioStream::
open(BioPtr *source) {
  clear((ios_iostate)0);
  _buf.open(source);
  return *this;
}

////////////////////////////////////////////////////////////////////
//     Function: BioStream::Constructor
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE BioStream::
BioStream() : SocketStream(&_buf) {
}

////////////////////////////////////////////////////////////////////
//     Function: BioStream::Constructor
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE BioStream::
BioStream(BioPtr *source) : SocketStream(&_buf) {
  open(source);
}

////////////////////////////////////////////////////////////////////
//     Function: BioStream::open
//       Access: Public
//  Description: 
////////////////////////////////////////////////////////////////////
INLINE BioStream &BioStream::
open(BioPtr *source) {
  clear((ios_iostate)0);
  _buf.open(source);
  return *this;
}
