// Filename: bioStreamPtr.I
// Created by:  drose (15Oct02)
//
////////////////////////////////////////////////////////////////////
//
// PANDA 3D SOFTWARE
// Copyright (c) 2001 - 2004, Disney Enterprises, Inc.  All rights reserved
//
// All use of this software is subject to the terms of the Panda 3d
// Software license.  You should have received a copy of this license
// along with this source code; you will also find a current copy of
// the license at http://etc.cmu.edu/panda3d/docs/license/ .
//
// To contact the maintainers of this program write to
// panda3d-general@lists.sourceforge.net .
//
////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////
//     Function: BioStreamPtr::Constructor
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE BioStreamPtr::
BioStreamPtr(BioStream *stream) : _stream(stream) {
}

////////////////////////////////////////////////////////////////////
//     Function: BioStreamPtr::operator *
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE BioStream &BioStreamPtr::
operator *() const {
  return *_stream;
}

////////////////////////////////////////////////////////////////////
//     Function: BioStreamPtr::operator ->
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE BioStream *BioStreamPtr::
operator ->() const {
  return _stream;
}

////////////////////////////////////////////////////////////////////
//     Function: BioStreamPtr::operator typecast
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE BioStreamPtr::
operator BioStream * () const {
  return _stream;
}

////////////////////////////////////////////////////////////////////
//     Function: BioStreamPtr::get_stream
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE void BioStreamPtr::
set_stream(BioStream *stream) {
  _stream = stream;
}

////////////////////////////////////////////////////////////////////
//     Function: BioStreamPtr::get_stream
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE BioStream *BioStreamPtr::
get_stream() const {
  return _stream;
}
