// Filename: eggAnimData.I
// Created by:  drose (19Feb99)
//
////////////////////////////////////////////////////////////////////
//
// PANDA 3D SOFTWARE
// Copyright (c) 2001 - 2004, Disney Enterprises, Inc.  All rights reserved
//
// All use of this software is subject to the terms of the Panda 3d
// Software license.  You should have received a copy of this license
// along with this source code; you will also find a current copy of
// the license at http://etc.cmu.edu/panda3d/docs/license/ .
//
// To contact the maintainers of this program write to
// panda3d-general@lists.sourceforge.net .
//
////////////////////////////////////////////////////////////////////

#include "notify.h"

////////////////////////////////////////////////////////////////////
//     Function: EggAnimData::Constructor
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE EggAnimData::
EggAnimData(const string &name) : EggNode(name) {
  _has_fps = false;
}


////////////////////////////////////////////////////////////////////
//     Function: EggAnimData::Copy constructor
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE EggAnimData::
EggAnimData(const EggAnimData &copy) :
  EggNode(copy), _data(copy._data),
  _fps(copy._fps), _has_fps(copy._has_fps) {
}


////////////////////////////////////////////////////////////////////
//     Function: EggAnimData::Copy assignment operator
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE EggAnimData &EggAnimData::
operator = (const EggAnimData &copy) {
  EggNode::operator = (copy);
  _data = copy._data;
  _fps = copy._fps;
  _has_fps = copy._has_fps;

  return *this;
}


////////////////////////////////////////////////////////////////////
//     Function: EggAnimData::set_fps
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE void EggAnimData::
set_fps(double fps) {
  _fps = fps;
  _has_fps = true;
}


////////////////////////////////////////////////////////////////////
//     Function: EggAnimData::clear_fps
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE void EggAnimData::
clear_fps() {
  _has_fps = false;
}

////////////////////////////////////////////////////////////////////
//     Function: EggAnimData::has_fps
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE bool EggAnimData::
has_fps() const {
  return _has_fps;
}

////////////////////////////////////////////////////////////////////
//     Function: EggAnimData::get_fps
//       Access: Public
//  Description: This is only valid if has_fps() returns true.
////////////////////////////////////////////////////////////////////
INLINE double EggAnimData::
get_fps() const {
  nassertr(has_fps(), 0.0);
  return _fps;
}


////////////////////////////////////////////////////////////////////
//     Function: EggAnimData::clear_data
//       Access: Public
//  Description: Removes all data and empties the table.
////////////////////////////////////////////////////////////////////
INLINE void EggAnimData::
clear_data() {
  _data.clear();
}

////////////////////////////////////////////////////////////////////
//     Function: EggAnimData::add_data
//       Access: Public
//  Description: Adds a single element to the table.
////////////////////////////////////////////////////////////////////
INLINE void EggAnimData::
add_data(double value) {
  _data.push_back(value);
}



////////////////////////////////////////////////////////////////////
//     Function: EggAnimData::get_size
//       Access: Public
//  Description: Returns the number of elements in the table.
////////////////////////////////////////////////////////////////////
INLINE int EggAnimData::
get_size() const {
  return _data.size();
}


////////////////////////////////////////////////////////////////////
//     Function: EggAnimData::get_data
//       Access: Public
//  Description: Returns the entire table of data.
////////////////////////////////////////////////////////////////////
INLINE PTA_double EggAnimData::
get_data() const {
  return _data;
}


////////////////////////////////////////////////////////////////////
//     Function: EggAnimData::set_data
//       Access: Public
//  Description: Replaces the entire table of data.
////////////////////////////////////////////////////////////////////
INLINE void EggAnimData::
set_data(const PTA_double &data) {
  _data = data;
}

