// Filename: eggUserData.h
// Created by:  drose (03Jun03)
//
////////////////////////////////////////////////////////////////////
//
// PANDA 3D SOFTWARE
// Copyright (c) 2001 - 2004, Disney Enterprises, Inc.  All rights reserved
//
// All use of this software is subject to the terms of the Panda 3d
// Software license.  You should have received a copy of this license
// along with this source code; you will also find a current copy of
// the license at http://etc.cmu.edu/panda3d/docs/license/ .
//
// To contact the maintainers of this program write to
// panda3d-general@lists.sourceforge.net .
//
////////////////////////////////////////////////////////////////////

#ifndef EGGUSERDATA_H
#define EGGUSERDATA_H

#include "pandabase.h"

#include "typedReferenceCount.h"

////////////////////////////////////////////////////////////////////
//       Class : EggUserData
// Description : This is a base class for a user-defined data type to
//               extend egg structures in processing code.  The user
//               of the egg library may derive from EggUserData to
//               associate any arbitrary data with various egg
//               objects.
//
//               However, this data will not be written out to the
//               disk when the egg file is written; it is an in-memory
//               object only.
////////////////////////////////////////////////////////////////////
class EXPCL_PANDAEGG EggUserData : public TypedReferenceCount {
PUBLISHED:
  INLINE EggUserData();
  INLINE EggUserData(const EggUserData &copy);
  INLINE EggUserData &operator = (const EggUserData &copy);

  virtual ~EggUserData();

public:
  static TypeHandle get_class_type() {
    return _type_handle;
  }
  static void init_type() {
    TypedReferenceCount::init_type();
    register_type(_type_handle, "EggUserData",
                  TypedReferenceCount::get_class_type());
  }
  virtual TypeHandle get_type() const {
    return get_class_type();
  }
  virtual TypeHandle force_init_type() {init_type(); return get_class_type();}

private:
  static TypeHandle _type_handle;
};

#include "eggUserData.I"

#endif

