// Filename: cast_to_double.I
// Created by:  drose (24May00)
//
////////////////////////////////////////////////////////////////////
//
// PANDA 3D SOFTWARE
// Copyright (c) 2001 - 2004, Disney Enterprises, Inc.  All rights reserved
//
// All use of this software is subject to the terms of the Panda 3d
// Software license.  You should have received a copy of this license
// along with this source code; you will also find a current copy of
// the license at http://etc.cmu.edu/panda3d/docs/license/ .
//
// To contact the maintainers of this program write to
// panda3d-general@lists.sourceforge.net .
//
////////////////////////////////////////////////////////////////////

INLINE_LINMATH LVecBase2d cast_to_double(const LVecBase2f &source) {
  return LCAST(double, source);
}

INLINE_LINMATH LVecBase3d cast_to_double(const LVecBase3f &source) {
  return LCAST(double, source);
}

INLINE_LINMATH LVecBase4d cast_to_double(const LVecBase4f &source) {
  return LCAST(double, source);
}

INLINE_LINMATH LVector2d cast_to_double(const LVector2f &source) {
  return LCAST(double, source);
}

INLINE_LINMATH LVector3d cast_to_double(const LVector3f &source) {
  return LCAST(double, source);
}

INLINE_LINMATH LVector4d cast_to_double(const LVector4f &source) {
  return LCAST(double, source);
}

INLINE_LINMATH LPoint2d cast_to_double(const LPoint2f &source) {
  return LCAST(double, source);
}

INLINE_LINMATH LPoint3d cast_to_double(const LPoint3f &source) {
  return LCAST(double, source);
}

INLINE_LINMATH LPoint4d cast_to_double(const LPoint4f &source) {
  return LCAST(double, source);
}

INLINE_LINMATH LMatrix3d cast_to_double(const LMatrix3f &source) {
  return LCAST(double, source);
}

INLINE_LINMATH LMatrix4d cast_to_double(const LMatrix4f &source) {
  return LCAST(double, source);
}

