// Filename: discEmitter.I
// Created by:  charles (22Jun00)
//
////////////////////////////////////////////////////////////////////
//
// PANDA 3D SOFTWARE
// Copyright (c) 2001 - 2004, Disney Enterprises, Inc.  All rights reserved
//
// All use of this software is subject to the terms of the Panda 3d
// Software license.  You should have received a copy of this license
// along with this source code; you will also find a current copy of
// the license at http://etc.cmu.edu/panda3d/docs/license/ .
//
// To contact the maintainers of this program write to
// panda3d-general@lists.sourceforge.net .
//
////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////
//    Function : set_radius
//      Access : Public
// Description : radius assignment
////////////////////////////////////////////////////////////////////

INLINE void DiscEmitter::
set_radius(float r) {
  _radius = r;
}

////////////////////////////////////////////////////////////////////
//    Function : set_outer_angle
//      Access : Public
// Description : aoe assignement
////////////////////////////////////////////////////////////////////

INLINE void DiscEmitter::
set_outer_angle(float o_angle) {
  _outer_aoe = o_angle;
}

////////////////////////////////////////////////////////////////////
//    Function : set_inner_angle
//      Access : Public
// Description : aoe assignment
////////////////////////////////////////////////////////////////////

INLINE void DiscEmitter::
set_inner_angle(float i_angle) {
  _inner_aoe = i_angle;
}

////////////////////////////////////////////////////////////////////
//    Function : set_outer_magnitude
//      Access : public
// Description : mag assignment
////////////////////////////////////////////////////////////////////

INLINE void DiscEmitter::
set_outer_magnitude(float o_mag) {
  _outer_magnitude = o_mag;
}

////////////////////////////////////////////////////////////////////
//    Function : set_inner_magnitude
//      Access : public
// Description : mag assignment
////////////////////////////////////////////////////////////////////

INLINE void DiscEmitter::
set_inner_magnitude(float i_mag) {
  _inner_magnitude = i_mag;
}

////////////////////////////////////////////////////////////////////
//    Function : set_cubic_lerping
//      Access : public
// Description : clerp flag
////////////////////////////////////////////////////////////////////

INLINE void DiscEmitter::
set_cubic_lerping(bool clerp) {
  _cubic_lerping = clerp;
}

////////////////////////////////////////////////////////////////////
//    Function : get_radius
//      Access : Public
// Description : radius accessor
////////////////////////////////////////////////////////////////////

INLINE float DiscEmitter::
get_radius(void) const {
  return _radius;
}

////////////////////////////////////////////////////////////////////
//    Function : get_outer_angle
//      Access : Public
// Description : aoe accessor
////////////////////////////////////////////////////////////////////

INLINE float DiscEmitter::
get_outer_angle(void) const {
  return _outer_aoe;
}

////////////////////////////////////////////////////////////////////
//    Function : get_inner_angle
//      Access : Public
// Description : aoe accessor
////////////////////////////////////////////////////////////////////

INLINE float DiscEmitter::
get_inner_angle(void) const {
  return _inner_aoe;
}

////////////////////////////////////////////////////////////////////
//    Function : get_outer_magnitude
//      Access : public
// Description : mag accessor
////////////////////////////////////////////////////////////////////

INLINE float DiscEmitter::
get_outer_magnitude(void) const {
  return _outer_magnitude;
}

////////////////////////////////////////////////////////////////////
//    Function : get_inner_magnitude
//      Access : public
// Description : mag accessor
////////////////////////////////////////////////////////////////////

INLINE float DiscEmitter::
get_inner_magnitude(void) const {
  return _inner_magnitude;
}

////////////////////////////////////////////////////////////////////
//    Function : get_cubic_lerping
//      Access : public
// Description : clerp flag accessor
////////////////////////////////////////////////////////////////////

INLINE bool DiscEmitter::
get_cubic_lerping(void) const {
  return _cubic_lerping;
}
