// Filename: particleSystem.I
// Created by:  charles (14Jun00)
//
////////////////////////////////////////////////////////////////////
//
// PANDA 3D SOFTWARE
// Copyright (c) 2001 - 2004, Disney Enterprises, Inc.  All rights reserved
//
// All use of this software is subject to the terms of the Panda 3d
// Software license.  You should have received a copy of this license
// along with this source code; you will also find a current copy of
// the license at http://etc.cmu.edu/panda3d/docs/license/ .
//
// To contact the maintainers of this program write to
// panda3d-general@lists.sourceforge.net .
//
////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////
//    Function : render
//      Access : Public
// Description : Populates an attached GeomNode structure with the
//               particle geometry for rendering.  This is a
//               wrapper for accessability.
////////////////////////////////////////////////////////////////////

INLINE void ParticleSystem::
render() {
  _renderer->render(_physics_objects, _living_particles);
}

////////////////////////////////////////////////////////////////////
//    Function : induce_labor
//      Access : Public
// Description : Forces the birth of a particle litter this frame
//               by resetting _tics_since_birth
////////////////////////////////////////////////////////////////////

INLINE void ParticleSystem::
induce_labor() {
  _tics_since_birth = _birth_rate;
}

////             ///////////////////////////////////////////////////////
//// SET METHODS ///////////////////////////////////////////////////////
////             ///////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////
//    Function : set_pool_size
//      Access : Public
////////////////////////////////////////////////////////////////////

INLINE void ParticleSystem::
set_pool_size(int size) {
  resize_pool(size);
}

////////////////////////////////////////////////////////////////////
//    Function : set_birth_rate
//      Access : Public
////////////////////////////////////////////////////////////////////

INLINE void ParticleSystem::
set_birth_rate(float new_br) {
  _birth_rate = new_br;
  if(IS_NEARLY_ZERO(_birth_rate)) _birth_rate = NEARLY_ZERO(float);
}

////////////////////////////////////////////////////////////////////
//    Function : set_litter_size
//      Access : Public
////////////////////////////////////////////////////////////////////

INLINE void ParticleSystem::
set_litter_size(int new_ls) {
  _litter_size = new_ls;
}

////////////////////////////////////////////////////////////////////
//    Function : set_litter_spread
//      Access : Public
////////////////////////////////////////////////////////////////////
INLINE void ParticleSystem::
set_litter_spread(int new_ls) {
  _litter_spread = new_ls;
}

////////////////////////////////////////////////////////////////////
//    Function : set_renderer
//      Access : Public
////////////////////////////////////////////////////////////////////
INLINE void ParticleSystem::
set_renderer(BaseParticleRenderer *r) {
  _renderer = r;
  _renderer->resize_pool(_particle_pool_size);

  if (!_render_node.is_null())
    _render_parent->remove_child(_render_node);

  _render_node = _renderer->get_render_node();
  _render_parent->add_child(_render_node);
}

////////////////////////////////////////////////////////////////////
//    Function : set_emitter
//      Access : Public
////////////////////////////////////////////////////////////////////
INLINE void ParticleSystem::
set_emitter(BaseParticleEmitter *e) {
  _emitter = e;
}

////////////////////////////////////////////////////////////////////
//    Function : set_factory
//      Access : Public
////////////////////////////////////////////////////////////////////
INLINE void ParticleSystem::
set_factory(BaseParticleFactory *f) {
  int pool_size = _particle_pool_size;
  set_pool_size(0);
  _factory = f;
  clear_physics_objects();
  set_pool_size(pool_size);
}

////////////////////////////////////////////////////////////////////
//    Function : set_floor_z
//      Access : Public
////////////////////////////////////////////////////////////////////
INLINE void ParticleSystem::
set_floor_z(float z) {
  _floor_z = z;
}

////////////////////////////////////////////////////////////////////
//    Function : set_active_state
//      Access : public
////////////////////////////////////////////////////////////////////
INLINE void ParticleSystem::
set_active_system_flag(bool a) {
  _active_system_flag = a;
}

////////////////////////////////////////////////////////////////////
//    Function : set_local_velocity_flag
//      Access : public
////////////////////////////////////////////////////////////////////
INLINE void ParticleSystem::
set_local_velocity_flag(bool lv) {
  _local_velocity_flag = lv;
}

////////////////////////////////////////////////////////////////////
//    Function : set_spawn_on_death_flag
//      Access : public
////////////////////////////////////////////////////////////////////
INLINE void ParticleSystem::
set_spawn_on_death_flag(bool sod) {
  _spawn_on_death_flag = sod;
}

////////////////////////////////////////////////////////////////////
//    Function : set_system_grows_older_flag
//      Access : public
////////////////////////////////////////////////////////////////////
INLINE void ParticleSystem::
set_system_grows_older_flag(bool sgo) {
  _system_grows_older_flag = sgo;
}

////////////////////////////////////////////////////////////////////
//    Function : set_system_lifespan
//      Access : public
////////////////////////////////////////////////////////////////////

INLINE void ParticleSystem::
set_system_lifespan(float sl) {
  _system_lifespan = sl;
}

////////////////////////////////////////////////////////////////////
//    Function : set_system_age
//      Access : public
////////////////////////////////////////////////////////////////////

INLINE void ParticleSystem::
set_system_age(float age) {
  _system_age = age;
}

////////////////////////////////////////////////////////////////////
//    Function : set_spawn_render_node
//      Access : public
////////////////////////////////////////////////////////////////////

INLINE void ParticleSystem::
set_spawn_render_node(PandaNode *node) {
  _spawn_render_node = node;
}

////////////////////////////////////////////////////////////////////
//    Function : set_render_parent
//      Access : public
////////////////////////////////////////////////////////////////////

INLINE void ParticleSystem::
set_render_parent(PandaNode *node) {
  if (!_render_node.is_null())
    _render_parent->remove_child(_render_node);

  _render_parent = node;
  _render_node = _renderer->get_render_node();
  _render_parent->add_child(_render_node);
}

////////////////////////////////////////////////////////////////////
//    Function : set_template_system_flag
//      Access : public
////////////////////////////////////////////////////////////////////

INLINE void ParticleSystem::
set_template_system_flag(bool tsf) {
  _template_system_flag = tsf;
}

////////////////////////////////////////////////////////////////////
//    Function : add_spawn_template
//      Access : public
////////////////////////////////////////////////////////////////////
INLINE void ParticleSystem::
add_spawn_template(ParticleSystem *ps) {
  _spawn_templates.push_back(ps);
}

////////////////////////////////////////////////////////////////////
//    Function : clear_spawn_templates
//      Access : public
////////////////////////////////////////////////////////////////////
INLINE void ParticleSystem::
clear_spawn_templates() {
  _spawn_templates.erase(_spawn_templates.begin(),
                         _spawn_templates.end());
}

////////////////////////////////////////////////////////////////////
//    Function : clear_floor_z
//      Access : Public
////////////////////////////////////////////////////////////////////
INLINE void ParticleSystem::
clear_floor_z() {
  _floor_z = -HUGE_VAL;
}

////             /////////////////////////////////////////////////////
//// GET METHODS /////////////////////////////////////////////////////
////             /////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////
//    Function : get_pool_size
//      Access : Public
////////////////////////////////////////////////////////////////////
INLINE int ParticleSystem::
get_pool_size() const {
  return _particle_pool_size;
}

////////////////////////////////////////////////////////////////////
//    Function : get_birth_rate
//      Access : Public
////////////////////////////////////////////////////////////////////
INLINE float ParticleSystem::
get_birth_rate() const {
  return _birth_rate;
}

////////////////////////////////////////////////////////////////////
//    Function : get_litter_size
//      Access : Public
////////////////////////////////////////////////////////////////////
INLINE int ParticleSystem::
get_litter_size() const {
  return _litter_size;
}

////////////////////////////////////////////////////////////////////
//    Function : get_litter_spread
//      Access : Public
////////////////////////////////////////////////////////////////////
INLINE int ParticleSystem::
get_litter_spread() const {
  return _litter_spread;
}

////////////////////////////////////////////////////////////////////
//    Function : get_renderer
//      Access : Public
////////////////////////////////////////////////////////////////////
INLINE BaseParticleRenderer *ParticleSystem::
get_renderer() const {
  return _renderer;
}

////////////////////////////////////////////////////////////////////
//    Function : get_emitter
//      Access : Public
////////////////////////////////////////////////////////////////////
INLINE BaseParticleEmitter *ParticleSystem::
get_emitter() const {
  return _emitter;
}

////////////////////////////////////////////////////////////////////
//    Function : get_factory
//      Access : Public
////////////////////////////////////////////////////////////////////
INLINE BaseParticleFactory *ParticleSystem::
get_factory() const {
  return _factory;
}

////////////////////////////////////////////////////////////////////
//    Function : get_factory
//      Access : Public
////////////////////////////////////////////////////////////////////
INLINE float ParticleSystem::
get_floor_z() const {
  return _floor_z;
}

////////////////////////////////////////////////////////////////////
//    Function : get_living_particles
//      Access : Public
////////////////////////////////////////////////////////////////////
INLINE int ParticleSystem::
get_living_particles() const {
  return _living_particles;
}

////////////////////////////////////////////////////////////////////
//    Function : get_active_state
//      Access : public
////////////////////////////////////////////////////////////////////
INLINE bool ParticleSystem::
get_active_system_flag() const {
  return _active_system_flag;
}

////////////////////////////////////////////////////////////////////
//    Function : get_local_velocity_flag
//      Access : public
////////////////////////////////////////////////////////////////////
INLINE bool ParticleSystem::
get_local_velocity_flag() const {
  return _local_velocity_flag;
}

////////////////////////////////////////////////////////////////////
//    Function : get_spawn_on_death_flag
//      Access : public
////////////////////////////////////////////////////////////////////
INLINE bool ParticleSystem::
get_spawn_on_death_flag() const {
  return _spawn_on_death_flag;
}

////////////////////////////////////////////////////////////////////
//    Function : get_system_grows_older_flag
//      Access : public
////////////////////////////////////////////////////////////////////
INLINE bool ParticleSystem::
get_system_grows_older_flag() const {
  return _system_grows_older_flag;
}

////////////////////////////////////////////////////////////////////
//    Function : get_system_lifespan
//      Access : public
////////////////////////////////////////////////////////////////////
INLINE float ParticleSystem::
get_system_lifespan() const {
  return _system_lifespan;
}

////////////////////////////////////////////////////////////////////
//    Function : get_system_age
//      Access : public
////////////////////////////////////////////////////////////////////
INLINE float ParticleSystem::
get_system_age() const {
  return _system_age;
}

////////////////////////////////////////////////////////////////////
//    Function : get_i_was_spawned_flag
//      Access : public
////////////////////////////////////////////////////////////////////
INLINE bool ParticleSystem::
get_i_was_spawned_flag() const {
  return _i_was_spawned_flag;
}

////////////////////////////////////////////////////////////////////
//    Function : get_spawn_render_node
//      Access : public
////////////////////////////////////////////////////////////////////
INLINE PandaNode *ParticleSystem::
get_spawn_render_node() const {
  return _spawn_render_node;
}

////////////////////////////////////////////////////////////////////
//    Function : get_render_parent
//      Access : public
////////////////////////////////////////////////////////////////////
INLINE PandaNode *ParticleSystem::
get_render_parent() const {
  return _render_parent;
}
