// Filename: pointParticle.cxx
// Created by:  charles (19Jun00)
//
////////////////////////////////////////////////////////////////////
//
// PANDA 3D SOFTWARE
// Copyright (c) 2001 - 2004, Disney Enterprises, Inc.  All rights reserved
//
// All use of this software is subject to the terms of the Panda 3d
// Software license.  You should have received a copy of this license
// along with this source code; you will also find a current copy of
// the license at http://etc.cmu.edu/panda3d/docs/license/ .
//
// To contact the maintainers of this program write to
// panda3d-general@lists.sourceforge.net .
//
////////////////////////////////////////////////////////////////////

#include "pointParticle.h"

////////////////////////////////////////////////////////////////////
//    Function : PointParticle
//      Access : Public
// Description : simple constructor
////////////////////////////////////////////////////////////////////
PointParticle::
PointParticle(int lifespan, bool alive) :
  BaseParticle(lifespan, alive) {
  set_oriented(false);
}

////////////////////////////////////////////////////////////////////
//    Function : PointParticle
//      Access : Public
// Description : copy constructor
////////////////////////////////////////////////////////////////////
PointParticle::
PointParticle(const PointParticle &copy) :
  BaseParticle(copy) {
  set_oriented(false);
}

////////////////////////////////////////////////////////////////////
//    Function : ~PointParticle
//      Access : Public
// Description : simple destructor
////////////////////////////////////////////////////////////////////
PointParticle::
~PointParticle() {
}

////////////////////////////////////////////////////////////////////
//    Function : make_copy
//      Access : Public
// Description : dynamic copier
////////////////////////////////////////////////////////////////////
PhysicsObject *PointParticle::
make_copy() const {
  return new PointParticle(*this);
}

////////////////////////////////////////////////////////////////////
//    Function : die
//      Access : Public
// Description : particle death routine
////////////////////////////////////////////////////////////////////
void PointParticle::
die() {
}

////////////////////////////////////////////////////////////////////
//    Function : init
//      Access : Public
// Description : particle init routine
////////////////////////////////////////////////////////////////////
void PointParticle::
init() {
}

////////////////////////////////////////////////////////////////////
//    Function : update
//      Access : Public
// Description : particle update
////////////////////////////////////////////////////////////////////
void PointParticle::
update() {
}

////////////////////////////////////////////////////////////////////
//     Function : output
//       Access : Public
//  Description : Write a string representation of this instance to
//                <out>.
////////////////////////////////////////////////////////////////////
void PointParticle::
output(ostream &out) const {
  #ifndef NDEBUG //[
  out<<"PointParticle";
  #endif //] NDEBUG
}

////////////////////////////////////////////////////////////////////
//     Function : write
//       Access : Public
//  Description : Write a string representation of this instance to
//                <out>.
////////////////////////////////////////////////////////////////////
void PointParticle::
write(ostream &out, int indent) const {
  #ifndef NDEBUG //[
  out.width(indent); out<<""; out<<"PointParticle:\n";
  BaseParticle::write(out, indent+2);
  #endif //] NDEBUG
}
