// Filename: spriteParticleRenderer.I
// Created by:  charles (13Jul00)
//
////////////////////////////////////////////////////////////////////
//
// PANDA 3D SOFTWARE
// Copyright (c) 2001 - 2004, Disney Enterprises, Inc.  All rights reserved
//
// All use of this software is subject to the terms of the Panda 3d
// Software license.  You should have received a copy of this license
// along with this source code; you will also find a current copy of
// the license at http://etc.cmu.edu/panda3d/docs/license/ .
//
// To contact the maintainers of this program write to
// panda3d-general@lists.sourceforge.net .
//
////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////
//    Function : SpriteParticleRenderer::get_source_type
//      Access : public
// Description : Returns an indication of whether the texture for this
//               renderer was set via a call to set_texture(), or via
//               set_from_node().
////////////////////////////////////////////////////////////////////
INLINE SpriteParticleRenderer::SourceType SpriteParticleRenderer::
get_source_type() const {
  return _source_type;
}

////////////////////////////////////////////////////////////////////
// Function : SpriteParticleRenderer::set_texture
//   Access : public
////////////////////////////////////////////////////////////////////
INLINE void SpriteParticleRenderer::
set_texture(Texture *tex) {
  _sprite_primitive->set_texture(tex);
  _sprite_primitive->set_ll_uv(TexCoordf(0.0f, 0.0f));
  _sprite_primitive->set_ur_uv(TexCoordf(1.0f, 1.0f));
  _source_type = ST_texture;
}

////////////////////////////////////////////////////////////////////
//    Function : SpriteParticleRenderer::set_ll_uv
//      Access : public
// Description : Sets the UV coordinate of the lower-left corner of
//               all the sprites generated by this renderer.  Normally
//               this is (0, 0), but it might be set to something else
//               to use only a portion of the texture.
////////////////////////////////////////////////////////////////////
INLINE void SpriteParticleRenderer::
set_ll_uv(const TexCoordf &ll_uv) {
  _sprite_primitive->set_ll_uv(ll_uv);
}

////////////////////////////////////////////////////////////////////
//    Function : SpriteParticleRenderer::set_ur_uv
//      Access : public
// Description : Sets the UV coordinate of the upper-right corner of
//               all the sprites generated by this renderer.  Normally
//               this is (1, 1), but it might be set to something else
//               to use only a portion of the texture.
////////////////////////////////////////////////////////////////////
INLINE void SpriteParticleRenderer::
set_ur_uv(const TexCoordf &ur_uv) {
  _sprite_primitive->set_ur_uv(ur_uv);
}

////////////////////////////////////////////////////////////////////
// Function : SpriteParticleRenderer::set_color
//   Access : public
////////////////////////////////////////////////////////////////////
INLINE void SpriteParticleRenderer::
set_color(const Colorf &color) {
  _color = color;
}

////////////////////////////////////////////////////////////////////
// Function : SpriteParticleRenderer::set_x_scale_flag
//   Access : public
////////////////////////////////////////////////////////////////////
INLINE void SpriteParticleRenderer::
set_x_scale_flag(bool animate_x_ratio) {
  if (animate_x_ratio == true && _animate_x_ratio == false) {
    _x_texel_array = PTA_float::empty_array(_pool_size);
    _sprite_primitive->set_x_texel_ratio(_x_texel_array, G_PER_PRIM);
  }
  else if (animate_x_ratio == false && _animate_x_ratio == true) {
    _x_texel_array = PTA_float::empty_array(1);
    _sprite_primitive->set_x_texel_ratio(_x_texel_array, G_OVERALL);
  }

  _animate_x_ratio = animate_x_ratio;
}

////////////////////////////////////////////////////////////////////
// Function : SpriteParticleRenderer::set_y_scale_flag
//   Access : public
////////////////////////////////////////////////////////////////////
INLINE void SpriteParticleRenderer::
set_y_scale_flag(bool animate_y_ratio) {
  if (animate_y_ratio == true && _animate_y_ratio == false) {
    _y_texel_array = PTA_float::empty_array(_pool_size);
    _sprite_primitive->set_y_texel_ratio(_y_texel_array, G_PER_PRIM);
  }
  else if (animate_y_ratio == false && _animate_y_ratio == true) {
    _y_texel_array = PTA_float::empty_array(1);
    _sprite_primitive->set_y_texel_ratio(_y_texel_array, G_OVERALL);
  }

  _animate_y_ratio = animate_y_ratio;
}

////////////////////////////////////////////////////////////////////
// Function : SpriteParticleRenderer::set_anim_angle_flag
//   Access : public
////////////////////////////////////////////////////////////////////
INLINE void SpriteParticleRenderer::
set_anim_angle_flag(bool animate_theta) {
  if (animate_theta == true && _animate_theta == false) {
    _theta_array = PTA_float::empty_array(_pool_size);
    _sprite_primitive->set_thetas(_theta_array, G_PER_PRIM);
  }
  else if (animate_theta == false && _animate_theta == true) {
    _theta_array = PTA_float::empty_array(_pool_size);
    _sprite_primitive->set_thetas(_theta_array, G_OVERALL);
  }

  _animate_theta = animate_theta;
}

////////////////////////////////////////////////////////////////////
// Function : SpriteParticleRenderer::set_initial_x_scale
//   Access : public
////////////////////////////////////////////////////////////////////
INLINE void SpriteParticleRenderer::
set_initial_x_scale(float initial_x_scale) {
  _initial_x_texel_ratio = initial_x_scale;
}

////////////////////////////////////////////////////////////////////
// Function : SpriteParticleRenderer::set_final_x_scale
//   Access : public
////////////////////////////////////////////////////////////////////
INLINE void SpriteParticleRenderer::
set_final_x_scale(float final_x_scale) {
  _final_x_texel_ratio = final_x_scale;
}

////////////////////////////////////////////////////////////////////
// Function : SpriteParticleRenderer::set_initial_y_scale
//   Access : public
////////////////////////////////////////////////////////////////////
INLINE void SpriteParticleRenderer::
set_initial_y_scale(float initial_y_scale) {
  _initial_y_texel_ratio = initial_y_scale;
}

////////////////////////////////////////////////////////////////////
// Function : SpriteParticleRenderer::set_final_y_scale
//   Access : public
////////////////////////////////////////////////////////////////////
INLINE void SpriteParticleRenderer::
set_final_y_scale(float final_y_scale) {
  _final_y_texel_ratio = final_y_scale;
}

////////////////////////////////////////////////////////////////////
// Function : SpriteParticleRenderer::set_nonanimated_theta
//   Access : public
////////////////////////////////////////////////////////////////////
INLINE void SpriteParticleRenderer::
set_nonanimated_theta(float theta) {
  _theta = theta;
}

////////////////////////////////////////////////////////////////////
// Function : SpriteParticleRenderer::set_alpha_blend_method
//   Access : public
////////////////////////////////////////////////////////////////////
INLINE void SpriteParticleRenderer::
set_alpha_blend_method(ParticleRendererBlendMethod bm) {
  _blend_method = bm;
}

////////////////////////////////////////////////////////////////////
// Function : SpriteParticleRenderer::set_alpha_disable
//   Access : public
////////////////////////////////////////////////////////////////////
INLINE void SpriteParticleRenderer::
set_alpha_disable(bool ad) {
  _sprite_primitive->set_alpha_disable(ad);
}

////////////////////////////////////////////////////////////////////
// Function : SpriteParticleRenderer::get_texture
//   Access : public
////////////////////////////////////////////////////////////////////
INLINE Texture *SpriteParticleRenderer::
get_texture() const {
  return _sprite_primitive->get_texture();
}

////////////////////////////////////////////////////////////////////
//    Function : SpriteParticleRenderer::get_ll_uv
//      Access : public
// Description : Returns the UV coordinate of the lower-left corner;
//               see set_ll_uv().
////////////////////////////////////////////////////////////////////
INLINE const TexCoordf &SpriteParticleRenderer::
get_ll_uv() const {
  return _sprite_primitive->get_ll_uv();
}

////////////////////////////////////////////////////////////////////
//    Function : SpriteParticleRenderer::get_ur_uv
//      Access : public
// Description : Returns the UV coordinate of the upper-right corner;
//               see set_ur_uv().
////////////////////////////////////////////////////////////////////
INLINE const TexCoordf &SpriteParticleRenderer::
get_ur_uv() const {
  return _sprite_primitive->get_ur_uv();
}

////////////////////////////////////////////////////////////////////
// Function : SpriteParticleRenderer::get_color
//   Access : public
////////////////////////////////////////////////////////////////////
INLINE Colorf SpriteParticleRenderer::
get_color() const {
  return _color;
}

////////////////////////////////////////////////////////////////////
// Function : SpriteParticleRenderer::get_x_scale_flag
//   Access : public
////////////////////////////////////////////////////////////////////
INLINE bool SpriteParticleRenderer::
get_x_scale_flag() const {
  return _animate_x_ratio;
}

////////////////////////////////////////////////////////////////////
// Function : SpriteParticleRenderer::get_y_scale_flag
//   Access : public
////////////////////////////////////////////////////////////////////
INLINE bool SpriteParticleRenderer::
get_y_scale_flag() const {
  return _animate_y_ratio;
}

////////////////////////////////////////////////////////////////////
// Function : SpriteParticleRenderer::get_anim_angle_flag
//   Access : public
////////////////////////////////////////////////////////////////////
INLINE bool SpriteParticleRenderer::
get_anim_angle_flag() const {
  return _animate_theta;
}

////////////////////////////////////////////////////////////////////
// Function : SpriteParticleRenderer::get_initial_x_scale
//   Access : public
////////////////////////////////////////////////////////////////////
INLINE float SpriteParticleRenderer::
get_initial_x_scale() const {
  return _initial_x_texel_ratio;
}

////////////////////////////////////////////////////////////////////
// Function : SpriteParticleRenderer::get_final_x_scale
//   Access : public
////////////////////////////////////////////////////////////////////
INLINE float SpriteParticleRenderer::
get_final_x_scale() const {
  return _final_x_texel_ratio;
}

////////////////////////////////////////////////////////////////////
// Function : SpriteParticleRenderer::get_initial_y_scale
//   Access : public
////////////////////////////////////////////////////////////////////
INLINE float SpriteParticleRenderer::
get_initial_y_scale() const {
  return _initial_y_texel_ratio;
}

////////////////////////////////////////////////////////////////////
// Function : SpriteParticleRenderer::get_final_y_scale
//   Access : public
////////////////////////////////////////////////////////////////////
INLINE float SpriteParticleRenderer::
get_final_y_scale() const {
  return _final_y_texel_ratio;
}

////////////////////////////////////////////////////////////////////
// Function : SpriteParticleRenderer::get_nonanimated_theta
//   Access : public
////////////////////////////////////////////////////////////////////
INLINE float SpriteParticleRenderer::
get_nonanimated_theta() const {
  return _theta;
}

////////////////////////////////////////////////////////////////////
// Function : SpriteParticleRenderer::get_alpha_blend_method
//   Access : public
////////////////////////////////////////////////////////////////////
INLINE BaseParticleRenderer::ParticleRendererBlendMethod SpriteParticleRenderer::
get_alpha_blend_method() const {
  return _blend_method;
}

////////////////////////////////////////////////////////////////////
// Function : SpriteParticleRenderer::get_alpha_disable
//   Access : public
////////////////////////////////////////////////////////////////////
INLINE bool SpriteParticleRenderer::
get_alpha_disable() const {
  return _sprite_primitive->get_alpha_disable();
}
