// Filename: directionalLight.I
// Created by:  mike (04Feb99)
//
////////////////////////////////////////////////////////////////////
//
// PANDA 3D SOFTWARE
// Copyright (c) 2001 - 2004, Disney Enterprises, Inc.  All rights reserved
//
// All use of this software is subject to the terms of the Panda 3d
// Software license.  You should have received a copy of this license
// along with this source code; you will also find a current copy of
// the license at http://etc.cmu.edu/panda3d/docs/license/ .
//
// To contact the maintainers of this program write to
// panda3d-general@lists.sourceforge.net .
//
////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////
//     Function: DirectionalLight::CData::Constructor
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE DirectionalLight::CData::
CData() :
  _specular_color(1.0f, 1.0f, 1.0f, 1.0f),
  _point(0.0f, 0.0f, 0.0f),
  _direction(LVector3f::forward())
{
}

////////////////////////////////////////////////////////////////////
//     Function: DirectionalLight::CData::Copy Constructor
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE DirectionalLight::CData::
CData(const DirectionalLight::CData &copy) :
  _specular_color(copy._specular_color),
  _point(copy._point),
  _direction(copy._direction)
{
}

////////////////////////////////////////////////////////////////////
//     Function: DirectionalLight::get_specular_color
//       Access: Public
//  Description: Returns the color of specular highlights generated by
//               the light.
////////////////////////////////////////////////////////////////////
INLINE const Colorf &DirectionalLight::
get_specular_color() const {
  CDReader cdata(_cycler);
  return cdata->_specular_color;
}

////////////////////////////////////////////////////////////////////
//     Function: DirectionalLight::set_specular_color
//       Access: Public
//  Description: Sets the color of specular highlights generated by
//               the light.
////////////////////////////////////////////////////////////////////
INLINE void DirectionalLight::
set_specular_color(const Colorf &color) {
  CDWriter cdata(_cycler);
  cdata->_specular_color = color;
}

////////////////////////////////////////////////////////////////////
//     Function: DirectionalLight::get_point
//       Access: Public
//  Description: Returns the point in space at which the light is
//               located.  This is local to the coordinate space in
//               which the light is assigned.
//
//               This actually has no bearing on the visual effect of
//               the light, since the light is rendered as if it were
//               infinitely far away.  This is only used to create a
//               visible representation of the light.
////////////////////////////////////////////////////////////////////
INLINE const LPoint3f &DirectionalLight::
get_point() const {
  CDReader cdata(_cycler);
  return cdata->_point;
}

////////////////////////////////////////////////////////////////////
//     Function: DirectionalLight::set_point
//       Access: Public
//  Description: Sets the point in space at which the light is located.
////////////////////////////////////////////////////////////////////
INLINE void DirectionalLight::
set_point(const LPoint3f &point) {
  CDWriter cdata(_cycler);
  cdata->_point = point;
  mark_viz_stale();
}

////////////////////////////////////////////////////////////////////
//     Function: DirectionalLight::get_direction
//       Access: Public
//  Description: Returns the direction in which the light is aimed.
//               This is local to the coordinate space in which the
//               light is assigned.
////////////////////////////////////////////////////////////////////
INLINE const LVector3f &DirectionalLight::
get_direction() const {
  CDReader cdata(_cycler);
  return cdata->_direction;
}

////////////////////////////////////////////////////////////////////
//     Function: DirectionalLight::set_direction
//       Access: Public
//  Description: Sets the direction in which the light is aimed.
////////////////////////////////////////////////////////////////////
INLINE void DirectionalLight::
set_direction(const LVector3f &direction) {
  CDWriter cdata(_cycler);
  cdata->_direction = direction;
  mark_viz_stale();
}
