// Filename: pointLight.I
// Created by:  mike (04Feb99)
//
////////////////////////////////////////////////////////////////////
//
// PANDA 3D SOFTWARE
// Copyright (c) 2001 - 2004, Disney Enterprises, Inc.  All rights reserved
//
// All use of this software is subject to the terms of the Panda 3d
// Software license.  You should have received a copy of this license
// along with this source code; you will also find a current copy of
// the license at http://etc.cmu.edu/panda3d/docs/license/ .
//
// To contact the maintainers of this program write to
// panda3d-general@lists.sourceforge.net .
//
////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////
//     Function: PointLight::CData::Constructor
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE PointLight::CData::
CData() :
  _specular_color(1.0f, 1.0f, 1.0f, 1.0f),
  _attenuation(1.0f, 0.0f, 0.0f),
  _point(0.0f, 0.0f, 0.0f)
{
}

////////////////////////////////////////////////////////////////////
//     Function: PointLight::CData::Copy Constructor
//       Access: Public
//  Description:
////////////////////////////////////////////////////////////////////
INLINE PointLight::CData::
CData(const PointLight::CData &copy) :
  _specular_color(copy._specular_color),
  _attenuation(copy._attenuation),
  _point(copy._point)
{
}

////////////////////////////////////////////////////////////////////
//     Function: PointLight::get_specular_color
//       Access: Public
//  Description: Returns the color of specular highlights generated by
//               the light.
////////////////////////////////////////////////////////////////////
INLINE const Colorf &PointLight::
get_specular_color() const {
  CDReader cdata(_cycler);
  return cdata->_specular_color;
}

////////////////////////////////////////////////////////////////////
//     Function: PointLight::set_specular_color
//       Access: Public
//  Description: Sets the color of specular highlights generated by
//               the light.
////////////////////////////////////////////////////////////////////
INLINE void PointLight::
set_specular_color(const Colorf &color) {
  CDWriter cdata(_cycler);
  cdata->_specular_color = color;
}

////////////////////////////////////////////////////////////////////
//     Function: PointLight::get_attenuation
//       Access: Public
//  Description: Returns the terms of the attenuation equation for the
//               light.  These are, in order, the constant, linear,
//               and quadratic terms based on the distance from the
//               point to the vertex.
////////////////////////////////////////////////////////////////////
INLINE const LVecBase3f &PointLight::
get_attenuation() const {
  CDReader cdata(_cycler);
  return cdata->_attenuation;
}

////////////////////////////////////////////////////////////////////
//     Function: PointLight::set_attenuation
//       Access: Public
//  Description: Sets the terms of the attenuation equation for the
//               light.  These are, in order, the constant, linear,
//               and quadratic terms based on the distance from the
//               point to the vertex.
////////////////////////////////////////////////////////////////////
INLINE void PointLight::
set_attenuation(const LVecBase3f &attenuation) {
  CDWriter cdata(_cycler);
  cdata->_attenuation = attenuation;
}

////////////////////////////////////////////////////////////////////
//     Function: PointLight::get_point
//       Access: Public
//  Description: Returns the point in space at which the light is
//               located.  This is local to the coordinate space in
//               which the light is assigned.
////////////////////////////////////////////////////////////////////
INLINE const LPoint3f &PointLight::
get_point() const {
  CDReader cdata(_cycler);
  return cdata->_point;
}

////////////////////////////////////////////////////////////////////
//     Function: PointLight::set_point
//       Access: Public
//  Description: Sets the point in space at which the light is located.
////////////////////////////////////////////////////////////////////
INLINE void PointLight::
set_point(const LPoint3f &point) {
  CDWriter cdata(_cycler);
  cdata->_point = point;
  mark_viz_stale();
}
