// Filename: mouseData.h
// Created by:  drose (08Feb99)
//
////////////////////////////////////////////////////////////////////
//
// PANDA 3D SOFTWARE
// Copyright (c) 2001 - 2004, Disney Enterprises, Inc.  All rights reserved
//
// All use of this software is subject to the terms of the Panda 3d
// Software license.  You should have received a copy of this license
// along with this source code; you will also find a current copy of
// the license at http://etc.cmu.edu/panda3d/docs/license/ .
//
// To contact the maintainers of this program write to
// panda3d-general@lists.sourceforge.net .
//
////////////////////////////////////////////////////////////////////

#ifndef MOUSEDATA_H
#define MOUSEDATA_H

#include "pandabase.h"

#include "modifierButtons.h"

////////////////////////////////////////////////////////////////////
//       Class : MouseData
// Description : Holds the data that might be generated by a 2-d
//               pointer input device, such as the mouse in the
//               GraphicsWindow.
////////////////////////////////////////////////////////////////////
class EXPCL_PANDA MouseData {
PUBLISHED:
  INLINE MouseData();
  INLINE MouseData(const MouseData &copy);
  INLINE void operator = (const MouseData &copy);

  INLINE int get_x() const;
  INLINE int get_y() const;
  INLINE bool get_in_window() const;

  void output(ostream &out) const;

public:
  bool _in_window;
  int _xpos;
  int _ypos;
};

INLINE ostream &operator << (ostream &out, const MouseData &md);

#include "mouseData.I"

#endif


