// Filename: eggMakeFont.h
// Created by:  drose (16Feb01)
//
////////////////////////////////////////////////////////////////////
//
// PANDA 3D SOFTWARE
// Copyright (c) 2001 - 2004, Disney Enterprises, Inc.  All rights reserved
//
// All use of this software is subject to the terms of the Panda 3d
// Software license.  You should have received a copy of this license
// along with this source code; you will also find a current copy of
// the license at http://etc.cmu.edu/panda3d/docs/license/ .
//
// To contact the maintainers of this program write to
// panda3d-general@lists.sourceforge.net .
//
////////////////////////////////////////////////////////////////////

#ifndef EGGMAKEFONT_H
#define EGGMAKEFONT_H

#include "pandatoolbase.h"
#include "rangeDescription.h"

#include "eggWriter.h"
#include "eggTexture.h"
#include "pmap.h"
#include "pvector.h"
#include "vector_string.h"

class PNMTextMaker;
class PNMTextGlyph;
class EggVertexPool;
class EggGroup;
class TextureImage;

////////////////////////////////////////////////////////////////////
//       Class : EggMakeFont
// Description : This program uses FreeType to generate an egg file
//               and a series of texture images from a font file
//               input, such as a TTF file.  The resulting egg file
//               can be loaded in Panda as a StaticTextFont object for
//               rendering text, even if FreeType is not compiled into
//               the executing Panda.
////////////////////////////////////////////////////////////////////
class EggMakeFont : public EggWriter {
public:
  EggMakeFont();

protected:
  virtual bool handle_args(Args &args);

public:
  void run();

private:
  static bool dispatch_range(const string &, const string &arg, void *var);
  EggVertex *make_vertex(const LPoint2d &xy);

  void add_character(int code);
  void make_geom(PNMTextGlyph *glyph, int character);
  EggTexture *get_tref(PNMTextGlyph *glyph, int character);
  EggTexture *make_tref(PNMTextGlyph *glyph, int character);
  void add_extra_glyphs(const Filename &extra_filename);
  void r_add_extra_glyphs(EggGroupNode *egg_group);
  static bool is_numeric(const string &str);


private:
  Colorf _fg, _bg, _interior;
  bool _got_interior;
  RangeDescription _range;
  vector_string _extra_filenames;
  double _pixels_per_unit;
  double _point_size;
  double _poly_margin;
  int _tex_margin;
  bool _got_scale_factor;
  double _scale_factor;
  bool _no_reduce;
  bool _no_native_aa;
  bool _no_palettize;
  int _palette_size[2];

  double _palettize_scale_factor;
  Filename _input_font_filename;
  int _face_index;
  string _output_glyph_pattern;
  string _output_palette_pattern;

  PNMTextMaker *_text_maker;
  
  EggTexture::Format _format;
  int _num_channels;
  EggVertexPool *_vpool;
  EggGroup *_group;

  typedef pmap<PNMTextGlyph *, EggTexture *> TRefs;
  TRefs _trefs;

  typedef pvector<TextureImage *> Textures;
  Textures _textures;
};


#endif

