/*
  MaxEgg.h 
  Created by Steven "Sauce" Osman, 01/??/03
  Modified and maintained by Ken Strickland, (02/01/03)-(05/15/03)
  Modified and maintained by Corey Revilla, (05/22/03)-present
  Carnegie Mellon University, Entetainment Technology Center

  This file contains a 3dsMax exporter derived from discreet's own SceneExport 
  plug-in class; this exporter is basically a wrapper around the MaxToEgg
  Panda-converter class, and just sets up the interface and environment
  in which the MaxToEgg class can be "run" as if it were a standalone app.
*/
#ifndef __MaxEggPlugin__H
#define __MaxEggPlugin__H

#pragma conform(forScope, off)

#include "pandatoolbase.h"

//Includes & Definitions
#include "MaxToEgg.h"
#include "MaxEggExpOptions.h"
#include "windef.h"

/* Error-Reporting Includes
 */
#include "Logger.h"
#define ME Logger::ST_MAP_ME_TO_APP_SPECIFIC_SYSTEM6
#define MaxEggPlugin_CLASS_ID	Class_ID(0x7ac0d6b7, 0x55731ef6)

/* Externed Globals
 */
extern HINSTANCE hInstance;

/* Global Functions
 */
extern TCHAR *GetString(int id);

/* This class defines the 3D Studio Max exporter itself.  It is basically a
   shell that is invoked by 3D Studio Max's export API.  It then sets up 
   MaxToEgg instance and attempts to "fool it" into thinking that it is
   actually being invoked as a standalone program.  The thought behind this
   is that some day MaxToEgg may well be a standalone program, provided that
   a suitable interface to Max files can be connected from a standalone
   program instead of a plugin.
*/
class MaxEggPlugin : public HelperObject 
{
  MaxEggExpOptions **eggList;
  int numEggs;
  int maxEggs;

 public:
  bool autoOverwrite;
  bool pview;
  bool logOutput;
  
  // Class vars
  static Mesh mesh;           // This plugin generates no geometry, this mesh is not passed on to 3D Studio.
  static short meshBuilt;
  static HWND hMaxEggParams;
  static IObjParam *iObjParams;

  //Constructor/Destructor
  MaxEggPlugin();
  virtual ~MaxEggPlugin();

  //Other class Methods
  void DoExport();
  void UpdateUI();
  void SaveCheckState();
  void BuildMesh();

  void AddEgg(MaxEggExpOptions *newEgg);
  void RemoveEgg(int i);
  MaxEggExpOptions *GetEgg(int i) { return (i >= 0 && i < numEggs) ? eggList[i] : NULL; }

  // Required implimented virtual methods:
  // inherited virtual methods for Reference-management
  RefResult NotifyRefChanged( Interval changeInt, RefTargetHandle hTarget, PartID& partID, RefMessage message );
  void GetMat(TimeValue t, INode* inod, ViewExp *vpt, Matrix3& mat);

  // From BaseObject
  int HitTest(TimeValue t, INode* inode, int type, int crossing, int flags, IPoint2 *p, ViewExp *vpt);
  int Display(TimeValue t, INode* inode, ViewExp *vpt, int flags);
  CreateMouseCallBack* GetCreateMouseCallBack();
  void BeginEditParams( IObjParam *ip, ULONG flags,Animatable *prev);
  void EndEditParams( IObjParam *ip, ULONG flags,Animatable *next);
  TCHAR *GetObjectName() { return GetString(IDS_LIBDESCRIPTION); }

  // From Object
  ObjectState Eval(TimeValue time);
  void InitNodeName(TSTR& s) { s = GetString(IDS_CLASS_NAME); }
  Interval ObjectValidity(TimeValue time);
  void Invalidate();
  int DoOwnSelectHilite() { return 1; }

  // From GeomObject
  int IntersectRay(TimeValue t, Ray& r, float& at) { return 0; }
  void GetWorldBoundBox(TimeValue t, INode *mat, ViewExp *vpt, Box3& box );
  void GetLocalBoundBox(TimeValue t, INode *mat, ViewExp *vpt, Box3& box );
  void GetDeformBBox(TimeValue t, Box3& box, Matrix3 *tm, BOOL useSel );

  // Animatable methods
  void DeleteThis() { delete this; }
  Class_ID ClassID() { return MaxEggPlugin_CLASS_ID; }
  void GetClassName(TSTR& s) { s = TSTR(GetString(IDS_CLASS_NAME)); }
  TSTR SubAnimName(int i) { return TSTR(GetString(IDS_CLASS_NAME)); }
  
  // From ref
  RefTargetHandle Clone(RemapDir& remap = NoRemap());

  // IO
  IOResult Save(ISave *isave);
  IOResult Load(ILoad *iload);

};



const double meshVerts[252][3] = {
	  {0.729464, 0.714986, -0.919852},
      {0.466137, 0.160201, -0.594656},
      {-0.265897, 0.714986, -1.14704},
      {0.466137, 0.160201, -0.594656},
      {-0.177333, 0.160201, -0.741523},
      {-0.265897, 0.714986, -1.14704},
      {-0.265897, 0.714986, -1.14704},
      {-0.177333, 0.160201, -0.741523},
      {-1.06411, 0.714986, -0.510479},
      {-0.177333, 0.160201, -0.741523},
      {-0.693356, 0.160201, -0.330009},
      {-1.06411, 0.714986, -0.510479},
      {-1.06411, 0.714986, 0.510479},
      {-1.06411, 0.714986, -0.510479},
      {-0.693356, 0.160201, 0.330009},
      {-0.693356, 0.160201, -0.330009},
      {-0.693356, 0.160201, 0.330009},
      {-1.06411, 0.714986, -0.510479},
      {-0.265897, 0.714986, 1.14704},
      {-1.06411, 0.714986, 0.510479},
      {-0.177333, 0.160201, 0.741523},
      {-0.693356, 0.160201, 0.330009},
      {-0.177333, 0.160201, 0.741523},
      {-1.06411, 0.714986, 0.510479},
      {0.729464, 0.714986, 0.919852},
      {-0.265897, 0.714986, 1.14704},
      {0.466137, 0.160201, 0.594656},
      {-0.177333, 0.160201, 0.741523},
      {0.466137, 0.160201, 0.594656},
      {-0.265897, 0.714986, 1.14704},
      {1.17244, 0.714986, 0.0},
      {0.729464, 0.714986, 0.919852},
      {0.752508, 0.160201, 0.0},
      {0.466137, 0.160201, 0.594656},
      {0.752508, 0.160201, 0.0},
      {0.729464, 0.714986, 0.919852},
      {0.729464, 0.714986, -0.919852},
      {1.17244, 0.714986, 0.0},
      {0.466137, 0.160201, -0.594656},
      {0.752508, 0.160201, 0.0},
      {0.466137, 0.160201, -0.594656},
      {1.17244, 0.714986, 0.0},
      {-0.286334, 1.44995, -1.26822},
      {0.814187, 1.44995, -1.01703},
      {-0.265897, 0.714986, -1.14704},
      {0.729464, 0.714986, -0.919852},
      {-0.265897, 0.714986, -1.14704},
      {0.814187, 1.44995, -1.01703},
      {-1.16888, 1.44995, -0.564412},
      {-0.286334, 1.44995, -1.26822},
      {-1.06411, 0.714986, -0.510479},
      {-0.265897, 0.714986, -1.14704},
      {-1.06411, 0.714986, -0.510479},
      {-0.286334, 1.44995, -1.26822},
      {-1.16888, 1.44995, 0.564411},
      {-1.16888, 1.44995, -0.564412},
      {-1.06411, 0.714986, 0.510479},
      {-1.06411, 0.714986, -0.510479},
      {-1.06411, 0.714986, 0.510479},
      {-1.16888, 1.44995, -0.564412},
      {-1.16888, 1.44995, 0.564411},
      {-1.06411, 0.714986, 0.510479},
      {-0.286334, 1.44995, 1.26822},
      {-1.06411, 0.714986, 0.510479},
      {-0.265897, 0.714986, 1.14704},
      {-0.286334, 1.44995, 1.26822},
      {-0.286334, 1.44995, 1.26822},
      {-0.265897, 0.714986, 1.14704},
      {0.814187, 1.44995, 1.01703},
      {-0.265897, 0.714986, 1.14704},
      {0.729464, 0.714986, 0.919852},
      {0.814187, 1.44995, 1.01703},
      {1.30396, 1.44995, 0.0},
      {0.814187, 1.44995, 1.01703},
      {1.17244, 0.714986, 0.0},
      {0.729464, 0.714986, 0.919852},
      {1.17244, 0.714986, 0.0},
      {0.814187, 1.44995, 1.01703},
      {1.30396, 1.44995, 0.0},
      {1.17244, 0.714986, 0.0},
      {0.814187, 1.44995, -1.01703},
      {1.17244, 0.714986, 0.0},
      {0.729464, 0.714986, -0.919852},
      {0.814187, 1.44995, -1.01703},
      {-0.286334, 1.44995, -1.26822},
      {-0.227573, 2.16723, -1.05763},
      {0.814187, 1.44995, -1.01703},
      {0.814187, 1.44995, -1.01703},
      {-0.227573, 2.16723, -1.05763},
      {0.690208, 2.16723, -0.848157},
      {-1.16888, 1.44995, -0.564412},
      {-0.963577, 2.16723, -0.470692},
      {-0.286334, 1.44995, -1.26822},
      {-0.286334, 1.44995, -1.26822},
      {-0.963577, 2.16723, -0.470692},
      {-0.227573, 2.16723, -1.05763},
      {-1.16888, 1.44995, -0.564412},
      {-1.16888, 1.44995, 0.564411},
      {-0.963577, 2.16723, -0.470692},
      {-1.16888, 1.44995, 0.564411},
      {-0.963577, 2.16723, 0.470692},
      {-0.963577, 2.16723, -0.470692},
      {-1.16888, 1.44995, 0.564411},
      {-0.286334, 1.44995, 1.26822},
      {-0.963577, 2.16723, 0.470692},
      {-0.286334, 1.44995, 1.26822},
      {-0.227574, 2.16723, 1.05763},
      {-0.963577, 2.16723, 0.470692},
      {-0.286334, 1.44995, 1.26822},
      {0.814187, 1.44995, 1.01703},
      {-0.227574, 2.16723, 1.05763},
      {0.814187, 1.44995, 1.01703},
      {0.690208, 2.16723, 0.848157},
      {-0.227574, 2.16723, 1.05763},
      {0.814187, 1.44995, 1.01703},
      {1.30396, 1.44995, 0.0},
      {0.690208, 2.16723, 0.848157},
      {1.30396, 1.44995, 0.0},
      {1.09866, 2.16723, 0.0},
      {0.690208, 2.16723, 0.848157},
      {0.814187, 1.44995, -1.01703},
      {0.690208, 2.16723, -0.848157},
      {1.30396, 1.44995, 0.0},
      {1.30396, 1.44995, 0.0},
      {0.690208, 2.16723, -0.848157},
      {1.09866, 2.16723, 0.0},
      {-0.227573, 2.16723, -1.05763},
      {-0.154893, 2.72566, -0.759032},
      {0.690208, 2.16723, -0.848157},
      {0.690208, 2.16723, -0.848157},
      {-0.154893, 2.72566, -0.759032},
      {0.50377, 2.72566, -0.608696},
      {-0.963577, 2.16723, -0.470692},
      {-0.683099, 2.72566, -0.337801},
      {-0.227573, 2.16723, -1.05763},
      {-0.227573, 2.16723, -1.05763},
      {-0.683099, 2.72566, -0.337801},
      {-0.154893, 2.72566, -0.759032},
      {-0.963577, 2.16723, -0.470692},
      {-0.963577, 2.16723, 0.470692},
      {-0.683099, 2.72566, -0.337801},
      {-0.963577, 2.16723, 0.470692},
      {-0.683099, 2.72566, 0.337801},
      {-0.683099, 2.72566, -0.337801},
      {-0.963577, 2.16723, 0.470692},
      {-0.227574, 2.16723, 1.05763},
      {-0.683099, 2.72566, 0.337801},
      {-0.227574, 2.16723, 1.05763},
      {-0.154893, 2.72566, 0.759032},
      {-0.683099, 2.72566, 0.337801},
      {-0.227574, 2.16723, 1.05763},
      {0.690208, 2.16723, 0.848157},
      {-0.154893, 2.72566, 0.759032},
      {0.690208, 2.16723, 0.848157},
      {0.50377, 2.72566, 0.608696},
      {-0.154893, 2.72566, 0.759032},
      {0.690208, 2.16723, 0.848157},
      {1.09866, 2.16723, 0.0},
      {0.50377, 2.72566, 0.608696},
      {1.09866, 2.16723, 0.0},
      {0.796903, 2.72566, 0.0},
      {0.50377, 2.72566, 0.608696},
      {1.09866, 2.16723, 0.0},
      {0.690208, 2.16723, -0.848157},
      {0.796903, 2.72566, 0.0},
      {0.690208, 2.16723, -0.848157},
      {0.50377, 2.72566, -0.608696},
      {0.796903, 2.72566, 0.0},
      {0.50377, 2.72566, -0.608696},
      {-0.154893, 2.72566, -0.759032},
      {0.259722, 3.11175, -0.299638},
      {-0.154893, 2.72566, -0.759032},
      {-0.0645132, 3.11175, -0.373643},
      {0.259722, 3.11175, -0.299638},
      {-0.154893, 2.72566, -0.759032},
      {-0.683099, 2.72566, -0.337801},
      {-0.0645132, 3.11175, -0.373643},
      {-0.683099, 2.72566, -0.337801},
      {-0.324529, 3.11175, -0.166287},
      {-0.0645132, 3.11175, -0.373643},
      {-0.683099, 2.72566, -0.337801},
      {-0.683099, 2.72566, 0.337801},
      {-0.324529, 3.11175, -0.166287},
      {-0.683099, 2.72566, 0.337801},
      {-0.324529, 3.11175, 0.166287},
      {-0.324529, 3.11175, -0.166287},
      {-0.683099, 2.72566, 0.337801},
      {-0.154893, 2.72566, 0.759032},
      {-0.324529, 3.11175, 0.166287},
      {-0.154893, 2.72566, 0.759032},
      {-0.0645132, 3.11175, 0.373642},
      {-0.324529, 3.11175, 0.166287},
      {-0.154893, 2.72566, 0.759032},
      {0.50377, 2.72566, 0.608696},
      {-0.0645132, 3.11175, 0.373642},
      {0.50377, 2.72566, 0.608696},
      {0.259722, 3.11175, 0.299638},
      {-0.0645132, 3.11175, 0.373642},
      {0.50377, 2.72566, 0.608696},
      {0.796903, 2.72566, 0.0},
      {0.259722, 3.11175, 0.299638},
      {0.796903, 2.72566, 0.0},
      {0.40402, 3.11175, 0.0},
      {0.259722, 3.11175, 0.299638},
      {0.796903, 2.72566, 0.0},
      {0.50377, 2.72566, -0.608696},
      {0.40402, 3.11175, 0.0},
      {0.50377, 2.72566, -0.608696},
      {0.259722, 3.11175, -0.299638},
      {0.40402, 3.11175, 0.0},
      {-0.177333, 0.160201, -0.741523},
      {0.466137, 0.160201, -0.594656},
      {-0.00334214, 0.00443203, 0.0},
      {-0.693356, 0.160201, -0.330009},
      {-0.177333, 0.160201, -0.741523},
      {-0.00334214, 0.00443203, 0.0},
      {-0.693356, 0.160201, 0.330009},
      {-0.693356, 0.160201, -0.330009},
      {-0.00334214, 0.00443203, 0.0},
      {-0.177333, 0.160201, 0.741523},
      {-0.693356, 0.160201, 0.330009},
      {-0.00334214, 0.00443203, 0.0},
      {0.466137, 0.160201, 0.594656},
      {-0.177333, 0.160201, 0.741523},
      {-0.00334214, 0.00443203, 0.0},
      {0.752508, 0.160201, 0.0},
      {0.466137, 0.160201, 0.594656},
      {-0.00334214, 0.00443203, 0.0},
      {0.466137, 0.160201, -0.594656},
      {0.752508, 0.160201, 0.0},
      {-0.00334214, 0.00443203, 0.0},
      {0.259722, 3.11175, -0.299638},
      {-0.0645132, 3.11175, -0.373643},
      {0.0207683, 3.20912, 0.0},
      {-0.0645132, 3.11175, -0.373643},
      {-0.324529, 3.11175, -0.166287},
      {0.0207683, 3.20912, 0.0},
      {-0.324529, 3.11175, -0.166287},
      {-0.324529, 3.11175, 0.166287},
      {0.0207683, 3.20912, 0.0},
      {-0.324529, 3.11175, 0.166287},
      {-0.0645132, 3.11175, 0.373642},
      {0.0207683, 3.20912, 0.0},
      {-0.0645132, 3.11175, 0.373642},
      {0.259722, 3.11175, 0.299638},
      {0.0207683, 3.20912, 0.0},
      {0.259722, 3.11175, 0.299638},
      {0.40402, 3.11175, 0.0},
      {0.0207683, 3.20912, 0.0},
      {0.40402, 3.11175, 0.0},
      {0.259722, 3.11175, -0.299638},
      {0.0207683, 3.20912, 0.0}
  };
  
#endif // __MaxEggPlugin__H
