// Filename: xFileDataNodeReference.h
// Created by:  drose (08Oct04)
//
////////////////////////////////////////////////////////////////////
//
// PANDA 3D SOFTWARE
// Copyright (c) 2001 - 2004, Disney Enterprises, Inc.  All rights reserved
//
// All use of this software is subject to the terms of the Panda 3d
// Software license.  You should have received a copy of this license
// along with this source code; you will also find a current copy of
// the license at http://etc.cmu.edu/panda3d/docs/license/ .
//
// To contact the maintainers of this program write to
// panda3d-general@lists.sourceforge.net .
//
////////////////////////////////////////////////////////////////////

#ifndef XFILEDATANODEREFERENCE_H
#define XFILEDATANODEREFERENCE_H

#include "pandatoolbase.h"
#include "xFileDataNodeTemplate.h"
#include "pointerTo.h"

////////////////////////////////////////////////////////////////////
//       Class : XFileDataNodeReference
// Description : This is a nested reference to an instance of a
//               template object, declared via the syntax:
//
//                 { InstanceName }
//
//               in the X File.
////////////////////////////////////////////////////////////////////
class XFileDataNodeReference : public XFileDataNode {
public:
  XFileDataNodeReference(XFileDataNodeTemplate *object);

  INLINE XFileTemplate *get_template() const;
  INLINE XFileDataNodeTemplate *get_object() const;

  virtual bool is_reference() const;
  virtual bool is_complex_object() const;

  virtual void write_text(ostream &out, int indent_level) const;

protected:
  virtual int get_num_elements() const;
  virtual XFileDataObject *get_element(int n);
  virtual XFileDataObject *get_element(const string &name);

private:
  PT(XFileDataNodeTemplate) _object;

public:
  static TypeHandle get_class_type() {
    return _type_handle;
  }
  static void init_type() {
    XFileDataNode::init_type();
    register_type(_type_handle, "XFileDataNodeReference",
                  XFileDataNode::get_class_type());
  }
  virtual TypeHandle get_type() const {
    return get_class_type();
  }
  virtual TypeHandle force_init_type() {init_type(); return get_class_type();}

private:
  static TypeHandle _type_handle;
};

#include "xFileDataNodeReference.I"

#endif
  



