/**
 * PANDA 3D SOFTWARE
 * Copyright (c) Carnegie Mellon University.  All rights reserved.
 *
 * All use of this software is subject to the terms of the revised BSD
 * license.  You should have received a copy of this license along
 * with this source code in a file named "LICENSE."
 *
 * @file dcClass.I
 * @author drose
 * @date 2004-09-15
 */

/**
 * Returns the DCFile object that contains the class.
 */
INLINE DCFile *DCClass::
get_dc_file() const {
  return _dc_file;
}

/**
 * Returns the name of this class.
 */
INLINE const std::string &DCClass::
get_name() const {
  return _name;
}

/**
 * Returns a unique index number associated with this class.  This is defined
 * implicitly when the .dc file(s) are read.
 */
INLINE int DCClass::
get_number() const {
  return _number;
}

/**
 * Returns true if the class has been identified with the "struct" keyword in
 * the dc file, false if it was declared with "dclass".
 */
INLINE bool DCClass::
is_struct() const {
  return _is_struct;
}

/**
 * Returns true if the class has been flagged as a bogus class.  This is set
 * for classes that are generated by the parser as placeholder for missing
 * classes, as when reading a partial file; it should not occur in a normal
 * valid dc file.
 */
INLINE bool DCClass::
is_bogus_class() const {
  return _bogus_class;
}

/**
 * Starts the PStats timer going on the "generate" task, that is, marks the
 * beginning of the process of generating a new object, for the purposes of
 * timing this process.
 *
 * This should balance with a corresponding call to stop_generate().
 */
INLINE void DCClass::
start_generate() {
#ifdef WITHIN_PANDA
  _class_generate_pcollector.start();
#endif
}

/**
 * Stops the PStats timer on the "generate" task.  This should balance with a
 * preceding call to start_generate().
 */
INLINE void DCClass::
stop_generate() {
#ifdef WITHIN_PANDA
  _class_generate_pcollector.stop();
#endif
}
