/**
 * PANDA 3D SOFTWARE
 * Copyright (c) Carnegie Mellon University.  All rights reserved.
 *
 * All use of this software is subject to the terms of the revised BSD
 * license.  You should have received a copy of this license along
 * with this source code in a file named "LICENSE."
 *
 * @file cast_to_double.I
 * @author drose
 * @date 2000-05-24
 */

INLINE_LINMATH LVecBase2d cast_to_double(const LVecBase2f &source) {
  return LCAST(double, source);
}

INLINE_LINMATH LVecBase3d cast_to_double(const LVecBase3f &source) {
  return LCAST(double, source);
}

INLINE_LINMATH LVecBase4d cast_to_double(const LVecBase4f &source) {
  return LCAST(double, source);
}

INLINE_LINMATH LVector2d cast_to_double(const LVector2f &source) {
  return LCAST(double, source);
}

INLINE_LINMATH LVector3d cast_to_double(const LVector3f &source) {
  return LCAST(double, source);
}

INLINE_LINMATH LVector4d cast_to_double(const LVector4f &source) {
  return LCAST(double, source);
}

INLINE_LINMATH LPoint2d cast_to_double(const LPoint2f &source) {
  return LCAST(double, source);
}

INLINE_LINMATH LPoint3d cast_to_double(const LPoint3f &source) {
  return LCAST(double, source);
}

INLINE_LINMATH LPoint4d cast_to_double(const LPoint4f &source) {
  return LCAST(double, source);
}

INLINE_LINMATH LMatrix3d cast_to_double(const LMatrix3f &source) {
  return LCAST(double, source);
}

INLINE_LINMATH LMatrix4d cast_to_double(const LMatrix4f &source) {
  return LCAST(double, source);
}
