/**
 * PANDA 3D SOFTWARE
 * Copyright (c) Carnegie Mellon University.  All rights reserved.
 *
 * All use of this software is subject to the terms of the revised BSD
 * license.  You should have received a copy of this license along
 * with this source code in a file named "LICENSE."
 *
 * @file unicodeLatinMap.cxx
 * @author drose
 * @date 2003-02-01
 */

#include "unicodeLatinMap.h"

bool UnicodeLatinMap::_initialized = false;
UnicodeLatinMap::ByCharacter *UnicodeLatinMap::_by_character;
const UnicodeLatinMap::Entry *UnicodeLatinMap::_direct_chars[UnicodeLatinMap::max_direct_chars];

static const UnicodeLatinMap::Entry latin_map[] = {
  { 0x00a1, UnicodeLatinMap::CT_punct, '!', 0, 0x00a1, 0x00a1,
    UnicodeLatinMap::AT_none, UnicodeLatinMap::AF_turned },
  { 0x00bf, UnicodeLatinMap::CT_punct, '?', 0, 0x00bf, 0x00bf,
    UnicodeLatinMap::AT_none, UnicodeLatinMap::AF_turned },
  { 0x0061, UnicodeLatinMap::CT_lower, 'a', 0, 0x0061, 0x0041,
    UnicodeLatinMap::AT_none, 0 },
  { 0x0041, UnicodeLatinMap::CT_upper, 'A', 0, 0x0061, 0x0041,
    UnicodeLatinMap::AT_none, 0 },
  { 0x00e1, UnicodeLatinMap::CT_lower, 'a', 0, 0x00e1, 0x00c1,
    UnicodeLatinMap::AT_acute, 0 },
  { 0x00c1, UnicodeLatinMap::CT_upper, 'A', 0, 0x00e1, 0x00c1,
    UnicodeLatinMap::AT_acute, 0 },
  { 0x00e0, UnicodeLatinMap::CT_lower, 'a', 0, 0x00e0, 0x00c0,
    UnicodeLatinMap::AT_grave, 0 },
  { 0x00c0, UnicodeLatinMap::CT_upper, 'A', 0, 0x00e0, 0x00c0,
    UnicodeLatinMap::AT_grave, 0 },
  { 0x0103, UnicodeLatinMap::CT_lower, 'a', 0, 0x0103, 0x0102,
    UnicodeLatinMap::AT_breve, 0 },
  { 0x0102, UnicodeLatinMap::CT_upper, 'A', 0, 0x0103, 0x0102,
    UnicodeLatinMap::AT_breve, 0 },
  { 0x1eaf, UnicodeLatinMap::CT_lower, 'a', 0, 0x1eaf, 0x1eae,
    UnicodeLatinMap::AT_breve_and_acute, 0 },
  { 0x1eae, UnicodeLatinMap::CT_upper, 'A', 0, 0x1eaf, 0x1eae,
    UnicodeLatinMap::AT_breve_and_acute, 0 },
  { 0x1eb1, UnicodeLatinMap::CT_lower, 'a', 0, 0x1eb1, 0x1eb0,
    UnicodeLatinMap::AT_breve_and_grave, 0 },
  { 0x1eb0, UnicodeLatinMap::CT_upper, 'A', 0, 0x1eb1, 0x1eb0,
    UnicodeLatinMap::AT_breve_and_grave, 0 },
  { 0x1eb5, UnicodeLatinMap::CT_lower, 'a', 0, 0x1eb5, 0x1eb4,
    UnicodeLatinMap::AT_breve_and_tilde, 0 },
  { 0x1eb4, UnicodeLatinMap::CT_upper, 'A', 0, 0x1eb5, 0x1eb4,
    UnicodeLatinMap::AT_breve_and_tilde, 0 },
  { 0x1eb3, UnicodeLatinMap::CT_lower, 'a', 0, 0x1eb3, 0x1eb2,
    UnicodeLatinMap::AT_breve_and_hook_above, 0 },
  { 0x1eb2, UnicodeLatinMap::CT_upper, 'A', 0, 0x1eb3, 0x1eb2,
    UnicodeLatinMap::AT_breve_and_hook_above, 0 },
  { 0x00e2, UnicodeLatinMap::CT_lower, 'a', 0, 0x00e2, 0x00c2,
    UnicodeLatinMap::AT_circumflex, 0 },
  { 0x00c2, UnicodeLatinMap::CT_upper, 'A', 0, 0x00e2, 0x00c2,
    UnicodeLatinMap::AT_circumflex, 0 },
  { 0x1ea5, UnicodeLatinMap::CT_lower, 'a', 0, 0x1ea5, 0x1ea4,
    UnicodeLatinMap::AT_circumflex_and_acute, 0 },
  { 0x1ea4, UnicodeLatinMap::CT_upper, 'A', 0, 0x1ea5, 0x1ea4,
    UnicodeLatinMap::AT_circumflex_and_acute, 0 },
  { 0x1ea7, UnicodeLatinMap::CT_lower, 'a', 0, 0x1ea7, 0x1ea6,
    UnicodeLatinMap::AT_circumflex_and_grave, 0 },
  { 0x1ea6, UnicodeLatinMap::CT_upper, 'A', 0, 0x1ea7, 0x1ea6,
    UnicodeLatinMap::AT_circumflex_and_grave, 0 },
  { 0x1eab, UnicodeLatinMap::CT_lower, 'a', 0, 0x1eab, 0x1eaa,
    UnicodeLatinMap::AT_circumflex_and_tilde, 0 },
  { 0x1eaa, UnicodeLatinMap::CT_upper, 'A', 0, 0x1eab, 0x1eaa,
    UnicodeLatinMap::AT_circumflex_and_tilde, 0 },
  { 0x1ea9, UnicodeLatinMap::CT_lower, 'a', 0, 0x1ea9, 0x1ea8,
    UnicodeLatinMap::AT_circumflex_and_hook_above, 0 },
  { 0x1ea8, UnicodeLatinMap::CT_upper, 'A', 0, 0x1ea9, 0x1ea8,
    UnicodeLatinMap::AT_circumflex_and_hook_above, 0 },
  { 0x01ce, UnicodeLatinMap::CT_lower, 'a', 0, 0x01ce, 0x01cd,
    UnicodeLatinMap::AT_caron, 0 },
  { 0x01cd, UnicodeLatinMap::CT_upper, 'A', 0, 0x01ce, 0x01cd,
    UnicodeLatinMap::AT_caron, 0 },
  { 0x00e5, UnicodeLatinMap::CT_lower, 'a', 0, 0x00e5, 0x00c5,
    UnicodeLatinMap::AT_ring_above, 0 },
  { 0x00c5, UnicodeLatinMap::CT_upper, 'A', 0, 0x00e5, 0x00c5,
    UnicodeLatinMap::AT_ring_above, 0 },
  { 0x01fb, UnicodeLatinMap::CT_lower, 'a', 0, 0x01fb, 0x01fa,
    UnicodeLatinMap::AT_ring_above_and_acute, 0 },
  { 0x01fa, UnicodeLatinMap::CT_upper, 'A', 0, 0x01fb, 0x01fa,
    UnicodeLatinMap::AT_ring_above_and_acute, 0 },
  { 0x00e4, UnicodeLatinMap::CT_lower, 'a', 0, 0x00e4, 0x00c4,
    UnicodeLatinMap::AT_diaeresis, 0 },
  { 0x00c4, UnicodeLatinMap::CT_upper, 'A', 0, 0x00e4, 0x00c4,
    UnicodeLatinMap::AT_diaeresis, 0 },
  { 0x01df, UnicodeLatinMap::CT_lower, 'a', 0, 0x01df, 0x01de,
    UnicodeLatinMap::AT_diaeresis_and_macron, 0 },
  { 0x01de, UnicodeLatinMap::CT_upper, 'A', 0, 0x01df, 0x01de,
    UnicodeLatinMap::AT_diaeresis_and_macron, 0 },
  { 0x00e3, UnicodeLatinMap::CT_lower, 'a', 0, 0x00e3, 0x00c3,
    UnicodeLatinMap::AT_tilde, 0 },
  { 0x00c3, UnicodeLatinMap::CT_upper, 'A', 0, 0x00e3, 0x00c3,
    UnicodeLatinMap::AT_tilde, 0 },
  { 0x0227, UnicodeLatinMap::CT_lower, 'a', 0, 0x0227, 0x0226,
    UnicodeLatinMap::AT_dot_above, 0 },
  { 0x0226, UnicodeLatinMap::CT_upper, 'A', 0, 0x0227, 0x0226,
    UnicodeLatinMap::AT_dot_above, 0 },
  { 0x01e1, UnicodeLatinMap::CT_lower, 'a', 0, 0x01e1, 0x01e0,
    UnicodeLatinMap::AT_dot_above_and_macron, 0 },
  { 0x01e0, UnicodeLatinMap::CT_upper, 'A', 0, 0x01e1, 0x01e0,
    UnicodeLatinMap::AT_dot_above_and_macron, 0 },
  { 0x0105, UnicodeLatinMap::CT_lower, 'a', 0, 0x0105, 0x0104,
    UnicodeLatinMap::AT_ogonek, 0 },
  { 0x0104, UnicodeLatinMap::CT_upper, 'A', 0, 0x0105, 0x0104,
    UnicodeLatinMap::AT_ogonek, 0 },
  { 0x0101, UnicodeLatinMap::CT_lower, 'a', 0, 0x0101, 0x0100,
    UnicodeLatinMap::AT_macron, 0 },
  { 0x0100, UnicodeLatinMap::CT_upper, 'A', 0, 0x0101, 0x0100,
    UnicodeLatinMap::AT_macron, 0 },
  { 0x1ea3, UnicodeLatinMap::CT_lower, 'a', 0, 0x1ea3, 0x1ea2,
    UnicodeLatinMap::AT_hook_above, 0 },
  { 0x1ea2, UnicodeLatinMap::CT_upper, 'A', 0, 0x1ea3, 0x1ea2,
    UnicodeLatinMap::AT_hook_above, 0 },
  { 0x0201, UnicodeLatinMap::CT_lower, 'a', 0, 0x0201, 0x0200,
    UnicodeLatinMap::AT_double_grave, 0 },
  { 0x0200, UnicodeLatinMap::CT_upper, 'A', 0, 0x0201, 0x0200,
    UnicodeLatinMap::AT_double_grave, 0 },
  { 0x0203, UnicodeLatinMap::CT_lower, 'a', 0, 0x0203, 0x0202,
    UnicodeLatinMap::AT_inverted_breve, 0 },
  { 0x0202, UnicodeLatinMap::CT_upper, 'A', 0, 0x0203, 0x0202,
    UnicodeLatinMap::AT_inverted_breve, 0 },
  { 0x1ea1, UnicodeLatinMap::CT_lower, 'a', 0, 0x1ea1, 0x1ea0,
    UnicodeLatinMap::AT_dot_below, 0 },
  { 0x1ea0, UnicodeLatinMap::CT_upper, 'A', 0, 0x1ea1, 0x1ea0,
    UnicodeLatinMap::AT_dot_below, 0 },
  { 0x1eb7, UnicodeLatinMap::CT_lower, 'a', 0, 0x1eb7, 0x1eb6,
    UnicodeLatinMap::AT_breve_and_dot_below, 0 },
  { 0x1eb6, UnicodeLatinMap::CT_upper, 'A', 0, 0x1eb7, 0x1eb6,
    UnicodeLatinMap::AT_breve_and_dot_below, 0 },
  { 0x1ead, UnicodeLatinMap::CT_lower, 'a', 0, 0x1ead, 0x1eac,
    UnicodeLatinMap::AT_circumflex_and_dot_below, 0 },
  { 0x1eac, UnicodeLatinMap::CT_upper, 'A', 0, 0x1ead, 0x1eac,
    UnicodeLatinMap::AT_circumflex_and_dot_below, 0 },
  { 0x1e01, UnicodeLatinMap::CT_lower, 'a', 0, 0x1e01, 0x1e00,
    UnicodeLatinMap::AT_ring_below, 0 },
  { 0x1e00, UnicodeLatinMap::CT_upper, 'A', 0, 0x1e01, 0x1e00,
    UnicodeLatinMap::AT_ring_below, 0 },
  { 0x00e6, UnicodeLatinMap::CT_lower, 'a', 'e', 0x00e6, 0x00c6,
    UnicodeLatinMap::AT_none, UnicodeLatinMap::AF_ligature },
  { 0x00c6, UnicodeLatinMap::CT_upper, 'A', 'E', 0x00e6, 0x00c6,
    UnicodeLatinMap::AT_none, UnicodeLatinMap::AF_ligature },
  { 0x01fd, UnicodeLatinMap::CT_lower, 'a', 'e', 0x01fd, 0x01fc,
    UnicodeLatinMap::AT_acute, UnicodeLatinMap::AF_ligature },
  { 0x01fc, UnicodeLatinMap::CT_upper, 'A', 'E', 0x01fd, 0x01fc,
    UnicodeLatinMap::AT_acute, UnicodeLatinMap::AF_ligature },
  { 0x01e3, UnicodeLatinMap::CT_lower, 'a', 'e', 0x01e3, 0x01e2,
    UnicodeLatinMap::AT_macron, UnicodeLatinMap::AF_ligature },
  { 0x01e2, UnicodeLatinMap::CT_upper, 'A', 'E', 0x01e3, 0x01e2,
    UnicodeLatinMap::AT_macron, UnicodeLatinMap::AF_ligature },
  { 0x0250, UnicodeLatinMap::CT_lower, 'a', 0, 0x0250, 0x0041,
    UnicodeLatinMap::AT_none, UnicodeLatinMap::AF_turned },
  { 0x0062, UnicodeLatinMap::CT_lower, 'b', 0, 0x0062, 0x0042,
    UnicodeLatinMap::AT_none, 0 },
  { 0x0042, UnicodeLatinMap::CT_upper, 'B', 0, 0x0062, 0x0042,
    UnicodeLatinMap::AT_none, 0 },
  { 0x1e03, UnicodeLatinMap::CT_lower, 'b', 0, 0x1e03, 0x1e02,
    UnicodeLatinMap::AT_dot_above, 0 },
  { 0x1e02, UnicodeLatinMap::CT_upper, 'B', 0, 0x1e03, 0x1e02,
    UnicodeLatinMap::AT_dot_above, 0 },
  { 0x1e05, UnicodeLatinMap::CT_lower, 'b', 0, 0x1e05, 0x1e04,
    UnicodeLatinMap::AT_dot_below, 0 },
  { 0x1e04, UnicodeLatinMap::CT_upper, 'B', 0, 0x1e05, 0x1e04,
    UnicodeLatinMap::AT_dot_below, 0 },
  { 0x1e07, UnicodeLatinMap::CT_lower, 'b', 0, 0x1e07, 0x1e06,
    UnicodeLatinMap::AT_line_below, 0 },
  { 0x1e06, UnicodeLatinMap::CT_upper, 'B', 0, 0x1e07, 0x1e06,
    UnicodeLatinMap::AT_line_below, 0 },
  { 0x0299, UnicodeLatinMap::CT_upper, 'B', 0, 0x0062, 0x0299,
    UnicodeLatinMap::AT_none, UnicodeLatinMap::AF_smallcap },
  { 0x0180, UnicodeLatinMap::CT_lower, 'b', 0, 0x0180, 0x0042,
    UnicodeLatinMap::AT_stroke, 0 },
  { 0x0253, UnicodeLatinMap::CT_lower, 'b', 0, 0x0253, 0x0181,
    UnicodeLatinMap::AT_hook, 0 },
  { 0x0181, UnicodeLatinMap::CT_upper, 'B', 0, 0x0253, 0x0181,
    UnicodeLatinMap::AT_hook, 0 },
  { 0x0183, UnicodeLatinMap::CT_lower, 'b', 0, 0x0183, 0x0182,
    UnicodeLatinMap::AT_topbar, 0 },
  { 0x0182, UnicodeLatinMap::CT_upper, 'B', 0, 0x0183, 0x0182,
    UnicodeLatinMap::AT_topbar, 0 },
  { 0x0063, UnicodeLatinMap::CT_lower, 'c', 0, 0x0063, 0x0043,
    UnicodeLatinMap::AT_none, 0 },
  { 0x0043, UnicodeLatinMap::CT_upper, 'C', 0, 0x0063, 0x0043,
    UnicodeLatinMap::AT_none, 0 },
  { 0x0107, UnicodeLatinMap::CT_lower, 'c', 0, 0x0107, 0x0106,
    UnicodeLatinMap::AT_acute, 0 },
  { 0x0106, UnicodeLatinMap::CT_upper, 'C', 0, 0x0107, 0x0106,
    UnicodeLatinMap::AT_acute, 0 },
  { 0x0109, UnicodeLatinMap::CT_lower, 'c', 0, 0x0109, 0x0108,
    UnicodeLatinMap::AT_circumflex, 0 },
  { 0x0108, UnicodeLatinMap::CT_upper, 'C', 0, 0x0109, 0x0108,
    UnicodeLatinMap::AT_circumflex, 0 },
  { 0x010d, UnicodeLatinMap::CT_lower, 'c', 0, 0x010d, 0x010c,
    UnicodeLatinMap::AT_caron, 0 },
  { 0x010c, UnicodeLatinMap::CT_upper, 'C', 0, 0x010d, 0x010c,
    UnicodeLatinMap::AT_caron, 0 },
  { 0x010b, UnicodeLatinMap::CT_lower, 'c', 0, 0x010b, 0x010a,
    UnicodeLatinMap::AT_dot_above, 0 },
  { 0x010a, UnicodeLatinMap::CT_upper, 'C', 0, 0x010b, 0x010a,
    UnicodeLatinMap::AT_dot_above, 0 },
  { 0x00e7, UnicodeLatinMap::CT_lower, 'c', 0, 0x00e7, 0x00c7,
    UnicodeLatinMap::AT_cedilla, 0 },
  { 0x00c7, UnicodeLatinMap::CT_upper, 'C', 0, 0x00e7, 0x00c7,
    UnicodeLatinMap::AT_cedilla, 0 },
  { 0x1e09, UnicodeLatinMap::CT_lower, 'c', 0, 0x1e09, 0x1e08,
    UnicodeLatinMap::AT_cedilla_and_acute, 0 },
  { 0x1e08, UnicodeLatinMap::CT_upper, 'C', 0, 0x1e09, 0x1e08,
    UnicodeLatinMap::AT_cedilla_and_acute, 0 },
  { 0x0188, UnicodeLatinMap::CT_lower, 'c', 0, 0x0188, 0x0187,
    UnicodeLatinMap::AT_hook, 0 },
  { 0x0187, UnicodeLatinMap::CT_upper, 'C', 0, 0x0188, 0x0187,
    UnicodeLatinMap::AT_hook, 0 },
  { 0x0255, UnicodeLatinMap::CT_lower, 'c', 0, 0x0255, 0x0043,
    UnicodeLatinMap::AT_curl, 0 },
  { 0x0064, UnicodeLatinMap::CT_lower, 'd', 0, 0x0064, 0x0044,
    UnicodeLatinMap::AT_none, 0 },
  { 0x0044, UnicodeLatinMap::CT_upper, 'D', 0, 0x0064, 0x0044,
    UnicodeLatinMap::AT_none, 0 },
  { 0x010f, UnicodeLatinMap::CT_lower, 'd', 0, 0x010f, 0x010e,
    UnicodeLatinMap::AT_caron, 0 },
  { 0x010e, UnicodeLatinMap::CT_upper, 'D', 0, 0x010f, 0x010e,
    UnicodeLatinMap::AT_caron, 0 },
  { 0x1e0b, UnicodeLatinMap::CT_lower, 'd', 0, 0x1e0b, 0x1e0a,
    UnicodeLatinMap::AT_dot_above, 0 },
  { 0x1e0a, UnicodeLatinMap::CT_upper, 'D', 0, 0x1e0b, 0x1e0a,
    UnicodeLatinMap::AT_dot_above, 0 },
  { 0x1e11, UnicodeLatinMap::CT_lower, 'd', 0, 0x1e11, 0x1e10,
    UnicodeLatinMap::AT_cedilla, 0 },
  { 0x1e10, UnicodeLatinMap::CT_upper, 'D', 0, 0x1e11, 0x1e10,
    UnicodeLatinMap::AT_cedilla, 0 },
  { 0x1e0d, UnicodeLatinMap::CT_lower, 'd', 0, 0x1e0d, 0x1e0c,
    UnicodeLatinMap::AT_dot_below, 0 },
  { 0x1e0c, UnicodeLatinMap::CT_upper, 'D', 0, 0x1e0d, 0x1e0c,
    UnicodeLatinMap::AT_dot_below, 0 },
  { 0x1e13, UnicodeLatinMap::CT_lower, 'd', 0, 0x1e13, 0x1e12,
    UnicodeLatinMap::AT_circumflex_below, 0 },
  { 0x1e12, UnicodeLatinMap::CT_upper, 'D', 0, 0x1e13, 0x1e12,
    UnicodeLatinMap::AT_circumflex_below, 0 },
  { 0x1e0f, UnicodeLatinMap::CT_lower, 'd', 0, 0x1e0f, 0x1e0e,
    UnicodeLatinMap::AT_line_below, 0 },
  { 0x1e0e, UnicodeLatinMap::CT_upper, 'D', 0, 0x1e0f, 0x1e0e,
    UnicodeLatinMap::AT_line_below, 0 },
  { 0x0111, UnicodeLatinMap::CT_lower, 'd', 0, 0x0111, 0x0110,
    UnicodeLatinMap::AT_stroke, 0 },
  { 0x0110, UnicodeLatinMap::CT_upper, 'D', 0, 0x0111, 0x0110,
    UnicodeLatinMap::AT_stroke, 0 },
  { 0x0257, UnicodeLatinMap::CT_lower, 'd', 0, 0x0257, 0x018a,
    UnicodeLatinMap::AT_hook, 0 },
  { 0x018a, UnicodeLatinMap::CT_upper, 'D', 0, 0x0257, 0x018a,
    UnicodeLatinMap::AT_hook, 0 },
  { 0x018c, UnicodeLatinMap::CT_lower, 'd', 0, 0x018c, 0x018b,
    UnicodeLatinMap::AT_topbar, 0 },
  { 0x018b, UnicodeLatinMap::CT_upper, 'D', 0, 0x018c, 0x018b,
    UnicodeLatinMap::AT_topbar, 0 },
  { 0x0065, UnicodeLatinMap::CT_lower, 'e', 0, 0x0065, 0x0045,
    UnicodeLatinMap::AT_none, 0 },
  { 0x0045, UnicodeLatinMap::CT_upper, 'E', 0, 0x0065, 0x0045,
    UnicodeLatinMap::AT_none, 0 },
  { 0x00e9, UnicodeLatinMap::CT_lower, 'e', 0, 0x00e9, 0x00c9,
    UnicodeLatinMap::AT_acute, 0 },
  { 0x00c9, UnicodeLatinMap::CT_upper, 'E', 0, 0x00e9, 0x00c9,
    UnicodeLatinMap::AT_acute, 0 },
  { 0x00e8, UnicodeLatinMap::CT_lower, 'e', 0, 0x00e8, 0x00c8,
    UnicodeLatinMap::AT_grave, 0 },
  { 0x00c8, UnicodeLatinMap::CT_upper, 'E', 0, 0x00e8, 0x00c8,
    UnicodeLatinMap::AT_grave, 0 },
  { 0x0115, UnicodeLatinMap::CT_lower, 'e', 0, 0x0115, 0x0114,
    UnicodeLatinMap::AT_breve, 0 },
  { 0x0114, UnicodeLatinMap::CT_upper, 'E', 0, 0x0115, 0x0114,
    UnicodeLatinMap::AT_breve, 0 },
  { 0x00ea, UnicodeLatinMap::CT_lower, 'e', 0, 0x00ea, 0x00ca,
    UnicodeLatinMap::AT_circumflex, 0 },
  { 0x00ca, UnicodeLatinMap::CT_upper, 'E', 0, 0x00ea, 0x00ca,
    UnicodeLatinMap::AT_circumflex, 0 },
  { 0x1ebf, UnicodeLatinMap::CT_lower, 'e', 0, 0x1ebf, 0x1ebe,
    UnicodeLatinMap::AT_circumflex_and_acute, 0 },
  { 0x1ebe, UnicodeLatinMap::CT_upper, 'E', 0, 0x1ebf, 0x1ebe,
    UnicodeLatinMap::AT_circumflex_and_acute, 0 },
  { 0x1ec1, UnicodeLatinMap::CT_lower, 'e', 0, 0x1ec1, 0x1ec0,
    UnicodeLatinMap::AT_circumflex_and_grave, 0 },
  { 0x1ec0, UnicodeLatinMap::CT_upper, 'E', 0, 0x1ec1, 0x1ec0,
    UnicodeLatinMap::AT_circumflex_and_grave, 0 },
  { 0x1ec5, UnicodeLatinMap::CT_lower, 'e', 0, 0x1ec5, 0x1ec4,
    UnicodeLatinMap::AT_circumflex_and_tilde, 0 },
  { 0x1ec4, UnicodeLatinMap::CT_upper, 'E', 0, 0x1ec5, 0x1ec4,
    UnicodeLatinMap::AT_circumflex_and_tilde, 0 },
  { 0x1ec3, UnicodeLatinMap::CT_lower, 'e', 0, 0x1ec3, 0x1ec2,
    UnicodeLatinMap::AT_circumflex_and_hook_above, 0 },
  { 0x1ec2, UnicodeLatinMap::CT_upper, 'E', 0, 0x1ec3, 0x1ec2,
    UnicodeLatinMap::AT_circumflex_and_hook_above, 0 },
  { 0x011b, UnicodeLatinMap::CT_lower, 'e', 0, 0x011b, 0x011a,
    UnicodeLatinMap::AT_caron, 0 },
  { 0x011a, UnicodeLatinMap::CT_upper, 'E', 0, 0x011b, 0x011a,
    UnicodeLatinMap::AT_caron, 0 },
  { 0x00eb, UnicodeLatinMap::CT_lower, 'e', 0, 0x00eb, 0x00cb,
    UnicodeLatinMap::AT_diaeresis, 0 },
  { 0x00cb, UnicodeLatinMap::CT_upper, 'E', 0, 0x00eb, 0x00cb,
    UnicodeLatinMap::AT_diaeresis, 0 },
  { 0x1ebd, UnicodeLatinMap::CT_lower, 'e', 0, 0x1ebd, 0x1ebc,
    UnicodeLatinMap::AT_tilde, 0 },
  { 0x1ebc, UnicodeLatinMap::CT_upper, 'E', 0, 0x1ebd, 0x1ebc,
    UnicodeLatinMap::AT_tilde, 0 },
  { 0x0117, UnicodeLatinMap::CT_lower, 'e', 0, 0x0117, 0x0116,
    UnicodeLatinMap::AT_dot_above, 0 },
  { 0x0116, UnicodeLatinMap::CT_upper, 'E', 0, 0x0117, 0x0116,
    UnicodeLatinMap::AT_dot_above, 0 },
  { 0x0229, UnicodeLatinMap::CT_lower, 'e', 0, 0x0229, 0x0228,
    UnicodeLatinMap::AT_cedilla, 0 },
  { 0x0228, UnicodeLatinMap::CT_upper, 'E', 0, 0x0229, 0x0228,
    UnicodeLatinMap::AT_cedilla, 0 },
  { 0x1e1d, UnicodeLatinMap::CT_lower, 'e', 0, 0x1e1d, 0x1e1c,
    UnicodeLatinMap::AT_cedilla_and_breve, 0 },
  { 0x1e1c, UnicodeLatinMap::CT_upper, 'E', 0, 0x1e1d, 0x1e1c,
    UnicodeLatinMap::AT_cedilla_and_breve, 0 },
  { 0x0119, UnicodeLatinMap::CT_lower, 'e', 0, 0x0119, 0x0118,
    UnicodeLatinMap::AT_ogonek, 0 },
  { 0x0118, UnicodeLatinMap::CT_upper, 'E', 0, 0x0119, 0x0118,
    UnicodeLatinMap::AT_ogonek, 0 },
  { 0x0113, UnicodeLatinMap::CT_lower, 'e', 0, 0x0113, 0x0112,
    UnicodeLatinMap::AT_macron, 0 },
  { 0x0112, UnicodeLatinMap::CT_upper, 'E', 0, 0x0113, 0x0112,
    UnicodeLatinMap::AT_macron, 0 },
  { 0x1e17, UnicodeLatinMap::CT_lower, 'e', 0, 0x1e17, 0x1e16,
    UnicodeLatinMap::AT_macron_and_acute, 0 },
  { 0x1e16, UnicodeLatinMap::CT_upper, 'E', 0, 0x1e17, 0x1e16,
    UnicodeLatinMap::AT_macron_and_acute, 0 },
  { 0x1e15, UnicodeLatinMap::CT_lower, 'e', 0, 0x1e15, 0x1e14,
    UnicodeLatinMap::AT_macron_and_grave, 0 },
  { 0x1e14, UnicodeLatinMap::CT_upper, 'E', 0, 0x1e15, 0x1e14,
    UnicodeLatinMap::AT_macron_and_grave, 0 },
  { 0x1ebb, UnicodeLatinMap::CT_lower, 'e', 0, 0x1ebb, 0x1eba,
    UnicodeLatinMap::AT_hook_above, 0 },
  { 0x1eba, UnicodeLatinMap::CT_upper, 'E', 0, 0x1ebb, 0x1eba,
    UnicodeLatinMap::AT_hook_above, 0 },
  { 0x0205, UnicodeLatinMap::CT_lower, 'e', 0, 0x0205, 0x0204,
    UnicodeLatinMap::AT_double_grave, 0 },
  { 0x0204, UnicodeLatinMap::CT_upper, 'E', 0, 0x0205, 0x0204,
    UnicodeLatinMap::AT_double_grave, 0 },
  { 0x0207, UnicodeLatinMap::CT_lower, 'e', 0, 0x0207, 0x0206,
    UnicodeLatinMap::AT_inverted_breve, 0 },
  { 0x0206, UnicodeLatinMap::CT_upper, 'E', 0, 0x0207, 0x0206,
    UnicodeLatinMap::AT_inverted_breve, 0 },
  { 0x1eb9, UnicodeLatinMap::CT_lower, 'e', 0, 0x1eb9, 0x1eb8,
    UnicodeLatinMap::AT_dot_below, 0 },
  { 0x1eb8, UnicodeLatinMap::CT_upper, 'E', 0, 0x1eb9, 0x1eb8,
    UnicodeLatinMap::AT_dot_below, 0 },
  { 0x1ec7, UnicodeLatinMap::CT_lower, 'e', 0, 0x1ec7, 0x1ec6,
    UnicodeLatinMap::AT_circumflex_and_dot_below, 0 },
  { 0x1ec6, UnicodeLatinMap::CT_upper, 'E', 0, 0x1ec7, 0x1ec6,
    UnicodeLatinMap::AT_circumflex_and_dot_below, 0 },
  { 0x1e19, UnicodeLatinMap::CT_lower, 'e', 0, 0x1e19, 0x1e18,
    UnicodeLatinMap::AT_circumflex_below, 0 },
  { 0x1e18, UnicodeLatinMap::CT_upper, 'E', 0, 0x1e19, 0x1e18,
    UnicodeLatinMap::AT_circumflex_below, 0 },
  { 0x1e1b, UnicodeLatinMap::CT_lower, 'e', 0, 0x1e1b, 0x1e1a,
    UnicodeLatinMap::AT_tilde_below, 0 },
  { 0x1e1a, UnicodeLatinMap::CT_upper, 'E', 0, 0x1e1b, 0x1e1a,
    UnicodeLatinMap::AT_tilde_below, 0 },
  { 0x01dd, UnicodeLatinMap::CT_lower, 'e', 0, 0x01dd, 0x0045,
    UnicodeLatinMap::AT_none, UnicodeLatinMap::AF_turned },
  { 0x018e, UnicodeLatinMap::CT_upper, 'E', 0, 0x0258, 0x018e,
    UnicodeLatinMap::AT_none, UnicodeLatinMap::AF_reversed },
  { 0x0258, UnicodeLatinMap::CT_lower, 'e', 0, 0x0258, 0x018e,
    UnicodeLatinMap::AT_none, UnicodeLatinMap::AF_reversed },
  { 0x0259, UnicodeLatinMap::CT_lower, 'e', 0, 0x0259, 0x018f,
    UnicodeLatinMap::AT_none, UnicodeLatinMap::AF_turned },
  { 0x0066, UnicodeLatinMap::CT_lower, 'f', 0, 0x0066, 0x0046,
    UnicodeLatinMap::AT_none, 0 },
  { 0x0046, UnicodeLatinMap::CT_upper, 'F', 0, 0x0066, 0x0046,
    UnicodeLatinMap::AT_none, 0 },
  { 0x1e1f, UnicodeLatinMap::CT_lower, 'f', 0, 0x1e1f, 0x1e1e,
    UnicodeLatinMap::AT_dot_above, 0 },
  { 0x1e1e, UnicodeLatinMap::CT_upper, 'F', 0, 0x1e1f, 0x1e1e,
    UnicodeLatinMap::AT_dot_above, 0 },
  { 0x0192, UnicodeLatinMap::CT_lower, 'f', 0, 0x0192, 0x0191,
    UnicodeLatinMap::AT_hook, 0 },
  { 0x0191, UnicodeLatinMap::CT_upper, 'F', 0, 0x0192, 0x0191,
    UnicodeLatinMap::AT_hook, 0 },
  { 0x0067, UnicodeLatinMap::CT_lower, 'g', 0, 0x0067, 0x0047,
    UnicodeLatinMap::AT_none, 0 },
  { 0x0047, UnicodeLatinMap::CT_upper, 'G', 0, 0x0067, 0x0047,
    UnicodeLatinMap::AT_none, 0 },
  { 0x01f5, UnicodeLatinMap::CT_lower, 'g', 0, 0x01f5, 0x01f4,
    UnicodeLatinMap::AT_acute, 0 },
  { 0x01f4, UnicodeLatinMap::CT_upper, 'G', 0, 0x01f5, 0x01f4,
    UnicodeLatinMap::AT_acute, 0 },
  { 0x011f, UnicodeLatinMap::CT_lower, 'g', 0, 0x011f, 0x011e,
    UnicodeLatinMap::AT_breve, 0 },
  { 0x011e, UnicodeLatinMap::CT_upper, 'G', 0, 0x011f, 0x011e,
    UnicodeLatinMap::AT_breve, 0 },
  { 0x011d, UnicodeLatinMap::CT_lower, 'g', 0, 0x011d, 0x011c,
    UnicodeLatinMap::AT_circumflex, 0 },
  { 0x011c, UnicodeLatinMap::CT_upper, 'G', 0, 0x011d, 0x011c,
    UnicodeLatinMap::AT_circumflex, 0 },
  { 0x01e7, UnicodeLatinMap::CT_lower, 'g', 0, 0x01e7, 0x01e6,
    UnicodeLatinMap::AT_caron, 0 },
  { 0x01e6, UnicodeLatinMap::CT_upper, 'G', 0, 0x01e7, 0x01e6,
    UnicodeLatinMap::AT_caron, 0 },
  { 0x0121, UnicodeLatinMap::CT_lower, 'g', 0, 0x0121, 0x0120,
    UnicodeLatinMap::AT_dot_above, 0 },
  { 0x0120, UnicodeLatinMap::CT_upper, 'G', 0, 0x0121, 0x0120,
    UnicodeLatinMap::AT_dot_above, 0 },
  { 0x0123, UnicodeLatinMap::CT_lower, 'g', 0, 0x0123, 0x0122,
    UnicodeLatinMap::AT_cedilla, 0 },
  { 0x0122, UnicodeLatinMap::CT_upper, 'G', 0, 0x0123, 0x0122,
    UnicodeLatinMap::AT_cedilla, 0 },
  { 0x1e21, UnicodeLatinMap::CT_lower, 'g', 0, 0x1e21, 0x1e20,
    UnicodeLatinMap::AT_macron, 0 },
  { 0x1e20, UnicodeLatinMap::CT_upper, 'G', 0, 0x1e21, 0x1e20,
    UnicodeLatinMap::AT_macron, 0 },
  { 0x0262, UnicodeLatinMap::CT_upper, 'G', 0, 0x0067, 0x0262,
    UnicodeLatinMap::AT_none, UnicodeLatinMap::AF_smallcap },
  { 0x01e5, UnicodeLatinMap::CT_lower, 'g', 0, 0x01e5, 0x01e4,
    UnicodeLatinMap::AT_stroke, 0 },
  { 0x01e4, UnicodeLatinMap::CT_upper, 'G', 0, 0x01e5, 0x01e4,
    UnicodeLatinMap::AT_stroke, 0 },
  { 0x0260, UnicodeLatinMap::CT_lower, 'g', 0, 0x0260, 0x0193,
    UnicodeLatinMap::AT_hook, 0 },
  { 0x0193, UnicodeLatinMap::CT_upper, 'G', 0, 0x0260, 0x0193,
    UnicodeLatinMap::AT_hook, 0 },
  { 0x029b, UnicodeLatinMap::CT_upper, 'G', 0, 0x0067, 0x029b,
    UnicodeLatinMap::AT_hook, UnicodeLatinMap::AF_smallcap },
  { 0x01a3, UnicodeLatinMap::CT_lower, 'o', 'i', 0x01a3, 0x01a2,
    UnicodeLatinMap::AT_none, UnicodeLatinMap::AF_ligature },
  { 0x01a2, UnicodeLatinMap::CT_upper, 'O', 'I', 0x01a3, 0x01a2,
    UnicodeLatinMap::AT_none, UnicodeLatinMap::AF_ligature },
  { 0x0068, UnicodeLatinMap::CT_lower, 'h', 0, 0x0068, 0x0048,
    UnicodeLatinMap::AT_none, 0 },
  { 0x0048, UnicodeLatinMap::CT_upper, 'H', 0, 0x0068, 0x0048,
    UnicodeLatinMap::AT_none, 0 },
  { 0x0125, UnicodeLatinMap::CT_lower, 'h', 0, 0x0125, 0x0124,
    UnicodeLatinMap::AT_circumflex, 0 },
  { 0x0124, UnicodeLatinMap::CT_upper, 'H', 0, 0x0125, 0x0124,
    UnicodeLatinMap::AT_circumflex, 0 },
  { 0x021f, UnicodeLatinMap::CT_lower, 'h', 0, 0x021f, 0x021e,
    UnicodeLatinMap::AT_caron, 0 },
  { 0x021e, UnicodeLatinMap::CT_upper, 'H', 0, 0x021f, 0x021e,
    UnicodeLatinMap::AT_caron, 0 },
  { 0x1e27, UnicodeLatinMap::CT_lower, 'h', 0, 0x1e27, 0x1e26,
    UnicodeLatinMap::AT_diaeresis, 0 },
  { 0x1e26, UnicodeLatinMap::CT_upper, 'H', 0, 0x1e27, 0x1e26,
    UnicodeLatinMap::AT_diaeresis, 0 },
  { 0x1e23, UnicodeLatinMap::CT_lower, 'h', 0, 0x1e23, 0x1e22,
    UnicodeLatinMap::AT_dot_above, 0 },
  { 0x1e22, UnicodeLatinMap::CT_upper, 'H', 0, 0x1e23, 0x1e22,
    UnicodeLatinMap::AT_dot_above, 0 },
  { 0x1e29, UnicodeLatinMap::CT_lower, 'h', 0, 0x1e29, 0x1e28,
    UnicodeLatinMap::AT_cedilla, 0 },
  { 0x1e28, UnicodeLatinMap::CT_upper, 'H', 0, 0x1e29, 0x1e28,
    UnicodeLatinMap::AT_cedilla, 0 },
  { 0x1e25, UnicodeLatinMap::CT_lower, 'h', 0, 0x1e25, 0x1e24,
    UnicodeLatinMap::AT_dot_below, 0 },
  { 0x1e24, UnicodeLatinMap::CT_upper, 'H', 0, 0x1e25, 0x1e24,
    UnicodeLatinMap::AT_dot_below, 0 },
  { 0x1e2b, UnicodeLatinMap::CT_lower, 'h', 0, 0x1e2b, 0x1e2a,
    UnicodeLatinMap::AT_breve_below, 0 },
  { 0x1e2a, UnicodeLatinMap::CT_upper, 'H', 0, 0x1e2b, 0x1e2a,
    UnicodeLatinMap::AT_breve_below, 0 },
  { 0x1e96, UnicodeLatinMap::CT_lower, 'h', 0, 0x1e96, 0x0048,
    UnicodeLatinMap::AT_line_below, 0 },
  { 0x029c, UnicodeLatinMap::CT_upper, 'H', 0, 0x0068, 0x029c,
    UnicodeLatinMap::AT_none, UnicodeLatinMap::AF_smallcap },
  { 0x0195, UnicodeLatinMap::CT_lower, 'h', 'v', 0x0195, 0x01f6,
    UnicodeLatinMap::AT_none, UnicodeLatinMap::AF_ligature },
  { 0x01f6, UnicodeLatinMap::CT_upper, 'H', 'v', 0x0195, 0x01f6,
    UnicodeLatinMap::AT_none, UnicodeLatinMap::AF_ligature },
  { 0x0127, UnicodeLatinMap::CT_lower, 'h', 0, 0x0127, 0x0126,
    UnicodeLatinMap::AT_stroke, 0 },
  { 0x0126, UnicodeLatinMap::CT_upper, 'H', 0, 0x0127, 0x0126,
    UnicodeLatinMap::AT_stroke, 0 },
  { 0x0266, UnicodeLatinMap::CT_lower, 'h', 0, 0x0266, 0x0048,
    UnicodeLatinMap::AT_hook, 0 },
  { 0x0069, UnicodeLatinMap::CT_lower, 'i', 0, 0x0069, 0x0049,
    UnicodeLatinMap::AT_none, 0 },
  { 0x0049, UnicodeLatinMap::CT_upper, 'I', 0, 0x0069, 0x0049,
    UnicodeLatinMap::AT_none, 0 },
  { 0x00ed, UnicodeLatinMap::CT_lower, 'i', 0, 0x00ed, 0x00cd,
    UnicodeLatinMap::AT_acute, 0 },
  { 0x00cd, UnicodeLatinMap::CT_upper, 'I', 0, 0x00ed, 0x00cd,
    UnicodeLatinMap::AT_acute, 0 },
  { 0x00ec, UnicodeLatinMap::CT_lower, 'i', 0, 0x00ec, 0x00cc,
    UnicodeLatinMap::AT_grave, 0 },
  { 0x00cc, UnicodeLatinMap::CT_upper, 'I', 0, 0x00ec, 0x00cc,
    UnicodeLatinMap::AT_grave, 0 },
  { 0x012d, UnicodeLatinMap::CT_lower, 'i', 0, 0x012d, 0x012c,
    UnicodeLatinMap::AT_breve, 0 },
  { 0x012c, UnicodeLatinMap::CT_upper, 'I', 0, 0x012d, 0x012c,
    UnicodeLatinMap::AT_breve, 0 },
  { 0x00ee, UnicodeLatinMap::CT_lower, 'i', 0, 0x00ee, 0x00ce,
    UnicodeLatinMap::AT_circumflex, 0 },
  { 0x00ce, UnicodeLatinMap::CT_upper, 'I', 0, 0x00ee, 0x00ce,
    UnicodeLatinMap::AT_circumflex, 0 },
  { 0x01d0, UnicodeLatinMap::CT_lower, 'i', 0, 0x01d0, 0x01cf,
    UnicodeLatinMap::AT_caron, 0 },
  { 0x01cf, UnicodeLatinMap::CT_upper, 'I', 0, 0x01d0, 0x01cf,
    UnicodeLatinMap::AT_caron, 0 },
  { 0x00ef, UnicodeLatinMap::CT_lower, 'i', 0, 0x00ef, 0x00cf,
    UnicodeLatinMap::AT_diaeresis, 0 },
  { 0x00cf, UnicodeLatinMap::CT_upper, 'I', 0, 0x00ef, 0x00cf,
    UnicodeLatinMap::AT_diaeresis, 0 },
  { 0x1e2f, UnicodeLatinMap::CT_lower, 'i', 0, 0x1e2f, 0x1e2e,
    UnicodeLatinMap::AT_diaeresis_and_acute, 0 },
  { 0x1e2e, UnicodeLatinMap::CT_upper, 'I', 0, 0x1e2f, 0x1e2e,
    UnicodeLatinMap::AT_diaeresis_and_acute, 0 },
  { 0x0129, UnicodeLatinMap::CT_lower, 'i', 0, 0x0129, 0x0128,
    UnicodeLatinMap::AT_tilde, 0 },
  { 0x0128, UnicodeLatinMap::CT_upper, 'I', 0, 0x0129, 0x0128,
    UnicodeLatinMap::AT_tilde, 0 },
  { 0x0130, UnicodeLatinMap::CT_upper, 'I', 0, 0x0069, 0x0130,
    UnicodeLatinMap::AT_dot_above, 0 },
  { 0x012f, UnicodeLatinMap::CT_lower, 'i', 0, 0x012f, 0x012e,
    UnicodeLatinMap::AT_ogonek, 0 },
  { 0x012e, UnicodeLatinMap::CT_upper, 'I', 0, 0x012f, 0x012e,
    UnicodeLatinMap::AT_ogonek, 0 },
  { 0x012b, UnicodeLatinMap::CT_lower, 'i', 0, 0x012b, 0x012a,
    UnicodeLatinMap::AT_macron, 0 },
  { 0x012a, UnicodeLatinMap::CT_upper, 'I', 0, 0x012b, 0x012a,
    UnicodeLatinMap::AT_macron, 0 },
  { 0x1ec9, UnicodeLatinMap::CT_lower, 'i', 0, 0x1ec9, 0x1ec8,
    UnicodeLatinMap::AT_hook_above, 0 },
  { 0x1ec8, UnicodeLatinMap::CT_upper, 'I', 0, 0x1ec9, 0x1ec8,
    UnicodeLatinMap::AT_hook_above, 0 },
  { 0x0209, UnicodeLatinMap::CT_lower, 'i', 0, 0x0209, 0x0208,
    UnicodeLatinMap::AT_double_grave, 0 },
  { 0x0208, UnicodeLatinMap::CT_upper, 'I', 0, 0x0209, 0x0208,
    UnicodeLatinMap::AT_double_grave, 0 },
  { 0x020b, UnicodeLatinMap::CT_lower, 'i', 0, 0x020b, 0x020a,
    UnicodeLatinMap::AT_inverted_breve, 0 },
  { 0x020a, UnicodeLatinMap::CT_upper, 'I', 0, 0x020b, 0x020a,
    UnicodeLatinMap::AT_inverted_breve, 0 },
  { 0x1ecb, UnicodeLatinMap::CT_lower, 'i', 0, 0x1ecb, 0x1eca,
    UnicodeLatinMap::AT_dot_below, 0 },
  { 0x1eca, UnicodeLatinMap::CT_upper, 'I', 0, 0x1ecb, 0x1eca,
    UnicodeLatinMap::AT_dot_below, 0 },
  { 0x1e2d, UnicodeLatinMap::CT_lower, 'i', 0, 0x1e2d, 0x1e2c,
    UnicodeLatinMap::AT_tilde_below, 0 },
  { 0x1e2c, UnicodeLatinMap::CT_upper, 'I', 0, 0x1e2d, 0x1e2c,
    UnicodeLatinMap::AT_tilde_below, 0 },
  { 0x0131, UnicodeLatinMap::CT_lower, 'i', 0, 0x0131, 0x0049,
    UnicodeLatinMap::AT_none, UnicodeLatinMap::AF_dotless },
  { 0x026a, UnicodeLatinMap::CT_upper, 'I', 0, 0x0069, 0x026a,
    UnicodeLatinMap::AT_none, UnicodeLatinMap::AF_smallcap },
  { 0x0268, UnicodeLatinMap::CT_lower, 'i', 0, 0x0268, 0x0197,
    UnicodeLatinMap::AT_stroke, 0 },
  { 0x0197, UnicodeLatinMap::CT_upper, 'I', 0, 0x0268, 0x0197,
    UnicodeLatinMap::AT_stroke, 0 },
  { 0x006a, UnicodeLatinMap::CT_lower, 'j', 0, 0x006a, 0x004a,
    UnicodeLatinMap::AT_none, 0 },
  { 0x004a, UnicodeLatinMap::CT_upper, 'J', 0, 0x006a, 0x004a,
    UnicodeLatinMap::AT_none, 0 },
  { 0x0135, UnicodeLatinMap::CT_lower, 'j', 0, 0x0135, 0x0134,
    UnicodeLatinMap::AT_circumflex, 0 },
  { 0x0134, UnicodeLatinMap::CT_upper, 'J', 0, 0x0135, 0x0134,
    UnicodeLatinMap::AT_circumflex, 0 },
  { 0x01f0, UnicodeLatinMap::CT_lower, 'j', 0, 0x01f0, 0x004a,
    UnicodeLatinMap::AT_caron, 0 },
  { 0x025f, UnicodeLatinMap::CT_lower, 'j', 0, 0x025f, 0x004a,
    UnicodeLatinMap::AT_stroke, UnicodeLatinMap::AF_dotless },
  { 0x0284, UnicodeLatinMap::CT_lower, 'j', 0, 0x0284, 0x004a,
    UnicodeLatinMap::AT_stroke_and_hook, UnicodeLatinMap::AF_dotless },
  { 0x006b, UnicodeLatinMap::CT_lower, 'k', 0, 0x006b, 0x004b,
    UnicodeLatinMap::AT_none, 0 },
  { 0x004b, UnicodeLatinMap::CT_upper, 'K', 0, 0x006b, 0x004b,
    UnicodeLatinMap::AT_none, 0 },
  { 0x1e31, UnicodeLatinMap::CT_lower, 'k', 0, 0x1e31, 0x1e30,
    UnicodeLatinMap::AT_acute, 0 },
  { 0x1e30, UnicodeLatinMap::CT_upper, 'K', 0, 0x1e31, 0x1e30,
    UnicodeLatinMap::AT_acute, 0 },
  { 0x01e9, UnicodeLatinMap::CT_lower, 'k', 0, 0x01e9, 0x01e8,
    UnicodeLatinMap::AT_caron, 0 },
  { 0x01e8, UnicodeLatinMap::CT_upper, 'K', 0, 0x01e9, 0x01e8,
    UnicodeLatinMap::AT_caron, 0 },
  { 0x0137, UnicodeLatinMap::CT_lower, 'k', 0, 0x0137, 0x0136,
    UnicodeLatinMap::AT_cedilla, 0 },
  { 0x0136, UnicodeLatinMap::CT_upper, 'K', 0, 0x0137, 0x0136,
    UnicodeLatinMap::AT_cedilla, 0 },
  { 0x1e33, UnicodeLatinMap::CT_lower, 'k', 0, 0x1e33, 0x1e32,
    UnicodeLatinMap::AT_dot_below, 0 },
  { 0x1e32, UnicodeLatinMap::CT_upper, 'K', 0, 0x1e33, 0x1e32,
    UnicodeLatinMap::AT_dot_below, 0 },
  { 0x1e35, UnicodeLatinMap::CT_lower, 'k', 0, 0x1e35, 0x1e34,
    UnicodeLatinMap::AT_line_below, 0 },
  { 0x1e34, UnicodeLatinMap::CT_upper, 'K', 0, 0x1e35, 0x1e34,
    UnicodeLatinMap::AT_line_below, 0 },
  { 0x0199, UnicodeLatinMap::CT_lower, 'k', 0, 0x0199, 0x0198,
    UnicodeLatinMap::AT_hook, 0 },
  { 0x0198, UnicodeLatinMap::CT_upper, 'K', 0, 0x0199, 0x0198,
    UnicodeLatinMap::AT_hook, 0 },
  { 0x029e, UnicodeLatinMap::CT_lower, 'k', 0, 0x029e, 0x004b,
    UnicodeLatinMap::AT_none, UnicodeLatinMap::AF_turned },
  { 0x006c, UnicodeLatinMap::CT_lower, 'l', 0, 0x006c, 0x004c,
    UnicodeLatinMap::AT_none, 0 },
  { 0x004c, UnicodeLatinMap::CT_upper, 'L', 0, 0x006c, 0x004c,
    UnicodeLatinMap::AT_none, 0 },
  { 0x013a, UnicodeLatinMap::CT_lower, 'l', 0, 0x013a, 0x0139,
    UnicodeLatinMap::AT_acute, 0 },
  { 0x0139, UnicodeLatinMap::CT_upper, 'L', 0, 0x013a, 0x0139,
    UnicodeLatinMap::AT_acute, 0 },
  { 0x013e, UnicodeLatinMap::CT_lower, 'l', 0, 0x013e, 0x013d,
    UnicodeLatinMap::AT_caron, 0 },
  { 0x013d, UnicodeLatinMap::CT_upper, 'L', 0, 0x013e, 0x013d,
    UnicodeLatinMap::AT_caron, 0 },
  { 0x013c, UnicodeLatinMap::CT_lower, 'l', 0, 0x013c, 0x013b,
    UnicodeLatinMap::AT_cedilla, 0 },
  { 0x013b, UnicodeLatinMap::CT_upper, 'L', 0, 0x013c, 0x013b,
    UnicodeLatinMap::AT_cedilla, 0 },
  { 0x1e37, UnicodeLatinMap::CT_lower, 'l', 0, 0x1e37, 0x1e36,
    UnicodeLatinMap::AT_dot_below, 0 },
  { 0x1e36, UnicodeLatinMap::CT_upper, 'L', 0, 0x1e37, 0x1e36,
    UnicodeLatinMap::AT_dot_below, 0 },
  { 0x1e39, UnicodeLatinMap::CT_lower, 'l', 0, 0x1e39, 0x1e38,
    UnicodeLatinMap::AT_dot_below_and_macron, 0 },
  { 0x1e38, UnicodeLatinMap::CT_upper, 'L', 0, 0x1e39, 0x1e38,
    UnicodeLatinMap::AT_dot_below_and_macron, 0 },
  { 0x1e3d, UnicodeLatinMap::CT_lower, 'l', 0, 0x1e3d, 0x1e3c,
    UnicodeLatinMap::AT_circumflex_below, 0 },
  { 0x1e3c, UnicodeLatinMap::CT_upper, 'L', 0, 0x1e3d, 0x1e3c,
    UnicodeLatinMap::AT_circumflex_below, 0 },
  { 0x1e3b, UnicodeLatinMap::CT_lower, 'l', 0, 0x1e3b, 0x1e3a,
    UnicodeLatinMap::AT_line_below, 0 },
  { 0x1e3a, UnicodeLatinMap::CT_upper, 'L', 0, 0x1e3b, 0x1e3a,
    UnicodeLatinMap::AT_line_below, 0 },
  { 0x01c9, UnicodeLatinMap::CT_lower, 'l', 'j', 0x01c9, 0x01c7,
    UnicodeLatinMap::AT_none, UnicodeLatinMap::AF_ligature },
  { 0x01c8, UnicodeLatinMap::CT_upper, 'L', 'j', 0x01c9, 0x01c7,
    UnicodeLatinMap::AT_none, UnicodeLatinMap::AF_ligature },
  { 0x01c7, UnicodeLatinMap::CT_upper, 'L', 'J', 0x01c9, 0x01c7,
    UnicodeLatinMap::AT_none, UnicodeLatinMap::AF_ligature },
  { 0x029f, UnicodeLatinMap::CT_upper, 'L', 0, 0x006c, 0x029f,
    UnicodeLatinMap::AT_none, UnicodeLatinMap::AF_smallcap },
  { 0x0142, UnicodeLatinMap::CT_lower, 'l', 0, 0x0142, 0x0141,
    UnicodeLatinMap::AT_stroke, 0 },
  { 0x0141, UnicodeLatinMap::CT_upper, 'L', 0, 0x0142, 0x0141,
    UnicodeLatinMap::AT_stroke, 0 },
  { 0x028e, UnicodeLatinMap::CT_lower, 'y', 0, 0x028e, 0x0059,
    UnicodeLatinMap::AT_none, UnicodeLatinMap::AF_turned },
  { 0x006d, UnicodeLatinMap::CT_lower, 'm', 0, 0x006d, 0x004d,
    UnicodeLatinMap::AT_none, 0 },
  { 0x004d, UnicodeLatinMap::CT_upper, 'M', 0, 0x006d, 0x004d,
    UnicodeLatinMap::AT_none, 0 },
  { 0x1e3f, UnicodeLatinMap::CT_lower, 'm', 0, 0x1e3f, 0x1e3e,
    UnicodeLatinMap::AT_acute, 0 },
  { 0x1e3e, UnicodeLatinMap::CT_upper, 'M', 0, 0x1e3f, 0x1e3e,
    UnicodeLatinMap::AT_acute, 0 },
  { 0x1e41, UnicodeLatinMap::CT_lower, 'm', 0, 0x1e41, 0x1e40,
    UnicodeLatinMap::AT_dot_above, 0 },
  { 0x1e40, UnicodeLatinMap::CT_upper, 'M', 0, 0x1e41, 0x1e40,
    UnicodeLatinMap::AT_dot_above, 0 },
  { 0x1e43, UnicodeLatinMap::CT_lower, 'm', 0, 0x1e43, 0x1e42,
    UnicodeLatinMap::AT_dot_below, 0 },
  { 0x1e42, UnicodeLatinMap::CT_upper, 'M', 0, 0x1e43, 0x1e42,
    UnicodeLatinMap::AT_dot_below, 0 },
  { 0x0271, UnicodeLatinMap::CT_lower, 'm', 0, 0x0271, 0x004d,
    UnicodeLatinMap::AT_hook, 0 },
  { 0x006e, UnicodeLatinMap::CT_lower, 'n', 0, 0x006e, 0x004e,
    UnicodeLatinMap::AT_none, 0 },
  { 0x004e, UnicodeLatinMap::CT_upper, 'N', 0, 0x006e, 0x004e,
    UnicodeLatinMap::AT_none, 0 },
  { 0x0144, UnicodeLatinMap::CT_lower, 'n', 0, 0x0144, 0x0143,
    UnicodeLatinMap::AT_acute, 0 },
  { 0x0143, UnicodeLatinMap::CT_upper, 'N', 0, 0x0144, 0x0143,
    UnicodeLatinMap::AT_acute, 0 },
  { 0x01f9, UnicodeLatinMap::CT_lower, 'n', 0, 0x01f9, 0x01f8,
    UnicodeLatinMap::AT_grave, 0 },
  { 0x01f8, UnicodeLatinMap::CT_upper, 'N', 0, 0x01f9, 0x01f8,
    UnicodeLatinMap::AT_grave, 0 },
  { 0x0148, UnicodeLatinMap::CT_lower, 'n', 0, 0x0148, 0x0147,
    UnicodeLatinMap::AT_caron, 0 },
  { 0x0147, UnicodeLatinMap::CT_upper, 'N', 0, 0x0148, 0x0147,
    UnicodeLatinMap::AT_caron, 0 },
  { 0x00f1, UnicodeLatinMap::CT_lower, 'n', 0, 0x00f1, 0x00d1,
    UnicodeLatinMap::AT_tilde, 0 },
  { 0x00d1, UnicodeLatinMap::CT_upper, 'N', 0, 0x00f1, 0x00d1,
    UnicodeLatinMap::AT_tilde, 0 },
  { 0x1e45, UnicodeLatinMap::CT_lower, 'n', 0, 0x1e45, 0x1e44,
    UnicodeLatinMap::AT_dot_above, 0 },
  { 0x1e44, UnicodeLatinMap::CT_upper, 'N', 0, 0x1e45, 0x1e44,
    UnicodeLatinMap::AT_dot_above, 0 },
  { 0x0146, UnicodeLatinMap::CT_lower, 'n', 0, 0x0146, 0x0145,
    UnicodeLatinMap::AT_cedilla, 0 },
  { 0x0145, UnicodeLatinMap::CT_upper, 'N', 0, 0x0146, 0x0145,
    UnicodeLatinMap::AT_cedilla, 0 },
  { 0x1e47, UnicodeLatinMap::CT_lower, 'n', 0, 0x1e47, 0x1e46,
    UnicodeLatinMap::AT_dot_below, 0 },
  { 0x1e46, UnicodeLatinMap::CT_upper, 'N', 0, 0x1e47, 0x1e46,
    UnicodeLatinMap::AT_dot_below, 0 },
  { 0x1e4b, UnicodeLatinMap::CT_lower, 'n', 0, 0x1e4b, 0x1e4a,
    UnicodeLatinMap::AT_circumflex_below, 0 },
  { 0x1e4a, UnicodeLatinMap::CT_upper, 'N', 0, 0x1e4b, 0x1e4a,
    UnicodeLatinMap::AT_circumflex_below, 0 },
  { 0x1e49, UnicodeLatinMap::CT_lower, 'n', 0, 0x1e49, 0x1e48,
    UnicodeLatinMap::AT_line_below, 0 },
  { 0x1e48, UnicodeLatinMap::CT_upper, 'N', 0, 0x1e49, 0x1e48,
    UnicodeLatinMap::AT_line_below, 0 },
  { 0x01cc, UnicodeLatinMap::CT_lower, 'n', 'j', 0x01cc, 0x01ca,
    UnicodeLatinMap::AT_none, UnicodeLatinMap::AF_ligature },
  { 0x01cb, UnicodeLatinMap::CT_upper, 'N', 'j', 0x01cc, 0x01ca,
    UnicodeLatinMap::AT_none, UnicodeLatinMap::AF_ligature },
  { 0x01ca, UnicodeLatinMap::CT_upper, 'N', 'J', 0x01cc, 0x01ca,
    UnicodeLatinMap::AT_none, UnicodeLatinMap::AF_ligature },
  { 0x0274, UnicodeLatinMap::CT_upper, 'N', 0, 0x006e, 0x0274,
    UnicodeLatinMap::AT_none, UnicodeLatinMap::AF_smallcap },
  { 0x006f, UnicodeLatinMap::CT_lower, 'o', 0, 0x006f, 0x004f,
    UnicodeLatinMap::AT_none, 0 },
  { 0x004f, UnicodeLatinMap::CT_upper, 'O', 0, 0x006f, 0x004f,
    UnicodeLatinMap::AT_none, 0 },
  { 0x00f3, UnicodeLatinMap::CT_lower, 'o', 0, 0x00f3, 0x00d3,
    UnicodeLatinMap::AT_acute, 0 },
  { 0x00d3, UnicodeLatinMap::CT_upper, 'O', 0, 0x00f3, 0x00d3,
    UnicodeLatinMap::AT_acute, 0 },
  { 0x00f2, UnicodeLatinMap::CT_lower, 'o', 0, 0x00f2, 0x00d2,
    UnicodeLatinMap::AT_grave, 0 },
  { 0x00d2, UnicodeLatinMap::CT_upper, 'O', 0, 0x00f2, 0x00d2,
    UnicodeLatinMap::AT_grave, 0 },
  { 0x014f, UnicodeLatinMap::CT_lower, 'o', 0, 0x014f, 0x014e,
    UnicodeLatinMap::AT_breve, 0 },
  { 0x014e, UnicodeLatinMap::CT_upper, 'O', 0, 0x014f, 0x014e,
    UnicodeLatinMap::AT_breve, 0 },
  { 0x00f4, UnicodeLatinMap::CT_lower, 'o', 0, 0x00f4, 0x00d4,
    UnicodeLatinMap::AT_circumflex, 0 },
  { 0x00d4, UnicodeLatinMap::CT_upper, 'O', 0, 0x00f4, 0x00d4,
    UnicodeLatinMap::AT_circumflex, 0 },
  { 0x1ed1, UnicodeLatinMap::CT_lower, 'o', 0, 0x1ed1, 0x1ed0,
    UnicodeLatinMap::AT_circumflex_and_acute, 0 },
  { 0x1ed0, UnicodeLatinMap::CT_upper, 'O', 0, 0x1ed1, 0x1ed0,
    UnicodeLatinMap::AT_circumflex_and_acute, 0 },
  { 0x1ed3, UnicodeLatinMap::CT_lower, 'o', 0, 0x1ed3, 0x1ed2,
    UnicodeLatinMap::AT_circumflex_and_grave, 0 },
  { 0x1ed2, UnicodeLatinMap::CT_upper, 'O', 0, 0x1ed3, 0x1ed2,
    UnicodeLatinMap::AT_circumflex_and_grave, 0 },
  { 0x1ed7, UnicodeLatinMap::CT_lower, 'o', 0, 0x1ed7, 0x1ed6,
    UnicodeLatinMap::AT_circumflex_and_tilde, 0 },
  { 0x1ed6, UnicodeLatinMap::CT_upper, 'O', 0, 0x1ed7, 0x1ed6,
    UnicodeLatinMap::AT_circumflex_and_tilde, 0 },
  { 0x1ed5, UnicodeLatinMap::CT_lower, 'o', 0, 0x1ed5, 0x1ed4,
    UnicodeLatinMap::AT_circumflex_and_hook_above, 0 },
  { 0x1ed4, UnicodeLatinMap::CT_upper, 'O', 0, 0x1ed5, 0x1ed4,
    UnicodeLatinMap::AT_circumflex_and_hook_above, 0 },
  { 0x01d2, UnicodeLatinMap::CT_lower, 'o', 0, 0x01d2, 0x01d1,
    UnicodeLatinMap::AT_caron, 0 },
  { 0x01d1, UnicodeLatinMap::CT_upper, 'O', 0, 0x01d2, 0x01d1,
    UnicodeLatinMap::AT_caron, 0 },
  { 0x00f6, UnicodeLatinMap::CT_lower, 'o', 0, 0x00f6, 0x00d6,
    UnicodeLatinMap::AT_diaeresis, 0 },
  { 0x00d6, UnicodeLatinMap::CT_upper, 'O', 0, 0x00f6, 0x00d6,
    UnicodeLatinMap::AT_diaeresis, 0 },
  { 0x022b, UnicodeLatinMap::CT_lower, 'o', 0, 0x022b, 0x022a,
    UnicodeLatinMap::AT_diaeresis_and_macron, 0 },
  { 0x022a, UnicodeLatinMap::CT_upper, 'O', 0, 0x022b, 0x022a,
    UnicodeLatinMap::AT_diaeresis_and_macron, 0 },
  { 0x0151, UnicodeLatinMap::CT_lower, 'o', 0, 0x0151, 0x0150,
    UnicodeLatinMap::AT_double_acute, 0 },
  { 0x0150, UnicodeLatinMap::CT_upper, 'O', 0, 0x0151, 0x0150,
    UnicodeLatinMap::AT_double_acute, 0 },
  { 0x00f5, UnicodeLatinMap::CT_lower, 'o', 0, 0x00f5, 0x00d5,
    UnicodeLatinMap::AT_tilde, 0 },
  { 0x00d5, UnicodeLatinMap::CT_upper, 'O', 0, 0x00f5, 0x00d5,
    UnicodeLatinMap::AT_tilde, 0 },
  { 0x1e4d, UnicodeLatinMap::CT_lower, 'o', 0, 0x1e4d, 0x1e4c,
    UnicodeLatinMap::AT_tilde_and_acute, 0 },
  { 0x1e4c, UnicodeLatinMap::CT_upper, 'O', 0, 0x1e4d, 0x1e4c,
    UnicodeLatinMap::AT_tilde_and_acute, 0 },
  { 0x1e4f, UnicodeLatinMap::CT_lower, 'o', 0, 0x1e4f, 0x1e4e,
    UnicodeLatinMap::AT_tilde_and_diaeresis, 0 },
  { 0x1e4e, UnicodeLatinMap::CT_upper, 'O', 0, 0x1e4f, 0x1e4e,
    UnicodeLatinMap::AT_tilde_and_diaeresis, 0 },
  { 0x022d, UnicodeLatinMap::CT_lower, 'o', 0, 0x022d, 0x022c,
    UnicodeLatinMap::AT_tilde_and_macron, 0 },
  { 0x022c, UnicodeLatinMap::CT_upper, 'O', 0, 0x022d, 0x022c,
    UnicodeLatinMap::AT_tilde_and_macron, 0 },
  { 0x022f, UnicodeLatinMap::CT_lower, 'o', 0, 0x022f, 0x022e,
    UnicodeLatinMap::AT_dot_above, 0 },
  { 0x022e, UnicodeLatinMap::CT_upper, 'O', 0, 0x022f, 0x022e,
    UnicodeLatinMap::AT_dot_above, 0 },
  { 0x0231, UnicodeLatinMap::CT_lower, 'o', 0, 0x0231, 0x0230,
    UnicodeLatinMap::AT_dot_above_and_macron, 0 },
  { 0x0230, UnicodeLatinMap::CT_upper, 'O', 0, 0x0231, 0x0230,
    UnicodeLatinMap::AT_dot_above_and_macron, 0 },
  { 0x01eb, UnicodeLatinMap::CT_lower, 'o', 0, 0x01eb, 0x01ea,
    UnicodeLatinMap::AT_ogonek, 0 },
  { 0x01ea, UnicodeLatinMap::CT_upper, 'O', 0, 0x01eb, 0x01ea,
    UnicodeLatinMap::AT_ogonek, 0 },
  { 0x01ed, UnicodeLatinMap::CT_lower, 'o', 0, 0x01ed, 0x01ec,
    UnicodeLatinMap::AT_ogonek_and_macron, 0 },
  { 0x01ec, UnicodeLatinMap::CT_upper, 'O', 0, 0x01ed, 0x01ec,
    UnicodeLatinMap::AT_ogonek_and_macron, 0 },
  { 0x014d, UnicodeLatinMap::CT_lower, 'o', 0, 0x014d, 0x014c,
    UnicodeLatinMap::AT_macron, 0 },
  { 0x014c, UnicodeLatinMap::CT_upper, 'O', 0, 0x014d, 0x014c,
    UnicodeLatinMap::AT_macron, 0 },
  { 0x1e53, UnicodeLatinMap::CT_lower, 'o', 0, 0x1e53, 0x1e52,
    UnicodeLatinMap::AT_macron_and_acute, 0 },
  { 0x1e52, UnicodeLatinMap::CT_upper, 'O', 0, 0x1e53, 0x1e52,
    UnicodeLatinMap::AT_macron_and_acute, 0 },
  { 0x1e51, UnicodeLatinMap::CT_lower, 'o', 0, 0x1e51, 0x1e50,
    UnicodeLatinMap::AT_macron_and_grave, 0 },
  { 0x1e50, UnicodeLatinMap::CT_upper, 'O', 0, 0x1e51, 0x1e50,
    UnicodeLatinMap::AT_macron_and_grave, 0 },
  { 0x1ecf, UnicodeLatinMap::CT_lower, 'o', 0, 0x1ecf, 0x1ece,
    UnicodeLatinMap::AT_hook_above, 0 },
  { 0x1ece, UnicodeLatinMap::CT_upper, 'O', 0, 0x1ecf, 0x1ece,
    UnicodeLatinMap::AT_hook_above, 0 },
  { 0x020d, UnicodeLatinMap::CT_lower, 'o', 0, 0x020d, 0x020c,
    UnicodeLatinMap::AT_double_grave, 0 },
  { 0x020c, UnicodeLatinMap::CT_upper, 'O', 0, 0x020d, 0x020c,
    UnicodeLatinMap::AT_double_grave, 0 },
  { 0x020f, UnicodeLatinMap::CT_lower, 'o', 0, 0x020f, 0x020e,
    UnicodeLatinMap::AT_inverted_breve, 0 },
  { 0x020e, UnicodeLatinMap::CT_upper, 'O', 0, 0x020f, 0x020e,
    UnicodeLatinMap::AT_inverted_breve, 0 },
  { 0x01a1, UnicodeLatinMap::CT_lower, 'o', 0, 0x01a1, 0x01a0,
    UnicodeLatinMap::AT_horn, 0 },
  { 0x01a0, UnicodeLatinMap::CT_upper, 'O', 0, 0x01a1, 0x01a0,
    UnicodeLatinMap::AT_horn, 0 },
  { 0x1edb, UnicodeLatinMap::CT_lower, 'o', 0, 0x1edb, 0x1eda,
    UnicodeLatinMap::AT_horn_and_acute, 0 },
  { 0x1eda, UnicodeLatinMap::CT_upper, 'O', 0, 0x1edb, 0x1eda,
    UnicodeLatinMap::AT_horn_and_acute, 0 },
  { 0x1edd, UnicodeLatinMap::CT_lower, 'o', 0, 0x1edd, 0x1edc,
    UnicodeLatinMap::AT_horn_and_grave, 0 },
  { 0x1edc, UnicodeLatinMap::CT_upper, 'O', 0, 0x1edd, 0x1edc,
    UnicodeLatinMap::AT_horn_and_grave, 0 },
  { 0x1ee1, UnicodeLatinMap::CT_lower, 'o', 0, 0x1ee1, 0x1ee0,
    UnicodeLatinMap::AT_horn_and_tilde, 0 },
  { 0x1ee0, UnicodeLatinMap::CT_upper, 'O', 0, 0x1ee1, 0x1ee0,
    UnicodeLatinMap::AT_horn_and_tilde, 0 },
  { 0x1edf, UnicodeLatinMap::CT_lower, 'o', 0, 0x1edf, 0x1ede,
    UnicodeLatinMap::AT_horn_and_hook_above, 0 },
  { 0x1ede, UnicodeLatinMap::CT_upper, 'O', 0, 0x1edf, 0x1ede,
    UnicodeLatinMap::AT_horn_and_hook_above, 0 },
  { 0x1ee3, UnicodeLatinMap::CT_lower, 'o', 0, 0x1ee3, 0x1ee2,
    UnicodeLatinMap::AT_horn_and_dot_below, 0 },
  { 0x1ee2, UnicodeLatinMap::CT_upper, 'O', 0, 0x1ee3, 0x1ee2,
    UnicodeLatinMap::AT_horn_and_dot_below, 0 },
  { 0x1ecd, UnicodeLatinMap::CT_lower, 'o', 0, 0x1ecd, 0x1ecc,
    UnicodeLatinMap::AT_dot_below, 0 },
  { 0x1ecc, UnicodeLatinMap::CT_upper, 'O', 0, 0x1ecd, 0x1ecc,
    UnicodeLatinMap::AT_dot_below, 0 },
  { 0x1ed9, UnicodeLatinMap::CT_lower, 'o', 0, 0x1ed9, 0x1ed8,
    UnicodeLatinMap::AT_circumflex_and_dot_below, 0 },
  { 0x1ed8, UnicodeLatinMap::CT_upper, 'O', 0, 0x1ed9, 0x1ed8,
    UnicodeLatinMap::AT_circumflex_and_dot_below, 0 },
  { 0x0153, UnicodeLatinMap::CT_lower, 'o', 'e', 0x0153, 0x0152,
    UnicodeLatinMap::AT_none, UnicodeLatinMap::AF_ligature },
  { 0x0152, UnicodeLatinMap::CT_upper, 'O', 'E', 0x0153, 0x0152,
    UnicodeLatinMap::AT_none, UnicodeLatinMap::AF_ligature },
  { 0x0276, UnicodeLatinMap::CT_upper, 'O', 'E', 0x0153, 0x0276,
    UnicodeLatinMap::AT_none, UnicodeLatinMap::AF_smallcap | UnicodeLatinMap::AF_ligature },
  { 0x00f8, UnicodeLatinMap::CT_lower, 'o', 0, 0x00f8, 0x00d8,
    UnicodeLatinMap::AT_stroke, 0 },
  { 0x00d8, UnicodeLatinMap::CT_upper, 'O', 0, 0x00f8, 0x00d8,
    UnicodeLatinMap::AT_stroke, 0 },
  { 0x01ff, UnicodeLatinMap::CT_lower, 'o', 0, 0x01ff, 0x01fe,
    UnicodeLatinMap::AT_stroke_and_acute, 0 },
  { 0x01fe, UnicodeLatinMap::CT_upper, 'O', 0, 0x01ff, 0x01fe,
    UnicodeLatinMap::AT_stroke_and_acute, 0 },
  { 0x0070, UnicodeLatinMap::CT_lower, 'p', 0, 0x0070, 0x0050,
    UnicodeLatinMap::AT_none, 0 },
  { 0x0050, UnicodeLatinMap::CT_upper, 'P', 0, 0x0070, 0x0050,
    UnicodeLatinMap::AT_none, 0 },
  { 0x1e55, UnicodeLatinMap::CT_lower, 'p', 0, 0x1e55, 0x1e54,
    UnicodeLatinMap::AT_acute, 0 },
  { 0x1e54, UnicodeLatinMap::CT_upper, 'P', 0, 0x1e55, 0x1e54,
    UnicodeLatinMap::AT_acute, 0 },
  { 0x1e57, UnicodeLatinMap::CT_lower, 'p', 0, 0x1e57, 0x1e56,
    UnicodeLatinMap::AT_dot_above, 0 },
  { 0x1e56, UnicodeLatinMap::CT_upper, 'P', 0, 0x1e57, 0x1e56,
    UnicodeLatinMap::AT_dot_above, 0 },
  { 0x01a5, UnicodeLatinMap::CT_lower, 'p', 0, 0x01a5, 0x01a4,
    UnicodeLatinMap::AT_hook, 0 },
  { 0x01a4, UnicodeLatinMap::CT_upper, 'P', 0, 0x01a5, 0x01a4,
    UnicodeLatinMap::AT_hook, 0 },
  { 0x0071, UnicodeLatinMap::CT_lower, 'q', 0, 0x0071, 0x0051,
    UnicodeLatinMap::AT_none, 0 },
  { 0x0051, UnicodeLatinMap::CT_upper, 'Q', 0, 0x0071, 0x0051,
    UnicodeLatinMap::AT_none, 0 },
  { 0x02a0, UnicodeLatinMap::CT_lower, 'q', 0, 0x02a0, 0x0051,
    UnicodeLatinMap::AT_hook, 0 },
  { 0x0072, UnicodeLatinMap::CT_lower, 'r', 0, 0x0072, 0x0052,
    UnicodeLatinMap::AT_none, 0 },
  { 0x0052, UnicodeLatinMap::CT_upper, 'R', 0, 0x0072, 0x0052,
    UnicodeLatinMap::AT_none, 0 },
  { 0x0155, UnicodeLatinMap::CT_lower, 'r', 0, 0x0155, 0x0154,
    UnicodeLatinMap::AT_acute, 0 },
  { 0x0154, UnicodeLatinMap::CT_upper, 'R', 0, 0x0155, 0x0154,
    UnicodeLatinMap::AT_acute, 0 },
  { 0x0159, UnicodeLatinMap::CT_lower, 'r', 0, 0x0159, 0x0158,
    UnicodeLatinMap::AT_caron, 0 },
  { 0x0158, UnicodeLatinMap::CT_upper, 'R', 0, 0x0159, 0x0158,
    UnicodeLatinMap::AT_caron, 0 },
  { 0x1e59, UnicodeLatinMap::CT_lower, 'r', 0, 0x1e59, 0x1e58,
    UnicodeLatinMap::AT_dot_above, 0 },
  { 0x1e58, UnicodeLatinMap::CT_upper, 'R', 0, 0x1e59, 0x1e58,
    UnicodeLatinMap::AT_dot_above, 0 },
  { 0x0157, UnicodeLatinMap::CT_lower, 'r', 0, 0x0157, 0x0156,
    UnicodeLatinMap::AT_cedilla, 0 },
  { 0x0156, UnicodeLatinMap::CT_upper, 'R', 0, 0x0157, 0x0156,
    UnicodeLatinMap::AT_cedilla, 0 },
  { 0x0211, UnicodeLatinMap::CT_lower, 'r', 0, 0x0211, 0x0210,
    UnicodeLatinMap::AT_double_grave, 0 },
  { 0x0210, UnicodeLatinMap::CT_upper, 'R', 0, 0x0211, 0x0210,
    UnicodeLatinMap::AT_double_grave, 0 },
  { 0x0213, UnicodeLatinMap::CT_lower, 'r', 0, 0x0213, 0x0212,
    UnicodeLatinMap::AT_inverted_breve, 0 },
  { 0x0212, UnicodeLatinMap::CT_upper, 'R', 0, 0x0213, 0x0212,
    UnicodeLatinMap::AT_inverted_breve, 0 },
  { 0x1e5b, UnicodeLatinMap::CT_lower, 'r', 0, 0x1e5b, 0x1e5a,
    UnicodeLatinMap::AT_dot_below, 0 },
  { 0x1e5a, UnicodeLatinMap::CT_upper, 'R', 0, 0x1e5b, 0x1e5a,
    UnicodeLatinMap::AT_dot_below, 0 },
  { 0x1e5d, UnicodeLatinMap::CT_lower, 'r', 0, 0x1e5d, 0x1e5c,
    UnicodeLatinMap::AT_dot_below_and_macron, 0 },
  { 0x1e5c, UnicodeLatinMap::CT_upper, 'R', 0, 0x1e5d, 0x1e5c,
    UnicodeLatinMap::AT_dot_below_and_macron, 0 },
  { 0x1e5f, UnicodeLatinMap::CT_lower, 'r', 0, 0x1e5f, 0x1e5e,
    UnicodeLatinMap::AT_line_below, 0 },
  { 0x1e5e, UnicodeLatinMap::CT_upper, 'R', 0, 0x1e5f, 0x1e5e,
    UnicodeLatinMap::AT_line_below, 0 },
  { 0x0280, UnicodeLatinMap::CT_upper, 'R', 0, 0x0072, 0x0280,
    UnicodeLatinMap::AT_none, UnicodeLatinMap::AF_smallcap },
  { 0x0279, UnicodeLatinMap::CT_lower, 'r', 0, 0x0279, 0x0052,
    UnicodeLatinMap::AT_none, UnicodeLatinMap::AF_turned },
  { 0x027b, UnicodeLatinMap::CT_lower, 'r', 0, 0x027b, 0x0052,
    UnicodeLatinMap::AT_hook, UnicodeLatinMap::AF_turned },
  { 0x0281, UnicodeLatinMap::CT_upper, 'R', 0, 0x0072, 0x0281,
    UnicodeLatinMap::AT_none, UnicodeLatinMap::AF_turned | UnicodeLatinMap::AF_smallcap },
  { 0x0073, UnicodeLatinMap::CT_lower, 's', 0, 0x0073, 0x0053,
    UnicodeLatinMap::AT_none, 0 },
  { 0x0053, UnicodeLatinMap::CT_upper, 'S', 0, 0x0073, 0x0053,
    UnicodeLatinMap::AT_none, 0 },
  { 0x015b, UnicodeLatinMap::CT_lower, 's', 0, 0x015b, 0x015a,
    UnicodeLatinMap::AT_acute, 0 },
  { 0x015a, UnicodeLatinMap::CT_upper, 'S', 0, 0x015b, 0x015a,
    UnicodeLatinMap::AT_acute, 0 },
  { 0x1e65, UnicodeLatinMap::CT_lower, 's', 0, 0x1e65, 0x1e64,
    UnicodeLatinMap::AT_acute_and_dot_above, 0 },
  { 0x1e64, UnicodeLatinMap::CT_upper, 'S', 0, 0x1e65, 0x1e64,
    UnicodeLatinMap::AT_acute_and_dot_above, 0 },
  { 0x015d, UnicodeLatinMap::CT_lower, 's', 0, 0x015d, 0x015c,
    UnicodeLatinMap::AT_circumflex, 0 },
  { 0x015c, UnicodeLatinMap::CT_upper, 'S', 0, 0x015d, 0x015c,
    UnicodeLatinMap::AT_circumflex, 0 },
  { 0x0161, UnicodeLatinMap::CT_lower, 's', 0, 0x0161, 0x0160,
    UnicodeLatinMap::AT_caron, 0 },
  { 0x0160, UnicodeLatinMap::CT_upper, 'S', 0, 0x0161, 0x0160,
    UnicodeLatinMap::AT_caron, 0 },
  { 0x1e67, UnicodeLatinMap::CT_lower, 's', 0, 0x1e67, 0x1e66,
    UnicodeLatinMap::AT_caron_and_dot_above, 0 },
  { 0x1e66, UnicodeLatinMap::CT_upper, 'S', 0, 0x1e67, 0x1e66,
    UnicodeLatinMap::AT_caron_and_dot_above, 0 },
  { 0x1e61, UnicodeLatinMap::CT_lower, 's', 0, 0x1e61, 0x1e60,
    UnicodeLatinMap::AT_dot_above, 0 },
  { 0x1e60, UnicodeLatinMap::CT_upper, 'S', 0, 0x1e61, 0x1e60,
    UnicodeLatinMap::AT_dot_above, 0 },
  { 0x015f, UnicodeLatinMap::CT_lower, 's', 0, 0x015f, 0x015e,
    UnicodeLatinMap::AT_cedilla, 0 },
  { 0x015e, UnicodeLatinMap::CT_upper, 'S', 0, 0x015f, 0x015e,
    UnicodeLatinMap::AT_cedilla, 0 },
  { 0x1e63, UnicodeLatinMap::CT_lower, 's', 0, 0x1e63, 0x1e62,
    UnicodeLatinMap::AT_dot_below, 0 },
  { 0x1e62, UnicodeLatinMap::CT_upper, 'S', 0, 0x1e63, 0x1e62,
    UnicodeLatinMap::AT_dot_below, 0 },
  { 0x1e69, UnicodeLatinMap::CT_lower, 's', 0, 0x1e69, 0x1e68,
    UnicodeLatinMap::AT_dot_below_and_dot_above, 0 },
  { 0x1e68, UnicodeLatinMap::CT_upper, 'S', 0, 0x1e69, 0x1e68,
    UnicodeLatinMap::AT_dot_below_and_dot_above, 0 },
  { 0x0219, UnicodeLatinMap::CT_lower, 's', 0, 0x0219, 0x0218,
    UnicodeLatinMap::AT_comma_below, 0 },
  { 0x0218, UnicodeLatinMap::CT_upper, 'S', 0, 0x0219, 0x0218,
    UnicodeLatinMap::AT_comma_below, 0 },
  { 0x00df, UnicodeLatinMap::CT_lower, 's', 's', 0x00df, 0x00df,
    UnicodeLatinMap::AT_none, 0 },
  { 0x0282, UnicodeLatinMap::CT_lower, 's', 0, 0x0282, 0x0053,
    UnicodeLatinMap::AT_hook, 0 },
  { 0x0074, UnicodeLatinMap::CT_lower, 't', 0, 0x0074, 0x0054,
    UnicodeLatinMap::AT_none, 0 },
  { 0x0054, UnicodeLatinMap::CT_upper, 'T', 0, 0x0074, 0x0054,
    UnicodeLatinMap::AT_none, 0 },
  { 0x0165, UnicodeLatinMap::CT_lower, 't', 0, 0x0165, 0x0164,
    UnicodeLatinMap::AT_caron, 0 },
  { 0x0164, UnicodeLatinMap::CT_upper, 'T', 0, 0x0165, 0x0164,
    UnicodeLatinMap::AT_caron, 0 },
  { 0x1e97, UnicodeLatinMap::CT_lower, 't', 0, 0x1e97, 0x0054,
    UnicodeLatinMap::AT_diaeresis, 0 },
  { 0x1e6b, UnicodeLatinMap::CT_lower, 't', 0, 0x1e6b, 0x1e6a,
    UnicodeLatinMap::AT_dot_above, 0 },
  { 0x1e6a, UnicodeLatinMap::CT_upper, 'T', 0, 0x1e6b, 0x1e6a,
    UnicodeLatinMap::AT_dot_above, 0 },
  { 0x0163, UnicodeLatinMap::CT_lower, 't', 0, 0x0163, 0x0162,
    UnicodeLatinMap::AT_cedilla, 0 },
  { 0x0162, UnicodeLatinMap::CT_upper, 'T', 0, 0x0163, 0x0162,
    UnicodeLatinMap::AT_cedilla, 0 },
  { 0x1e6d, UnicodeLatinMap::CT_lower, 't', 0, 0x1e6d, 0x1e6c,
    UnicodeLatinMap::AT_dot_below, 0 },
  { 0x1e6c, UnicodeLatinMap::CT_upper, 'T', 0, 0x1e6d, 0x1e6c,
    UnicodeLatinMap::AT_dot_below, 0 },
  { 0x021b, UnicodeLatinMap::CT_lower, 't', 0, 0x021b, 0x021a,
    UnicodeLatinMap::AT_comma_below, 0 },
  { 0x021a, UnicodeLatinMap::CT_upper, 'T', 0, 0x021b, 0x021a,
    UnicodeLatinMap::AT_comma_below, 0 },
  { 0x1e71, UnicodeLatinMap::CT_lower, 't', 0, 0x1e71, 0x1e70,
    UnicodeLatinMap::AT_circumflex_below, 0 },
  { 0x1e70, UnicodeLatinMap::CT_upper, 'T', 0, 0x1e71, 0x1e70,
    UnicodeLatinMap::AT_circumflex_below, 0 },
  { 0x1e6f, UnicodeLatinMap::CT_lower, 't', 0, 0x1e6f, 0x1e6e,
    UnicodeLatinMap::AT_line_below, 0 },
  { 0x1e6e, UnicodeLatinMap::CT_upper, 'T', 0, 0x1e6f, 0x1e6e,
    UnicodeLatinMap::AT_line_below, 0 },
  { 0x0167, UnicodeLatinMap::CT_lower, 't', 0, 0x0167, 0x0166,
    UnicodeLatinMap::AT_stroke, 0 },
  { 0x0166, UnicodeLatinMap::CT_upper, 'T', 0, 0x0167, 0x0166,
    UnicodeLatinMap::AT_stroke, 0 },
  { 0x01ad, UnicodeLatinMap::CT_lower, 't', 0, 0x01ad, 0x01ac,
    UnicodeLatinMap::AT_hook, 0 },
  { 0x01ac, UnicodeLatinMap::CT_upper, 'T', 0, 0x01ad, 0x01ac,
    UnicodeLatinMap::AT_hook, 0 },
  { 0x0287, UnicodeLatinMap::CT_lower, 't', 0, 0x0287, 0x0054,
    UnicodeLatinMap::AT_none, UnicodeLatinMap::AF_turned },
  { 0x0075, UnicodeLatinMap::CT_lower, 'u', 0, 0x0075, 0x0055,
    UnicodeLatinMap::AT_none, 0 },
  { 0x0055, UnicodeLatinMap::CT_upper, 'U', 0, 0x0075, 0x0055,
    UnicodeLatinMap::AT_none, 0 },
  { 0x00fa, UnicodeLatinMap::CT_lower, 'u', 0, 0x00fa, 0x00da,
    UnicodeLatinMap::AT_acute, 0 },
  { 0x00da, UnicodeLatinMap::CT_upper, 'U', 0, 0x00fa, 0x00da,
    UnicodeLatinMap::AT_acute, 0 },
  { 0x00f9, UnicodeLatinMap::CT_lower, 'u', 0, 0x00f9, 0x00d9,
    UnicodeLatinMap::AT_grave, 0 },
  { 0x00d9, UnicodeLatinMap::CT_upper, 'U', 0, 0x00f9, 0x00d9,
    UnicodeLatinMap::AT_grave, 0 },
  { 0x016d, UnicodeLatinMap::CT_lower, 'u', 0, 0x016d, 0x016c,
    UnicodeLatinMap::AT_breve, 0 },
  { 0x016c, UnicodeLatinMap::CT_upper, 'U', 0, 0x016d, 0x016c,
    UnicodeLatinMap::AT_breve, 0 },
  { 0x00fb, UnicodeLatinMap::CT_lower, 'u', 0, 0x00fb, 0x00db,
    UnicodeLatinMap::AT_circumflex, 0 },
  { 0x00db, UnicodeLatinMap::CT_upper, 'U', 0, 0x00fb, 0x00db,
    UnicodeLatinMap::AT_circumflex, 0 },
  { 0x01d4, UnicodeLatinMap::CT_lower, 'u', 0, 0x01d4, 0x01d3,
    UnicodeLatinMap::AT_caron, 0 },
  { 0x01d3, UnicodeLatinMap::CT_upper, 'U', 0, 0x01d4, 0x01d3,
    UnicodeLatinMap::AT_caron, 0 },
  { 0x016f, UnicodeLatinMap::CT_lower, 'u', 0, 0x016f, 0x016e,
    UnicodeLatinMap::AT_ring_above, 0 },
  { 0x016e, UnicodeLatinMap::CT_upper, 'U', 0, 0x016f, 0x016e,
    UnicodeLatinMap::AT_ring_above, 0 },
  { 0x00fc, UnicodeLatinMap::CT_lower, 'u', 0, 0x00fc, 0x00dc,
    UnicodeLatinMap::AT_diaeresis, 0 },
  { 0x00dc, UnicodeLatinMap::CT_upper, 'U', 0, 0x00fc, 0x00dc,
    UnicodeLatinMap::AT_diaeresis, 0 },
  { 0x01d8, UnicodeLatinMap::CT_lower, 'u', 0, 0x01d8, 0x01d7,
    UnicodeLatinMap::AT_diaeresis_and_acute, 0 },
  { 0x01d7, UnicodeLatinMap::CT_upper, 'U', 0, 0x01d8, 0x01d7,
    UnicodeLatinMap::AT_diaeresis_and_acute, 0 },
  { 0x01dc, UnicodeLatinMap::CT_lower, 'u', 0, 0x01dc, 0x01db,
    UnicodeLatinMap::AT_diaeresis_and_grave, 0 },
  { 0x01db, UnicodeLatinMap::CT_upper, 'U', 0, 0x01dc, 0x01db,
    UnicodeLatinMap::AT_diaeresis_and_grave, 0 },
  { 0x01da, UnicodeLatinMap::CT_lower, 'u', 0, 0x01da, 0x01d9,
    UnicodeLatinMap::AT_diaeresis_and_caron, 0 },
  { 0x01d9, UnicodeLatinMap::CT_upper, 'U', 0, 0x01da, 0x01d9,
    UnicodeLatinMap::AT_diaeresis_and_caron, 0 },
  { 0x01d6, UnicodeLatinMap::CT_lower, 'u', 0, 0x01d6, 0x01d5,
    UnicodeLatinMap::AT_diaeresis_and_macron, 0 },
  { 0x01d5, UnicodeLatinMap::CT_upper, 'U', 0, 0x01d6, 0x01d5,
    UnicodeLatinMap::AT_diaeresis_and_macron, 0 },
  { 0x0171, UnicodeLatinMap::CT_lower, 'u', 0, 0x0171, 0x0170,
    UnicodeLatinMap::AT_double_acute, 0 },
  { 0x0170, UnicodeLatinMap::CT_upper, 'U', 0, 0x0171, 0x0170,
    UnicodeLatinMap::AT_double_acute, 0 },
  { 0x0169, UnicodeLatinMap::CT_lower, 'u', 0, 0x0169, 0x0168,
    UnicodeLatinMap::AT_tilde, 0 },
  { 0x0168, UnicodeLatinMap::CT_upper, 'U', 0, 0x0169, 0x0168,
    UnicodeLatinMap::AT_tilde, 0 },
  { 0x1e79, UnicodeLatinMap::CT_lower, 'u', 0, 0x1e79, 0x1e78,
    UnicodeLatinMap::AT_tilde_and_acute, 0 },
  { 0x1e78, UnicodeLatinMap::CT_upper, 'U', 0, 0x1e79, 0x1e78,
    UnicodeLatinMap::AT_tilde_and_acute, 0 },
  { 0x0173, UnicodeLatinMap::CT_lower, 'u', 0, 0x0173, 0x0172,
    UnicodeLatinMap::AT_ogonek, 0 },
  { 0x0172, UnicodeLatinMap::CT_upper, 'U', 0, 0x0173, 0x0172,
    UnicodeLatinMap::AT_ogonek, 0 },
  { 0x016b, UnicodeLatinMap::CT_lower, 'u', 0, 0x016b, 0x016a,
    UnicodeLatinMap::AT_macron, 0 },
  { 0x016a, UnicodeLatinMap::CT_upper, 'U', 0, 0x016b, 0x016a,
    UnicodeLatinMap::AT_macron, 0 },
  { 0x1e7b, UnicodeLatinMap::CT_lower, 'u', 0, 0x1e7b, 0x1e7a,
    UnicodeLatinMap::AT_macron_and_diaeresis, 0 },
  { 0x1e7a, UnicodeLatinMap::CT_upper, 'U', 0, 0x1e7b, 0x1e7a,
    UnicodeLatinMap::AT_macron_and_diaeresis, 0 },
  { 0x1ee7, UnicodeLatinMap::CT_lower, 'u', 0, 0x1ee7, 0x1ee6,
    UnicodeLatinMap::AT_hook_above, 0 },
  { 0x1ee6, UnicodeLatinMap::CT_upper, 'U', 0, 0x1ee7, 0x1ee6,
    UnicodeLatinMap::AT_hook_above, 0 },
  { 0x0215, UnicodeLatinMap::CT_lower, 'u', 0, 0x0215, 0x0214,
    UnicodeLatinMap::AT_double_grave, 0 },
  { 0x0214, UnicodeLatinMap::CT_upper, 'U', 0, 0x0215, 0x0214,
    UnicodeLatinMap::AT_double_grave, 0 },
  { 0x0217, UnicodeLatinMap::CT_lower, 'u', 0, 0x0217, 0x0216,
    UnicodeLatinMap::AT_inverted_breve, 0 },
  { 0x0216, UnicodeLatinMap::CT_upper, 'U', 0, 0x0217, 0x0216,
    UnicodeLatinMap::AT_inverted_breve, 0 },
  { 0x01b0, UnicodeLatinMap::CT_lower, 'u', 0, 0x01b0, 0x01af,
    UnicodeLatinMap::AT_horn, 0 },
  { 0x01af, UnicodeLatinMap::CT_upper, 'U', 0, 0x01b0, 0x01af,
    UnicodeLatinMap::AT_horn, 0 },
  { 0x1ee9, UnicodeLatinMap::CT_lower, 'u', 0, 0x1ee9, 0x1ee8,
    UnicodeLatinMap::AT_horn_and_acute, 0 },
  { 0x1ee8, UnicodeLatinMap::CT_upper, 'U', 0, 0x1ee9, 0x1ee8,
    UnicodeLatinMap::AT_horn_and_acute, 0 },
  { 0x1eeb, UnicodeLatinMap::CT_lower, 'u', 0, 0x1eeb, 0x1eea,
    UnicodeLatinMap::AT_horn_and_grave, 0 },
  { 0x1eea, UnicodeLatinMap::CT_upper, 'U', 0, 0x1eeb, 0x1eea,
    UnicodeLatinMap::AT_horn_and_grave, 0 },
  { 0x1eef, UnicodeLatinMap::CT_lower, 'u', 0, 0x1eef, 0x1eee,
    UnicodeLatinMap::AT_horn_and_tilde, 0 },
  { 0x1eee, UnicodeLatinMap::CT_upper, 'U', 0, 0x1eef, 0x1eee,
    UnicodeLatinMap::AT_horn_and_tilde, 0 },
  { 0x1eed, UnicodeLatinMap::CT_lower, 'u', 0, 0x1eed, 0x1eec,
    UnicodeLatinMap::AT_horn_and_hook_above, 0 },
  { 0x1eec, UnicodeLatinMap::CT_upper, 'U', 0, 0x1eed, 0x1eec,
    UnicodeLatinMap::AT_horn_and_hook_above, 0 },
  { 0x1ef1, UnicodeLatinMap::CT_lower, 'u', 0, 0x1ef1, 0x1ef0,
    UnicodeLatinMap::AT_horn_and_dot_below, 0 },
  { 0x1ef0, UnicodeLatinMap::CT_upper, 'U', 0, 0x1ef1, 0x1ef0,
    UnicodeLatinMap::AT_horn_and_dot_below, 0 },
  { 0x1ee5, UnicodeLatinMap::CT_lower, 'u', 0, 0x1ee5, 0x1ee4,
    UnicodeLatinMap::AT_dot_below, 0 },
  { 0x1ee4, UnicodeLatinMap::CT_upper, 'U', 0, 0x1ee5, 0x1ee4,
    UnicodeLatinMap::AT_dot_below, 0 },
  { 0x1e73, UnicodeLatinMap::CT_lower, 'u', 0, 0x1e73, 0x1e72,
    UnicodeLatinMap::AT_diaeresis_below, 0 },
  { 0x1e72, UnicodeLatinMap::CT_upper, 'U', 0, 0x1e73, 0x1e72,
    UnicodeLatinMap::AT_diaeresis_below, 0 },
  { 0x1e77, UnicodeLatinMap::CT_lower, 'u', 0, 0x1e77, 0x1e76,
    UnicodeLatinMap::AT_circumflex_below, 0 },
  { 0x1e76, UnicodeLatinMap::CT_upper, 'U', 0, 0x1e77, 0x1e76,
    UnicodeLatinMap::AT_circumflex_below, 0 },
  { 0x1e75, UnicodeLatinMap::CT_lower, 'u', 0, 0x1e75, 0x1e74,
    UnicodeLatinMap::AT_tilde_below, 0 },
  { 0x1e74, UnicodeLatinMap::CT_upper, 'U', 0, 0x1e75, 0x1e74,
    UnicodeLatinMap::AT_tilde_below, 0 },
  { 0x0265, UnicodeLatinMap::CT_lower, 'h', 0, 0x0265, 0x0048,
    UnicodeLatinMap::AT_none, UnicodeLatinMap::AF_turned },
  { 0x026f, UnicodeLatinMap::CT_lower, 'm', 0, 0x026f, 0x019c,
    UnicodeLatinMap::AT_none, UnicodeLatinMap::AF_turned },
  { 0x019c, UnicodeLatinMap::CT_upper, 'M', 0, 0x026f, 0x019c,
    UnicodeLatinMap::AT_none, UnicodeLatinMap::AF_turned },
  { 0x0076, UnicodeLatinMap::CT_lower, 'v', 0, 0x0076, 0x0056,
    UnicodeLatinMap::AT_none, 0 },
  { 0x0056, UnicodeLatinMap::CT_upper, 'V', 0, 0x0076, 0x0056,
    UnicodeLatinMap::AT_none, 0 },
  { 0x1e7d, UnicodeLatinMap::CT_lower, 'v', 0, 0x1e7d, 0x1e7c,
    UnicodeLatinMap::AT_tilde, 0 },
  { 0x1e7c, UnicodeLatinMap::CT_upper, 'V', 0, 0x1e7d, 0x1e7c,
    UnicodeLatinMap::AT_tilde, 0 },
  { 0x1e7f, UnicodeLatinMap::CT_lower, 'v', 0, 0x1e7f, 0x1e7e,
    UnicodeLatinMap::AT_dot_below, 0 },
  { 0x1e7e, UnicodeLatinMap::CT_upper, 'V', 0, 0x1e7f, 0x1e7e,
    UnicodeLatinMap::AT_dot_below, 0 },
  { 0x028b, UnicodeLatinMap::CT_lower, 'v', 0, 0x028b, 0x01b2,
    UnicodeLatinMap::AT_hook, 0 },
  { 0x01b2, UnicodeLatinMap::CT_upper, 'V', 0, 0x028b, 0x01b2,
    UnicodeLatinMap::AT_hook, 0 },
  { 0x028c, UnicodeLatinMap::CT_lower, 'v', 0, 0x028c, 0x0056,
    UnicodeLatinMap::AT_none, UnicodeLatinMap::AF_turned },
  { 0x0077, UnicodeLatinMap::CT_lower, 'w', 0, 0x0077, 0x0057,
    UnicodeLatinMap::AT_none, 0 },
  { 0x0057, UnicodeLatinMap::CT_upper, 'W', 0, 0x0077, 0x0057,
    UnicodeLatinMap::AT_none, 0 },
  { 0x1e83, UnicodeLatinMap::CT_lower, 'w', 0, 0x1e83, 0x1e82,
    UnicodeLatinMap::AT_acute, 0 },
  { 0x1e82, UnicodeLatinMap::CT_upper, 'W', 0, 0x1e83, 0x1e82,
    UnicodeLatinMap::AT_acute, 0 },
  { 0x1e81, UnicodeLatinMap::CT_lower, 'w', 0, 0x1e81, 0x1e80,
    UnicodeLatinMap::AT_grave, 0 },
  { 0x1e80, UnicodeLatinMap::CT_upper, 'W', 0, 0x1e81, 0x1e80,
    UnicodeLatinMap::AT_grave, 0 },
  { 0x0175, UnicodeLatinMap::CT_lower, 'w', 0, 0x0175, 0x0174,
    UnicodeLatinMap::AT_circumflex, 0 },
  { 0x0174, UnicodeLatinMap::CT_upper, 'W', 0, 0x0175, 0x0174,
    UnicodeLatinMap::AT_circumflex, 0 },
  { 0x1e98, UnicodeLatinMap::CT_lower, 'w', 0, 0x1e98, 0x0057,
    UnicodeLatinMap::AT_ring_above, 0 },
  { 0x1e85, UnicodeLatinMap::CT_lower, 'w', 0, 0x1e85, 0x1e84,
    UnicodeLatinMap::AT_diaeresis, 0 },
  { 0x1e84, UnicodeLatinMap::CT_upper, 'W', 0, 0x1e85, 0x1e84,
    UnicodeLatinMap::AT_diaeresis, 0 },
  { 0x1e87, UnicodeLatinMap::CT_lower, 'w', 0, 0x1e87, 0x1e86,
    UnicodeLatinMap::AT_dot_above, 0 },
  { 0x1e86, UnicodeLatinMap::CT_upper, 'W', 0, 0x1e87, 0x1e86,
    UnicodeLatinMap::AT_dot_above, 0 },
  { 0x1e89, UnicodeLatinMap::CT_lower, 'w', 0, 0x1e89, 0x1e88,
    UnicodeLatinMap::AT_dot_below, 0 },
  { 0x1e88, UnicodeLatinMap::CT_upper, 'W', 0, 0x1e89, 0x1e88,
    UnicodeLatinMap::AT_dot_below, 0 },
  { 0x028d, UnicodeLatinMap::CT_lower, 'w', 0, 0x028d, 0x0057,
    UnicodeLatinMap::AT_none, UnicodeLatinMap::AF_turned },
  { 0x0078, UnicodeLatinMap::CT_lower, 'x', 0, 0x0078, 0x0058,
    UnicodeLatinMap::AT_none, 0 },
  { 0x0058, UnicodeLatinMap::CT_upper, 'X', 0, 0x0078, 0x0058,
    UnicodeLatinMap::AT_none, 0 },
  { 0x1e8d, UnicodeLatinMap::CT_lower, 'x', 0, 0x1e8d, 0x1e8c,
    UnicodeLatinMap::AT_diaeresis, 0 },
  { 0x1e8c, UnicodeLatinMap::CT_upper, 'X', 0, 0x1e8d, 0x1e8c,
    UnicodeLatinMap::AT_diaeresis, 0 },
  { 0x1e8b, UnicodeLatinMap::CT_lower, 'x', 0, 0x1e8b, 0x1e8a,
    UnicodeLatinMap::AT_dot_above, 0 },
  { 0x1e8a, UnicodeLatinMap::CT_upper, 'X', 0, 0x1e8b, 0x1e8a,
    UnicodeLatinMap::AT_dot_above, 0 },
  { 0x0079, UnicodeLatinMap::CT_lower, 'y', 0, 0x0079, 0x0059,
    UnicodeLatinMap::AT_none, 0 },
  { 0x0059, UnicodeLatinMap::CT_upper, 'Y', 0, 0x0079, 0x0059,
    UnicodeLatinMap::AT_none, 0 },
  { 0x00fd, UnicodeLatinMap::CT_lower, 'y', 0, 0x00fd, 0x00dd,
    UnicodeLatinMap::AT_acute, 0 },
  { 0x00dd, UnicodeLatinMap::CT_upper, 'Y', 0, 0x00fd, 0x00dd,
    UnicodeLatinMap::AT_acute, 0 },
  { 0x1ef3, UnicodeLatinMap::CT_lower, 'y', 0, 0x1ef3, 0x1ef2,
    UnicodeLatinMap::AT_grave, 0 },
  { 0x1ef2, UnicodeLatinMap::CT_upper, 'Y', 0, 0x1ef3, 0x1ef2,
    UnicodeLatinMap::AT_grave, 0 },
  { 0x0177, UnicodeLatinMap::CT_lower, 'y', 0, 0x0177, 0x0176,
    UnicodeLatinMap::AT_circumflex, 0 },
  { 0x0176, UnicodeLatinMap::CT_upper, 'Y', 0, 0x0177, 0x0176,
    UnicodeLatinMap::AT_circumflex, 0 },
  { 0x1e99, UnicodeLatinMap::CT_lower, 'y', 0, 0x1e99, 0x0059,
    UnicodeLatinMap::AT_ring_above, 0 },
  { 0x00ff, UnicodeLatinMap::CT_lower, 'y', 0, 0x00ff, 0x0178,
    UnicodeLatinMap::AT_diaeresis, 0 },
  { 0x0178, UnicodeLatinMap::CT_upper, 'Y', 0, 0x00ff, 0x0178,
    UnicodeLatinMap::AT_diaeresis, 0 },
  { 0x1ef9, UnicodeLatinMap::CT_lower, 'y', 0, 0x1ef9, 0x1ef8,
    UnicodeLatinMap::AT_tilde, 0 },
  { 0x1ef8, UnicodeLatinMap::CT_upper, 'Y', 0, 0x1ef9, 0x1ef8,
    UnicodeLatinMap::AT_tilde, 0 },
  { 0x1e8f, UnicodeLatinMap::CT_lower, 'y', 0, 0x1e8f, 0x1e8e,
    UnicodeLatinMap::AT_dot_above, 0 },
  { 0x1e8e, UnicodeLatinMap::CT_upper, 'Y', 0, 0x1e8f, 0x1e8e,
    UnicodeLatinMap::AT_dot_above, 0 },
  { 0x0233, UnicodeLatinMap::CT_lower, 'y', 0, 0x0233, 0x0232,
    UnicodeLatinMap::AT_macron, 0 },
  { 0x0232, UnicodeLatinMap::CT_upper, 'Y', 0, 0x0233, 0x0232,
    UnicodeLatinMap::AT_macron, 0 },
  { 0x1ef7, UnicodeLatinMap::CT_lower, 'y', 0, 0x1ef7, 0x1ef6,
    UnicodeLatinMap::AT_hook_above, 0 },
  { 0x1ef6, UnicodeLatinMap::CT_upper, 'Y', 0, 0x1ef7, 0x1ef6,
    UnicodeLatinMap::AT_hook_above, 0 },
  { 0x1ef5, UnicodeLatinMap::CT_lower, 'y', 0, 0x1ef5, 0x1ef4,
    UnicodeLatinMap::AT_dot_below, 0 },
  { 0x1ef4, UnicodeLatinMap::CT_upper, 'Y', 0, 0x1ef5, 0x1ef4,
    UnicodeLatinMap::AT_dot_below, 0 },
  { 0x028f, UnicodeLatinMap::CT_upper, 'Y', 0, 0x0079, 0x028f,
    UnicodeLatinMap::AT_none, UnicodeLatinMap::AF_smallcap },
  { 0x01b4, UnicodeLatinMap::CT_lower, 'y', 0, 0x01b4, 0x01b3,
    UnicodeLatinMap::AT_hook, 0 },
  { 0x01b3, UnicodeLatinMap::CT_upper, 'Y', 0, 0x01b4, 0x01b3,
    UnicodeLatinMap::AT_hook, 0 },
  { 0x007a, UnicodeLatinMap::CT_lower, 'z', 0, 0x007a, 0x005a,
    UnicodeLatinMap::AT_none, 0 },
  { 0x005a, UnicodeLatinMap::CT_upper, 'Z', 0, 0x007a, 0x005a,
    UnicodeLatinMap::AT_none, 0 },
  { 0x017a, UnicodeLatinMap::CT_lower, 'z', 0, 0x017a, 0x0179,
    UnicodeLatinMap::AT_acute, 0 },
  { 0x0179, UnicodeLatinMap::CT_upper, 'Z', 0, 0x017a, 0x0179,
    UnicodeLatinMap::AT_acute, 0 },
  { 0x1e91, UnicodeLatinMap::CT_lower, 'z', 0, 0x1e91, 0x1e90,
    UnicodeLatinMap::AT_circumflex, 0 },
  { 0x1e90, UnicodeLatinMap::CT_upper, 'Z', 0, 0x1e91, 0x1e90,
    UnicodeLatinMap::AT_circumflex, 0 },
  { 0x017e, UnicodeLatinMap::CT_lower, 'z', 0, 0x017e, 0x017d,
    UnicodeLatinMap::AT_caron, 0 },
  { 0x017d, UnicodeLatinMap::CT_upper, 'Z', 0, 0x017e, 0x017d,
    UnicodeLatinMap::AT_caron, 0 },
  { 0x017c, UnicodeLatinMap::CT_lower, 'z', 0, 0x017c, 0x017b,
    UnicodeLatinMap::AT_dot_above, 0 },
  { 0x017b, UnicodeLatinMap::CT_upper, 'Z', 0, 0x017c, 0x017b,
    UnicodeLatinMap::AT_dot_above, 0 },
  { 0x1e93, UnicodeLatinMap::CT_lower, 'z', 0, 0x1e93, 0x1e92,
    UnicodeLatinMap::AT_dot_below, 0 },
  { 0x1e92, UnicodeLatinMap::CT_upper, 'Z', 0, 0x1e93, 0x1e92,
    UnicodeLatinMap::AT_dot_below, 0 },
  { 0x1e95, UnicodeLatinMap::CT_lower, 'z', 0, 0x1e95, 0x1e94,
    UnicodeLatinMap::AT_line_below, 0 },
  { 0x1e94, UnicodeLatinMap::CT_upper, 'Z', 0, 0x1e95, 0x1e94,
    UnicodeLatinMap::AT_line_below, 0 },
  { 0x01b6, UnicodeLatinMap::CT_lower, 'z', 0, 0x01b6, 0x01b5,
    UnicodeLatinMap::AT_stroke, 0 },
  { 0x01b5, UnicodeLatinMap::CT_upper, 'Z', 0, 0x01b6, 0x01b5,
    UnicodeLatinMap::AT_stroke, 0 },
  { 0x0225, UnicodeLatinMap::CT_lower, 'z', 0, 0x0225, 0x0224,
    UnicodeLatinMap::AT_hook, 0 },
  { 0x0224, UnicodeLatinMap::CT_upper, 'Z', 0, 0x0225, 0x0224,
    UnicodeLatinMap::AT_hook, 0 },
  { 0x0291, UnicodeLatinMap::CT_lower, 'z', 0, 0x0291, 0x005a,
    UnicodeLatinMap::AT_curl, 0 },
};
#ifndef CPPPARSER
static const size_t latin_map_length = sizeof(latin_map) / sizeof(UnicodeLatinMap::Entry);
#endif

static const wchar_t combining_accent_map[] = {
  0x0000, // none
  0x0301, // acute
  0x0000, // acute_and_dot_above
  0x0306, // breve
  0x0000, // breve_and_acute
  0x0000, // breve_and_dot_below
  0x0000, // breve_and_grave
  0x0000, // breve_and_hook_above
  0x0000, // breve_and_tilde
  0x032e, // breve_below
  0x030c, // caron
  0x0000, // caron_and_dot_above
  0x0327, // cedilla
  0x0000, // cedilla_and_acute
  0x0000, // cedilla_and_breve
  0x0302, // circumflex
  0x0000, // circumflex_and_acute
  0x0000, // circumflex_and_dot_below
  0x0000, // circumflex_and_grave
  0x0000, // circumflex_and_hook_above
  0x0000, // circumflex_and_tilde
  0x032d, // circumflex_below
  0x0326, // comma_below
  0x0000, // curl
  0x0308, // diaeresis
  0x0000, // diaeresis_and_acute
  0x0000, // diaeresis_and_caron
  0x0000, // diaeresis_and_grave
  0x0000, // diaeresis_and_macron
  0x0324, // diaeresis_below
  0x0307, // dot_above
  0x0000, // dot_above_and_macron
  0x0323, // dot_below
  0x0000, // dot_below_and_dot_above
  0x0000, // dot_below_and_macron
  0x030b, // double_acute
  0x030f, // double_grave
  0x0300, // grave
  0x0328, // hook
  0x0309, // hook_above
  0x031b, // horn
  0x0000, // horn_and_acute
  0x0000, // horn_and_dot_below
  0x0000, // horn_and_grave
  0x0000, // horn_and_hook_above
  0x0000, // horn_and_tilde
  0x0311, // inverted_breve
  0x0000, // line_below
  0x0304, // macron
  0x0000, // macron_and_acute
  0x0000, // macron_and_diaeresis
  0x0000, // macron_and_grave
  0x0328, // ogonek
  0x0000, // ogonek_and_macron
  0x030a, // ring_above
  0x0000, // ring_above_and_acute
  0x0325, // ring_below
  0x0000, // stroke
  0x0000, // stroke_and_acute
  0x0000, // stroke_and_hook
  0x0303, // tilde
  0x0000, // tilde_and_acute
  0x0000, // tilde_and_diaeresis
  0x0000, // tilde_and_macron
  0x0330, // tilde_below
  0x0000, // topbar
};

/**
 * Returns the Entry associated with the indicated character, if there is one.
 */
const UnicodeLatinMap::Entry *UnicodeLatinMap::
look_up(char32_t character) {
  if (!_initialized) {
    init();
  }

  if (character < max_direct_chars) {
    return _direct_chars[character];

  } else {
    ByCharacter::const_iterator ci;
    ci = _by_character->find(character);
    if (ci != _by_character->end()) {
      return (*ci).second;
    }
    return nullptr;
  }
}

/**
 * Returns the unicode code point for the combining character corresponding
 * with the given accent type, or 0 if none is recorded.
 */
wchar_t UnicodeLatinMap::
get_combining_accent(AccentType accent) {
  return combining_accent_map[(size_t)accent];
}

/**
 * Initializes the map, if it has not already been initialized.
 */
void UnicodeLatinMap::
init() {
  if (!_initialized) {
    _by_character = new ByCharacter;
    for (size_t i = 0; i < latin_map_length; i++) {
      const UnicodeLatinMap::Entry *entry = &latin_map[i];

      // The first 256 characters are very common in Latin-alphabet languages,
      // so index those in an array for superfast lookup.  Everything else
      // goes into the map.
      if (entry->_character < max_direct_chars) {
        _direct_chars[entry->_character] = entry;
      } else {
        (*_by_character)[entry->_character] = entry;
      }
    }
    _initialized = true;
  }
}
